/*

	MGR.H

   Oliver Kraus
   kraus@lrs.e-technik.uni-erlangen.de

*/

#ifndef _MGR_H
#define _MGR_H

#include "bmf.h"

#define MGR_PREC 16

struct _mgr_struct
{
	long width;
	long height;
	long bytes_per_line;
	long bitmap_size;
	unsigned char *bitmap_ptr;
	unsigned char *compressed_line;
	long brush_width;
	long brush_height;
	long brush_xm;
	long brush_ym;
	long brush_bytes_per_line;
	long brush_last_r;
	unsigned char *brush_pat;
	unsigned char *brush_ptr;

	bmf_type bmf;

	long x_char_offset;
};
typedef struct _mgr_struct mgr_struct;
typedef struct _mgr_struct *mgr_type;



mgr_type mgr_Open(long width, long height);
void mgr_Close(mgr_type mgr);
int mgr_ClrMap(mgr_type mgr);
int mgr_SetPixel(mgr_type mgr, long x, long y);
int mgr_ClrPixel(mgr_type mgr, long x, long y);
int mgr_SetLine(mgr_type mgr, long x1, long y1, long x2, long y2 );
int mgr_SetString(mgr_type mgr, long x, long y, char *s);
int mgr_SetCircle(mgr_type mgr, long xm, long ym, long r);
int mgr_WritePCX(mgr_type mgr, char *name, unsigned dpi);
int mgr_WriteLaserjet(mgr_type mgr, unsigned lpt, unsigned dpi, unsigned left);
int mgr_WriteCompressedLaserjet(mgr_type mgr, unsigned lpt, unsigned dpi, unsigned left);

int mgr_OpenBrush(mgr_type mgr, long width, long height);
int mgr_MakeEmptyBrush(mgr_type mgr);
int mgr_MakeDiskBrush(mgr_type mgr, long r);
int mgr_DrawBrush(mgr_type mgr, long x, long y);
int mgr_SetLineBrush(mgr_type mgr, long x1, long y1, long x2, long y2 );
#define mgr_SetBrushPat(mgr, pat) ((mgr)->brush_pat = (pat))
int mgr_SetCircleBrush(mgr_type mgr, long xm, long ym, long r);

long mgr_GetFontHeight(mgr_type mgr);
#define mgr_SetFont(mgr,fnt) ((mgr)->bmf = (fnt))
long mgr_SetFontHeight(mgr_type mgr, long new_height);
long mgr_GetStringWidth(mgr_type mgr, char *s);

#pragma pack(1)

struct _pcxhdr_struct
{
	unsigned char  nanufacturer;   /* 10 = ZSoft .pcx */
	unsigned char  version;        /* 2 = Mono PCX */
	unsigned char  encoding;       /* 1 = .PCX run length encoding */
	unsigned char  bits_per_pixel;
	unsigned short xmin;
	unsigned short ymin;
	unsigned short xmax;
	unsigned short ymax;

	unsigned short hres;           /* dpi */
	unsigned short vres;           /* dpi */

	unsigned char  rgb[16][3];
	unsigned char  reserved;
	unsigned char  nplanes;        /* Number of color planes (1) */
	unsigned short bytes_per_line; /* No of bytes to allocate for a scanline */
	unsigned short paltype;        /* 1 = Color/BW, 2 = Grayscale*/
	unsigned short hsize;
	unsigned short vsize;
	unsigned char  filler[54];
};
typedef struct _pcxhdr_struct pcxhdr_struct;

#pragma pack()


extern unsigned char brush_pat0[16];
extern unsigned char brush_pat1[16];
extern unsigned char brush_pat2[16];
extern unsigned char brush_pat3[16];

#endif /* _MGR_H */
