//list Duke Nukem 3D GRP file entries, version 0.9
//version 0 by Bo Yang
#include <stdio.h>
#include <stdlib.h>

char StartUpMessage[]={"Duke Nukem 3D GRP file index lister v0.9 by Bo Yang"};
char DN3GrpSig[12];

main(int argc,char**argv)
{FILE*dukef;
 //total number of entries in index; size/offset of an entry
 long IdxCnt,EntrySize,EntryOffset;
 char EntryName[12];

 puts(StartUpMessage);
 if (argc<2) {
   puts("usage: dn3idx Duke-Nukem-3D-group-file-name"); return(1);
 }
 dukef=fopen(argv[1],"rb"); //read binary
 if (dukef==NULL) {
   puts("can't open input file"); return(2);
 }
 fread(DN3GrpSig,12,1,dukef);
 fread((char*)&IdxCnt,4,1,dukef);
 printf("\nfile signature: %.12s, entry count: %ld (%lXh)\n\n",
         DN3GrpSig,IdxCnt,IdxCnt);
 puts("  entry name   offset     size");
 EntryOffset=(IdxCnt+1)<<4;
 while (IdxCnt--) {
   fread(EntryName,12,1,dukef);
   fread((char*)&EntrySize,4,1,dukef);
   printf("%12.12s %8lX %8lX\n",EntryName,EntryOffset,EntrySize);
   EntryOffset+=EntrySize;
 }
 fclose(dukef); return(0);
}
