//WARNING: MUST COMPILE IN SMALL MODEL, LINK WITH DN3ASM
//view Duke Nuk'em 3D graphics, version 0.9 by Bo Yang
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int WriteHSIFile(FILE*,long,int,int,int),ScanParameter(int,char**);
int DrawOneLine(FILE*,int,int,int),ShowArtData(FILE*,long,long);
long SearchData(FILE*,char*,long*);
int InitDuke3DPal(FILE*);

long DN3DIdxCnt;
unsigned char PalLookUp[256],PalBuf[768],InBuf[16384],DN3GrpSig[12];
char StartUpMessage[]={"\nDuke Nuk'em 3D graphics viewer v0.9 by Bo Yang"};
int ClrLow,ClrHigh,PalLU=-1,ImageSoFar=0,LastStrLen=1;
int SkipImage=0,SkipArtIdx=0; //they can't both can be non-zero
int ArtIdxSoFar=0;
char fGraphOnly=0,fShowOffset=0;

main(int argc,char**argv)
{FILE*dukef;
 long EntrySize,EntryOffset,ll0;
 char EntryName[13];
 int li0;

 puts(StartUpMessage);
 argc=ScanParameter(argc,argv);
 if (argc<2) {
   puts("usage: dn3vg [switches] Duke-Nukem-3D-GRP-file-name [switches]");
   return(1);
 }
 dukef=fopen(argv[1],"rb"); //read binary
 if (dukef==NULL) { puts("can't open input file"); return(2); }
 fread(DN3GrpSig,12,1,dukef);
 fread((char*)&DN3DIdxCnt,4,1,dukef);
 if (InitDuke3DPal(dukef)) { fclose(dukef); return(3); }

 EntryName[12]=0; EntryOffset=(DN3DIdxCnt+1)<<4;
 fseek(dukef,16L,0);
 InitVideo();

 for (ll0=0;ll0<DN3DIdxCnt;ll0++,EntryOffset+=EntrySize) {
   fread(EntryName,12,1,dukef);
   fread((char*)&EntrySize,4,1,dukef);
   li0=strlen(EntryName);
   if (li0<5) continue; //find all entries with extension ART
   if (EntryName[li0-4]!='.') continue;
   if (EntryName[li0-3]!='a' && EntryName[li0-3]!='A') continue;
   if (EntryName[li0-2]!='r' && EntryName[li0-2]!='R') continue;
   if (EntryName[li0-1]!='t' && EntryName[li0-1]!='T') continue;
   if (SkipArtIdx<256) {
     if (ShowArtData(dukef,EntryOffset,EntrySize)) break;
   } else {
     SkipArtIdx-=256; ArtIdxSoFar+=256;
   }
 }
 _asm mov ax,3
 _asm int 16
 fclose(dukef); puts(StartUpMessage);
 return(0);
}

int ArtX[256],ArtY[256],ArtU0[256],ArtU1[256],OldXs=1,OldYs=1;
ShowArtData(FILE*dukef,long artoffset,long artsize)
{long oldfp,skipper,imgoffset;
 int i0,xxx,yyy,i1,vo,retval,lineskip;

 retval=0;
 oldfp=ftell(dukef); //save old file pointer
 fseek(dukef,artoffset+16L,0);
 fread((char*)ArtX,2,256,dukef);
 fread((char*)ArtY,2,256,dukef);
 fread((char*)ArtU0,2,256,dukef);
 fread((char*)ArtU1,2,256,dukef);
 for (imgoffset=0,i0=0;i0<256;i0++,ArtIdxSoFar++) {
   yyy=ArtY[i0]; xxx=ArtX[i0];
   if (SkipArtIdx==0) { //if skip image
     if (xxx==0 || yyy==0) continue;
     if (SkipImage) {
       imgoffset+=(long)xxx*yyy;
       ImageSoFar++; SkipImage--; continue;
     } else if (imgoffset!=0) {
       fseek(dukef,imgoffset,1); imgoffset=0;
     }
   } else { //if skip art index
     imgoffset+=(long)xxx*yyy;
     SkipArtIdx--; continue;
   }
   rectan((320-OldXs)>>1,(200-OldYs)>>1,OldXs,OldYs,ClrLow);
   if (fGraphOnly==0) rectan(0,0,LastStrLen<<3,8,ClrLow);
   OldXs=xxx; if (OldXs>320) OldXs=320;
   OldYs=yyy; if (OldYs>200) OldYs=200;
   vo=320*((200-OldYs)>>1)+((320-OldXs)>>1);
   i1=OldXs; skipper=(long)(xxx-i1)*yyy;
   lineskip=yyy-OldYs;
   imgoffset=ftell(dukef);
   while (i1--) {
     DrawOneLine(dukef,OldYs,lineskip,vo); vo++;
   }
   fseek(dukef,skipper,1);
   if (fGraphOnly==0) {
     LastStrLen=sprintf(InBuf,"%d %d, %d %d, %X %X",ImageSoFar,ArtIdxSoFar,
                              xxx,yyy,ArtU0[i0],ArtU1[i0]);
     if (fShowOffset)
       LastStrLen+=sprintf(InBuf+LastStrLen," %ld",imgoffset);
     PutStr(InBuf,0,0,ClrHigh);
   }
   _asm xor ax,ax
   _asm int 22
   _asm mov i1,ax
   if (i1==0x4400)
     WriteHSIFile(dukef,imgoffset,xxx,yyy,ImageSoFar);
   imgoffset=0; ImageSoFar++;
   if (i1==0x11b) { retval=1; break; }
 }
 fseek(dukef,oldfp,0); //restore old file pointer
 return(retval);
}

struct HsiRaw { char hsiSig[6];
int hsiVer,hsiX,hsiY,hsiPalSize,hsiHDPI,hsiVDPI,hsiGamma;
char hsiUnused[12];
}ghr0={0x6d,0x68,0x77,0x61,0x6e,0x68,
0x400, 0,0, 1, 0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0};
WriteHSIFile(FILE*dukef,long imgoffset,int xxx,int yyy,int imgorder)
{long oldfp;
 FILE*outf;
 int i0;

 ghr0.hsiX=(yyy<<8)|(255&(yyy>>8));
 ghr0.hsiY=(xxx<<8)|(255&(xxx>>8));
 sprintf(InBuf,"hsi%05d.raw",imgorder);
 outf=fopen(InBuf,"wb");
 fwrite((char*)&ghr0,32,1,outf);
 for (i0=0;i0<768;i0++) PalBuf[i0]<<=2;
 fwrite(PalBuf,256,3,outf);
 for (i0=0;i0<768;i0++) PalBuf[i0]>>=2;

 oldfp=ftell(dukef); fseek(dukef,imgoffset,0);
 while (xxx--) {
   fread(InBuf,yyy,1,dukef);
   fwrite(InBuf,yyy,1,outf);
 }
 fclose(outf);
 fseek(dukef,oldfp,0);
}

DrawOneLine(FILE*dukef,int ysize,int yskip,int vov)
{fread(InBuf,ysize,1,dukef); fseek(dukef,(long)yskip,1);
 _asm {
   push si
   push di
   mov ax,0xa000
   mov es,ax
   mov si,offset InBuf
   mov di,vov
   xor bx,bx
   mov cx,ysize
dolbr0: mov bl,[si]
   mov al,PalLookUp[bx]
   mov es:[di],al
   inc si
   add di,320
   loop dolbr0
   pop di
   pop si
 }
}

long SearchData(FILE*dukef,char*datname,long*datsize)
{long l0,EntrySize,EntryOffset;
 char EntryName[12];

 *datsize=0L; EntryOffset=(DN3DIdxCnt+1)<<4;
 fseek(dukef,16L,0);
 for (l0=0;l0<DN3DIdxCnt;l0++) {
   fread(EntryName,12,1,dukef);
   fread((char*)&EntrySize,4,1,dukef);
   if (!strnicmp(EntryName,datname,12)) {
     *datsize=EntrySize;
     return(EntryOffset);
   }
   EntryOffset+=EntrySize;
 }
 return(0L);
}
InitVideo()
{unsigned int lp1,lp4,lumlow,lumhigh;
 unsigned char*palp;

 _asm mov ax,19
 _asm int 16
 GetFontPtr();
 SetPals(PalBuf,0,256);
 lumhigh=0; lumlow=16384; palp=PalBuf;
 for (lp1=0;lp1<256;lp1++) {
   lp4=palp[0]*77+palp[1]*151+palp[2]*28; //intensity value
   if (lp4<lumlow) { lumlow=lp4; ClrLow=lp1; }
   if (lp4>lumhigh) { lumhigh=lp4; ClrHigh=lp1; }
   palp+=3;
 }
}

ScanParameter(int argcnt,char**argptr)
{int lp,lp2,dv1;
 char *comarg,c1,c2;
 for (lp=lp2=1;lp<argcnt;lp++) {
   comarg=argptr[lp];
   if (*comarg=='-' || *comarg=='/')
     switch (comarg[1]) {
       case 's': /*skip first n*/
                 if (comarg[2]=='a') { //skip art index
                   SkipArtIdx=atoi(comarg+3); SkipImage=0;
                 } else { //skip image
                   SkipImage=atoi(comarg+2); SkipArtIdx=0;
                 }
                 break;
       case 'g': /*graph only*/ fGraphOnly=1;
                 break;
       case 'p': /*palette*/
                 PalLU=atoi(comarg+2);
                 break;
       case 'o': /*show offset*/
                 fShowOffset=1;
                 break;
       default : break;
     }
   else argptr[lp2++]=comarg;
 }
 return(lp2);
}
InitDuke3DPal(FILE*dukef)
{int li0;
 long PalOffset,PalSize;

 PalOffset=SearchData(dukef,"palette.dat",&PalSize);
 if (PalOffset==0L) { puts("can't find palette"); return(1); }
 fseek(dukef,PalOffset,0); fread(PalBuf,768,1,dukef);
 for (li0=0;li0<256;li0++) PalLookUp[li0]=li0;
 if (PalLU<0) return(0);
 fread((char*)&li0,2,1,dukef);
 if (PalLU>=li0) return(0);
 fseek(dukef,((long)PalLU)<<8,1);
 fread(PalLookUp,256,1,dukef);
 return(0);
}
