//extract data from Duke Nukem GRP file
//version 0.0 by Bo Yang
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char StartUpMessage[]={"\nDuke Nukem 3D GRP data extractor v0.0 by Bo Yang"};
int ExtractData(char*,FILE*,long,long);
long SearchData(FILE*,char*,long*);
long DN3DIdxCnt;

char InBuf[16384],DN3GrpSig[12];

main(int argc,char**argv)
{FILE*dukef;
 //total number of entries in index; size/offset of an entry
 long EntrySize,EntryOffset;
 char EntryName[12];
 int retval;

 puts(StartUpMessage);
 if (argc<3) {
   puts("usage: dn3ext Duke-Nukem-3D-group-file-name data-item");
   return(1);
 }
 dukef=fopen(argv[1],"rb"); //read binary
 if (dukef==NULL) { puts("can't open input file"); return(2); }
 fread(DN3GrpSig,12,1,dukef);
 fread((char*)&DN3DIdxCnt,4,1,dukef);

 printf("\nsignature: %.12s, entry count: %ld (%lXh)\n",
         DN3GrpSig,DN3DIdxCnt,DN3DIdxCnt);

 EntryOffset=SearchData(dukef,argv[2],&EntrySize);
 retval=10;
 if (EntryOffset==0L) puts("can't find data");
 else {
   ExtractData(argv[2],dukef,EntryOffset,EntrySize);
   retval=0;
 }
 fclose(dukef);
 return(retval);
}

ExtractData(char*dname,FILE*infile,long doffset,long dsize)
{FILE*dfile;

 dfile=fopen(dname,"wb");
 if (dfile==NULL) { puts("can't open output file"); return(1); }
 fseek(infile,doffset,0);
 while (dsize>=16384L) { //read/write in 16K-blocks
   fread(InBuf,1,16384,infile);
   fwrite(InBuf,1,16384,dfile);
   dsize-=16384L;
 }
 if (dsize) {
   fread(InBuf,1,(int)dsize,infile);
   fwrite(InBuf,1,(int)dsize,dfile);
 }
 fclose(dfile); return(0);
}

long SearchData(FILE*dukef,char*datname,long*datsize)
{long l0,EntrySize,EntryOffset;
 char EntryName[12];

 *datsize=0L; EntryOffset=(DN3DIdxCnt+1)<<4;
 fseek(dukef,16L,0);
 for (l0=0;l0<DN3DIdxCnt;l0++) {
   fread(EntryName,12,1,dukef);
   fread((char*)&EntrySize,4,1,dukef);
   if (!strnicmp(EntryName,datname,12)) {
     *datsize=EntrySize;
     return(EntryOffset);
   }
   EntryOffset+=EntrySize;
 }
 return(0L);
}
