@ECHO OFF

ECHO 
ECHO  CITI.BAT v1.0.2 
ECHO 

REM  This line below is used for when Duke3D crashes while in CITI.BAT.
REM  It restores the proper names of the CON files.

   IF EXIST USER_CON.TMP GOTO FIXUSERCON
   IF NOT EXIST INFINITI.MAP GOTO NOMAPFILE
   IF NOT EXIST INFINITI.CON GOTO NOCONFILE

   IF "%1"=="1" GOTO RUNNORMALSKILL
   IF "%1"=="2" GOTO RUNNORMALSKILL
   IF "%1"=="3" GOTO RUNNORMALSKILL
   IF "%1"=="4" GOTO RUNNORMALSKILL
   IF "%1"=="D" GOTO DUKEMATCH
   IF "%1"=="d" GOTO DUKEMATCH
   IF "%1"=="?" GOTO HELPCMD
   IF "%1"=="/?" GOTO HELPCMD

:RUNGAME
   ECHO Normal startup.
   ECHO 
   ECHO This level is built for Duke Nukem 3D version 1.4+ (Atomic Edition).
   ECHO It will NOT run correctly under version 1.3d or earlier!!
   ECHO 
   ECHO If the game crashes while in CITI.BAT, please re-run this batchfile
   ECHO after the computer is reset, and it will fix the CON files.
   ECHO 
   PAUSE
   ECHO 
   RENAME USER.CON USER_CON.TMP
   RENAME INFINITI.CON USER.CON
                         
   DUKE3D %1 %2 %3 %4 %5 %6 %7 %8 %9

   RENAME USER.CON INFINITI.CON
   RENAME USER_CON.TMP USER.CON
   ECHO 
   ECHO Normal shutdown.
   ECHO 
   GOTO END


:FIXUSERCON
   ECHO Maintenance startup.
   ECHO 
   IF NOT EXIST USER.CON GOTO ERRORCON
   RENAME USER.CON INFINITI.CON
   RENAME USER_CON.TMP USER.CON
   ECHO USER.CON files fixed.  CITI.BAT and Duke3D will now run normally.
   ECHO 
   GOTO END

:ERRORCON
   ECHO No USER.CON exists - CITI.BAT attempted to fix the names of your and
   ECHO its CON files but could not find the file that is supposed to be
   ECHO INFINITI.CON renamed to USER.CON.  Please reinstall Citi Infiniti
   ECHO and reinstall your own USER.CON file.
   ECHO 
   GOTO END


:RUNNORMALSKILL
   ECHO Running with normal USER.CON under skill level %1.
   ECHO 
   DUKE3D -map INFINITI.map /s%1 %2 %3 %4 %5 %6 %7 %8 %9
   GOTO END

:NOMAPFILE
   ECHO INFINITI.MAP not found in current directory!  Please reinstall Citi Infiniti.
   ECHO 
   GOTO END

:NOCONFILE
   ECHO INFINITI.CON not found in current directory!  Please reinstall Citi Infiniti.
   ECHO 
   GOTO END

:DUKEMATCH
   ECHO Multiplayer startup.
   ECHO 
   ECHO This level is built for Duke Nukem 3D version 1.4+ (Atomic Edition).
   ECHO It will NOT run correctly under version 1.3d or earlier!!  Press
   ECHO CTRL+BREAK to abort.
   ECHO 
   ECHO If the game crashes while in CITI.BAT, please re-run this batchfile
   ECHO after the computer is reset, and it will fix the CON files.
   ECHO 
   ECHO Now running SETUP to start a Dukematch or Co-Op game.  Make sure you
   ECHO select INFINITI.MAP as your usermap, and then start in any episode.
   ECHO 
   PAUSE
   ECHO 
   RENAME USER.CON USER_TMP.CON
   RENAME INFINITI.CON USER.CON
                         
   SETUP %1 %2 %3 %4 %5 %6 %7 %8 %9

   RENAME USER.CON INFINITI.CON
   RENAME USER_TMP.CON USER.CON
   ECHO 
   ECHO   CITI.BAT: Multiplayer mode shutdown.
   ECHO 
   GOTO END


:HELPCMD
   ECHO This level will only work with Duke Nukem 3D Atomic Edition versions 1.4+!
   ECHO 
   ECHO  Usage:  CITI {1/2/3/4/d} {game parameters}
   ECHO 
   ECHO Parameters in {braces} are optional.  Running with NO parameters
   ECHO starts a normal Citi Infiniti game (recommended).  Game parameters
   ECHO are those parameters which DUKE3D.EXE uses, and must come AFTER the
   ECHO CITI.BAT parameters.
   ECHO 
   ECHO Command line parameters for CITI.BAT:
   ECHO   1  - Run Citi Infiniti in Pothead Mode (easy)
   ECHO   2  - Run Citi Infiniti in Frying Mode (medium)
   ECHO   3  - Run Citi Infiniti in Tweaker Mode (hard)
   ECHO   4  - Run Citi Infiniti in Ultra Kickass Mode (hard+respawning)
   ECHO   d  - Run Citi Infiniti in Multiplayer Mode (Serial/Network/Modem)
   ECHO 
   ECHO If Duke3D should crash while running CITI.BAT without parameters, or
   ECHO using the "d" parameter, then you need to run CITI.BAT again without
   ECHO parameters, and it will automatically fix the CON files.
   ECHO 

:END
