COMMENT @
	i286.asm
	(c) Szigeti Szabolcs	1992 jan 28.

	Ez a file tartalmazza a legalacsonyabb szintu KERNEL
	rutinokat, assembly-ben irva.
	
@
INCLUDE		h\COMMON.INC
K_CODE	SEGMENT	PARA	PUBLIC	'K_CODE'	;KENEL szegmense
ASSUME CS:K_CODE,ds:k_data

extrn 	_t_clock:near,_corint:near,_sysentry:near,_t_clocka:near
extrn	_fdc_intr:near,_lmod:near,_lp1int:near,_lp2int:near
extrn	_hdint:near,_as1int:near,_as2int:near
;****************************************************************
;*	Megszakitasok tiltasa es engedelyezese			*
;****************************************************************

_lock1		PROC	C	NEAR
		PUSHF
		CLI
		POP AX
		RET
_lock1		ENDP
;----------------------------------------------------------------

_unlock		PROC	C	NEAR
	ARG	NEWPSW:WORD
		mov ax,newpsw
		push ax
		popf
		RET
_unlock		ENDP
;----------------------------------------------------------------
_istatus	proc	c	near
		pushf
		pop	ax
		ret
_istatus	endp

PUBLIC _lock1,_unlock,_istatus

;****************************************************************
;*	Rendszerhivas						*
;****************************************************************
_sys_x		PROC	NEAR
		pop	cx
		pop	dx
		push	cx
		FCAL	150h,0  
		sub	sp,10
		pop	cx
		push	cx
		push	cx
		ret
_sys_x		ENDP
PUBLIC _sys_x
;****************************************************************
;*	swtch() belepesi pont					*
;****************************************************************
_swtch		proc	near
	;	mov	bx,offset _swtch_tsk
	;	mov	[bx].cd_rights,sys_pres or sys_atss
		FJM     140h,0	; swtch task selector
		ret
_swtch		endp
PUBLIC _swtch
;****************************************************************
;*	Rendszerhivas belepes					*
;****************************************************************
sysentry	proc	far
		mov	bx,28h	;kernel data
		mov	ds,bx
		call	_sysentry
		cmp	_runrun,0
		je	synrs
		call 	_swtch
synrs:          mov	bx,0fh	;local data
		mov	ds,bx
		retf    10
sysentry	endp
public sysentry
;****************************************************************
;*	Hardware int belepesi pont 				*
;****************************************************************

;---------------int #0 clock-------------------------------------

t_clock		proc	near
		push	0
		call	_lmod;
		pop	ax
		call	_t_clock
		cmp	_lastmode,0
		je	s_i_0
		cmp	_runrun,0
		je	s_i_0
		call	_swtch
		jmp	t_clock
s_i_0:		iret
		jmp	t_clock
t_clock		endp
public t_clock
;+++++++++++++++int #0 clock in clock++++++++++++++++++++++++
t_clocka	proc	near
		call	_t_clocka
		cmp	_runrun,0
		je	s_i_0a
		call	_swtch
		jmp	t_clock
s_i_0a:		iret
		jmp	t_clock
t_clocka	endp
public t_clocka
;---------------int #1 keyboard------------------------------
t_coint		proc	near
		push	1
		call	_lmod;
		pop	ax
		call	_corint
		cmp	_lastmode,0
		je	s_i_1
		cmp	_runrun,0
		je	s_i_1
		call    _swtch
		jmp	t_coint
s_i_1:		iret
		jmp	t_coint
t_coint		endp
public t_coint
;---------------int #3 com2----------------------------------

t_asy2		proc	near
		push	3
		call	_lmod;
		pop	ax
		call	_as2int
		cmp	_lastmode,0
		je	s_i_3
		cmp	_runrun,0
		je	s_i_3
		call    _swtch
		jmp	t_asy2
s_i_3:		iret
		jmp	t_asy2
t_asy2		endp
public t_asy2
;---------------int #4 com1----------------------------------

t_asy1		proc	near
		push	4
		call	_lmod;
		pop	ax
		call	_as1int
		cmp	_lastmode,0
		je	s_i_4
		cmp	_runrun,0
		je	s_i_4
		call    _swtch
		jmp	t_asy1
s_i_4:		iret
		jmp	t_asy1
t_asy1		endp
public t_asy1
;---------------int #5 lpt2----------------------------------

t_lp2		proc	near
		push	5
		call	_lmod;
		pop	ax
		call	_lp2int
		cmp	_lastmode,0
		je	s_i_5
		cmp	_runrun,0
		je	s_i_5
		call    _swtch
		jmp	t_lp2
s_i_5:		iret
		jmp	t_lp2
t_lp2		endp
public t_lp2
;---------------int #6 floppy--------------------------------

t_fdc		proc	near
		push	6
		call	_lmod;
		pop	ax
		call	_fdc_intr
		cmp	_lastmode,0
		je	s_i_6
		cmp	_runrun,0
		je	s_i_6
		call    _swtch
		jmp	t_fdc
s_i_6:		iret
		jmp	t_fdc
t_fdc		endp
public t_fdc    
;---------------int #7 lpt1----------------------------------

t_lp1		proc	near
		push	7
		call	_lmod;
		pop	ax
		call	_lp1int
		cmp	_lastmode,0
		je	s_i_7
		cmp	_runrun,0
		je	s_i_7
		call    _swtch
		jmp	t_lp1
s_i_7:		iret
		jmp	t_lp1
t_lp1		endp
public t_lp1
;---------------int #14 hdc----------------------------------

t_hdc		proc	near
		push	14
		call	_lmod;
		pop	ax
		call	_hdint
		cmp	_lastmode,0
		je	s_i_14
		cmp	_runrun,0
		je	s_i_14
		call    _swtch
		jmp	t_hdc
s_i_14:		iret
		jmp	t_hdc
t_hdc		endp
public t_hdc
;***********************************************************
;*		Alacsony szintu I/O muveletek		   *
;***********************************************************

_outbyte	PROC	C	NEAR
	ARG	PORT:WORD,BYT:BYTE
		MOV	DX,PORT
		MOV	AL,BYT
		OUT	DX,AL
		RET
_outbyte	ENDP
;------------------------------------
_inbyte		PROC	C	NEAR
	ARG	PORT:WORD
		XOR	AH,AH
		MOV	DX,PORT
		IN 	AL,DX
		RET
_inbyte		ENDP
;------------------------------------
_outword		PROC	C	NEAR
	ARG	PORT:WORD,WRD:WORD
		MOV	DX,PORT
		MOV	AX,WRD
		OUT	DX,AX
		RET
_outword		ENDP
;------------------------------------
_inword		PROC	C	NEAR
	ARG	PORT:WORD
		MOV	DX,PORT
		IN	AX,DX
		RET
_inword		ENDP
PUBLIC	_inbyte,_outbyte,_inword,_outword
;***********************************************************
;	user<->kernel adatmozgatas			   *
;***********************************************************
udata	equ	0fh	;user data selector
kdata	equ     28h	;kernel data selector

_fubyte		proc	c	near
	arg	base:word
		push	es
		mov	ax,udata
		mov	es,ax
		lsl	bx,ax
		jnz	fubad
		cmp	bx,base
		ja	fubok
fubad:		mov	ax,-1		; ervenytelen base
		pop	es
		ret

fubok:		mov	bx,base
		xor	ax,ax
		mov	al,es:[bx]
		pop	es
		ret

_fubyte		endp

;-----------------------------------------------------------

_subyte		proc	c	near
	arg	base:word,chr:word
		push	es
		mov	ax,udata
		mov	es,ax
		lsl	bx,ax
		jnz	subad
		cmp	bx,base
		ja	subok
subad:		mov	ax,-1		; ervenytelen base
		pop	es
		ret

subok:		mov	bx,base
		mov	ax,chr
		mov     es:[bx],al
		xor	ax,ax
		pop	es
		ret

_subyte		endp

public	_subyte,_fubyte
;-----------------------------------------------------------

_fuword		proc	c	near
	arg	base:word
		push	es
		mov	ax,udata
		mov	es,ax
		lsl	bx,ax
		jnz	fuwbad
		cmp	bx,base
		ja	fuwok
fuwbad:		mov	ax,-1		; ervenytelen base
		pop	es
		ret

fuwok:		mov	bx,base
		xor	ax,ax
		mov	ax,es:[bx]
		pop	es
		ret

_fuword		endp

;-----------------------------------------------------------

_suword		proc	c	near
	arg	base:word,chr:word
		push	es
		mov	ax,udata
		mov	es,ax
		lsl	bx,ax
		jnz	suwbad
		cmp	bx,base
		ja	suwok
suwbad:		mov	ax,-1		; ervenytelen base
		pop	es
		ret

suwok:		mov	bx,base
		mov	ax,chr
		mov     es:[bx],ax
		xor	ax,ax
		pop	es
		ret

_suword		endp

public	_suword,_fuword

;***********************************************************
;*	winchester adatmozgatas DMA nelkul		   *
;***********************************************************
_wiread		proc	c	near
	arg	sel:WORD,off:WORD,cnt:WORD,full:word
		pushf	
	;	cli
		push	si
		push	di
		push	es
		mov	ax,sel
		mov	es,ax
		mov	cx,cnt
		mov	dx,1f0h		;hdc data
		mov	di,off
		cld
	rep	insw	
		mov	cx,full
		cmp	cnt,cx
		je	wirend
		sub	cx,cnt
restrd:		in	ax,dx
		loop	restrd
wirend:		pop	es
		pop	di
		pop	si
		popf
		ret
_wiread		endp
;------------------------------------------------------------

_wiwrite	proc	c	near
	arg	sel:WORD,off:WORD,cnt:WORD,full:WORD
		pushf
	;	cli
		push	si
		push	di
		push	ds
		mov	ax,sel
		mov	ds,ax
		mov	cx,cnt
		mov	dx,1f0h
		mov	si,off
		cld
	rep	outsw
		mov	cx,full
		cmp	cnt,cx
		je	wiwend
		sub	cx,cnt
		xor	ax,ax
restwr:		out	dx,ax
		loop	restwr
wiwend:		pop     ds
		pop	di
		pop	si
		popf
		ret
_wiwrite	endp

public _wiread,_wiwrite
;***********************************************************
;*	CLIST manipulalas				   *
;***********************************************************
_getc		proc	c	near		;egy karaktert ki
	arg     c_list:WORD
	uses	si,di

                pushf
		cli 
		xor	ax,ax
		mov	bx,c_list
		cmp	[bx].c_cc,ax
		ja	gc01

		mov	[bx].c_cc,ax
		mov	[bx].c_cf,ax
		mov	[bx].c_cl,ax
                mov	ax,-1

		popf
		ret

gc01:		mov	si,[bx].c_cf	; a kert karakter cime SI-ben
		mov	al,[si]
		inc	si
		mov	[bx].c_cf,si	;cimet noveljuk

		dec	[bx].c_cc
		cmp	[bx].c_cc,0     ;kiurult az egesz clist ?
		ja	gc02

		dec	si              ;igen!
		and	si,not 	7	; a kiurult cblock cime
		mov	[bx].c_cf,0
		mov	[bx].c_cl,0
		mov	di,word ptr _cfreelist
		mov	[si].c_next,di
		mov	word ptr _cfreelist,si
		popf
		ret

gc02:		test	si,7            ;kiurult az aktualis cblock ?
		jz	gc03

		popf                    ;nem, kesz vagyunk.
		ret

gc03:		sub	si,8            ; felszabaditjuk a kiurult blokkot
		mov	di,[si].c_next
		inc	di
		inc	di
		mov	[bx].c_cf,di
		mov	di,word ptr _cfreelist
		mov	[si].c_next,di
		mov	word ptr _cfreelist,si
		popf
		ret

_getc		endp

;-----------------------------------
_putc		proc	c	near	;egy karakter be
	arg	chr:WORD,c_list:WORD
	uses	si,di

		pushf
		cli
		mov	ax,chr   	;al<-beteendo karakter
		xor	ah,ah
		mov	bx,c_list	;bx<-kert clist

		mov	si,[bx].c_cl	;si<-ide kell tenni
		or	si,si
		jz	pc01		;clist teljesen ures

		mov	[si],al
		inc	si
		test	si,7
		jz      pc04
		mov	[bx].c_cl,si
		inc	[bx].c_cc
		xor	ax,ax
		popf
		ret

pc04:		mov     di,word ptr _cfreelist	;uj blookot allokalunk
		or	di,di
		jnz	pc03
		mov	ax,-1		;hiba: nincs szabad blokk
		popf
		ret

pc03:           sub	si,8		;az teli blokk cime
		mov	[si].c_next,di	;a kovetkezo a most lefoglalt
		mov	dx,[di].c_next
		mov	word ptr _cfreelist,dx
		mov	[di].c_next,0
		inc	di
		inc	di		;di az uj ures helyre mutat
		mov	[bx].c_cl,di
		inc	[bx].c_cc
		xor	ax,ax
		popf
		ret

pc01:           mov	di,word ptr _cfreelist
		or	di,di
		jnz	pc02
		mov	ax,-1
		popf
		ret

pc02:           mov	dx,[di].c_next  ;kivesszuk a freelist elso elemet
		mov	word ptr _cfreelist,dx
		inc	di
		inc	di		;elso kar. pozicio
		mov	[bx].c_cf,di
		mov	[di],al
		inc	di
		mov	[bx].c_cl,di
		inc	[bx].c_cc
		xor	ax,ax
		popf
		ret

_putc	endp

public	_getc,_putc
;***********************************************************
;*	Nem lokalis goto mentes & vegrehajtas		   *
;***********************************************************
_savu		proc		near

		pop	ax	;vissz.cim
		pop	bx	;argumentum
		mov	word ptr [bx],bp ; bp a regi sp-t tartalmazza
		push	bx
		push	ax
		ret
_savu   	endp
;-----------------------------------------------------------
_aretu		proc		near
		
		pop	ax
		pop	bx
		mov	sp,word ptr [bx]
                pop	bp
		ret
_aretu		endp
public _savu,_aretu	
;***********************************************************
;*  A szamitogep ujrainditas				   *
;***********************************************************

_reboot		PROC	C	NEAR
		CLI
		MOV	AL,0F0H			;Reboot kod
		OUT	64H,AL			;Bill. vezerlo port
		HLT				;Varunk a RESETRE
_reboot		ENDP
PUBLIC _reboot
;***********************************************************
;*	Long left shift					   *
;***********************************************************

N_LXLSH@       proc	near
LXLSH@:        cmp     cl,10H
		jae     L2
                mov     bx,ax
                shl     ax,cl
                shl     dx,cl
                neg     cl
                add     cl,10H
                shr     bx,cl
                or      dx,bx
		ret
L2:             sub     cl,10H
                xchg    ax,dx
                xor     ax,ax
                shl     dx,cl
		ret
N_LXLSH@	endp
public N_LXLSH@
;***********************************************************
;*	Long right shift				   *
;***********************************************************
n_lxrsh@	proc 	near 
lxrsh@:         cmp     cl,10H
		jae     L1
		mov     bx,dx
		shr     ax,cl
		sar     dx,cl
		neg     cl
		add     cl,10H
		shl     bx,cl
		or      ax,bx
		ret    
L1:             sub     cl,10H
                xchg    ax,dx
                cwd     
                sar     ax,cl
		ret
n_lxrsh@	endp
public N_LXRSH@  
;***********************************************************
;*	unsigned long right shift			   *
;***********************************************************
n_lxursh@	proc	c	near      
lxursh@:        cmp     cl,10H
		jae     L3
		mov     bx,dx
		shr     ax,cl
		shr     dx,cl
		neg     cl
		add     cl,10H
		shl     bx,cl
		or      ax,bx
		ret    
L3:             sub     cl,10H
                xchg    ax,dx
                xor     dx,dx
                shr     ax,cl
		ret    
n_lxursh@	endp
public N_LXURSH@
;***********************************************************
;*	Long osztasok es maradek kepzesek		   *
;***********************************************************
n_ldiv@:
ldiv@:          xor     cx,cx
		jmp     short ldL1
n_ludiv@:
		mov     cx,0001H
		jmp     short ldL1
n_lmod@:        mov     cx,0002H
		jmp     short ldL1
n_lumod@:       mov     cx,0003H
ldL1:           push    bp
		push    si
		push    di
		mov     bp,sp
		mov     di,cx
		mov     ax,word ptr +08H[bp]
		mov     dx,word ptr +0aH[bp]
		mov     bx,word ptr +0cH[bp]
		mov     cx,word ptr +0eH[bp]
                or      cx,cx
		jne     ldL2
                or      dx,dx
		je      ldL10
                or      bx,bx
		je      ldL10
ldL2:             test    di,0001H
		jne     ldL4
                or      dx,dx
		jns     ldL3
                neg     dx
                neg     ax
                sbb     dx,0000H
                or      di,000cH
ldL3:             or      cx,cx
		jns     ldL4
                neg     cx
                neg     bx
                sbb     cx,0000H
                xor     di,0004H
ldL4:             mov     bp,cx
                mov     cx,0020H
                push    di
                xor     di,di
                xor     si,si
ldL5:             shl     ax,1
                rcl     dx,1
                rcl     si,1
                rcl     di,1
                cmp     di,bp
		jb      ldL7
		ja      ldL6
                cmp     si,bx
		jb      ldL7
ldL6:             sub     si,bx
                sbb     di,bp
                inc     ax
ldL7:             loop    ldL5
                pop     bx
                test    bx,0002H
		je      ldL8
                mov     ax,si
                mov     dx,di
                shr     bx,1
ldL8:             test    bx,0004H
		je      ldL9
                neg     dx
                neg     ax
                sbb     dx,0000H
ldL9:             pop     di
                pop     si
                pop     bp
		ret    0008H
ldL10:            div     bx
                test    di,0002H
		je      ldL11
                xchg    ax,dx
ldL11:            xor     dx,dx
		jmp     short ldL9

public N_LDIV@,N_LUDIV@,N_LUMOD@;

;***********************************************************
;*	Long szorzas					   *
;***********************************************************
n_lxmul@        proc	near
		push    si
                xchg    ax,si
                xchg    ax,dx
                test    ax,ax
		je      lmL1
		mul     bx
lmL1:           jcxz    lmL2
		xchg    ax,cx
		mul     si
                add     ax,cx
lmL2:           xchg    ax,si
                mul     bx
                add     dx,si
                pop     si
                ret     
n_lxmul@	endp

PUBLIC  N_LXMUL@

;***********************************************************


K_CODE		ENDS
;___________________________________________________________

K_DATA		SEGMENT	PARA	PUBLIC	'K_DATA'

EXTRN		_runrun:word,_swtch_tsk:near,_u:word
extrn		_cfreelist:word,_lastmode:byte,_auxmode:byte
extrn		hint0_tss:near,hint1_tss:near,hint6_tss:near
K_DATA		ENDS
;___________________________________________________________

		END
