/*      cov.c
 *	Video driver part of co.c for color VGA
 *
 *	(c) Szigeti Szabolcs apr 1992
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\machine.h"
#include "h\tty.h"
#include "h\systm.h"

#define BELLFREQ	1000	/* konzol bell frekvencia	*/

#define TABSIZ	8		/* tab meret				*/
#define MPAR	3
#define abs(x)	((x)<0?(-(x)):(x))
extern struct tty coat;
int video;
#define SCRL	100	/* hardverscrollozhato max sor	*/

static byte vd_attr=7;		/* sor hossz,akt. attributum	*/
static word vd_madd=0,vd_cadd=0;/* video mem & kurzor cim		*/
static word escp[MPAR],escpm,escf;
static word vd_last,esc;
static coltab[]={0,4,2,6,1,5,3,7};
#define BLINK	128
#define HIINT	8
#define COLM	7+(7<<4)
initvid()
	{
//	if (video==1)
//		(gdt_beg+6)->base_l =0;
	outbyte	(VIDCA,VIDCSTART);
	outbyte (VIDCD,0);
	outbyte (VIDCA,VIDCEND);
	outbyte (VIDCD,14);
	outbyte (VIDCA,VIDADDRL);
	outbyte (VIDCD,0);
	outbyte (VIDCA,VIDADDRH);
	outbyte (VIDCD,0);
	clear_screen(vd_attr);
	cosilence();
	}
clear_screen (attr)
byte attr;
	{
	vd_madd=0;
	coat.t_colp=coat.t_rowp=0;
	posit();

	asm {   push 	es
		push 	di
		mov	ax,030h
		mov	es,ax
		mov	al,' '
		mov	ah,attr
		mov	cx,2000
		mov	di,0
	rep	stosw
		pop 	di
		pop 	es
		};
	}
move_vide(vb1,vb2,count)
int vb1,vb2,count;
	{
	if ((abs(vb1-vb2)>=count)||(vb1>vb2))
	{
	asm {
		push es
		push ds
		push di
		push si
		cld
		mov si,vb1
		mov di,vb2
		mov cx,count
		mov ax,030h
		mov ds,ax
		mov es,ax
	rep	movsw
		pop si
		pop di
		pop ds
		pop es
	    };
	}
	else
		{
		vb1+=count;
		vb2+=count;
		asm	{
			push es
			push ds
			push di
			push si
			std
			mov si,vb1
			mov di,vb2
			mov cx,count
			mov ax,030h
			mov ds,ax
			mov es,ax
		rep	movsw
			pop si
			pop di
			pop ds
			pop es			
			};
		}	
	}

closevid()
	{
	outbyte (VIDCA,VIDADDRL);
	outbyte (VIDCD,0);
	outbyte (VIDCA,VIDADDRH);
	outbyte (VIDCD,0);
	cosilence();
	}

/*	kepernyo gorgetese					*/
scrollup()
	{
	register struct tty *tp=&coat;
	vd_madd+=COLN;
	if (vd_madd>=SCRL*80) 
		{
		move_vide(SCRL*160,0,COLN*RAWN);
		vd_madd=0;
		}
	vd_cadd=(vd_madd+tp->t_colp+tp->t_rowp*COLN);
	vd_last=((COLN*RAWN+vd_madd)<<1)&0x7fff;
	outbyte (VIDCA,VIDADDRL);
	outbyte (VIDCD,vd_madd&0xff);
	outbyte (VIDCA,VIDADDRH);
	outbyte (VIDCD,vd_madd>>8);
	outbyte (VIDCA,VIDCADDL);
	outbyte (VIDCD,vd_cadd&0xff);
	outbyte (VIDCA,VIDCADDH);
	outbyte (VIDCD,vd_cadd>>8);

	asm {
		push es; 	/* a legutolso sort toroljuk	*/
		push di;
		mov ax,48;	/*video*/
		mov es,ax;
		mov cx,COLN;
		mov di,vd_last;
		mov ah,vd_attr;
		mov al,' ';
		cld ;
		rep stosw;
		pop di;
		pop es;
	    }	
	}

/*	hangszoro kikapcsolasa					*/
cosilence()
	{
	register struct tty *tp=&coat;

	outbyte (IO_PPI,0);
	tp->t_state&=~STOP;
	wakeup((int)&tp->t_outq);

	}

/*	chr kiirasa a kovetkezo pozicioba, vezerlokarakterek ertelmezese
		CR,LF,TAB, scrollozas				*/

coout(chr)
word chr;
	{
	register word t;
	register struct tty *tp=&coat;
	word essav;

	if (esc)
		{
		doesc(chr);
		return;
		}

	switch (chr)
		{

		case '\033': {		/* ESC */
			esc=1;
			for (t=0;t<MPAR;escp[t++]=0);
			break;
			}
		case '\014': {		/* FF */
			vd_madd=0;
			tp->t_colp=0;
			tp->t_rowp=0;
			clear_screen(vd_attr);
			break;
			}
		case '\r': {    	/* CR */

			tp->t_colp=0;
			break;
			   }

		case '\n': {		/* LF */

			if (++tp->t_rowp>RAWN)
				{
				tp->t_rowp=RAWN;
				scrollup();
				}
			break;
			   }
		case '\t': {		/* TAB */

			do
				;
			while ((++tp->t_colp)&07);
			if (tp->t_colp>COLN)
				{
				tp->t_colp=0;
				if (++tp->t_rowp>RAWN)
					{
					tp->t_rowp=RAWN;
					scrollup();
					}
				}
			break;
			   }    
		case '\b': {		/* BS */

			if (--tp->t_colp<0)
				{
				tp->t_colp=0;
				if (--tp->t_rowp<0)
					{
					tp->t_rowp=0;
					}
				}
			break;
			   }

		case '\007':{		/* BELL */
			register int save;
			tp->t_state|=STOP;
			t= TIMERFREQ/BELLFREQ;

			save=lock1();

			outbyte (TIMERC,TIMER2MOD);
			outbyte (TIMER2,t&0xff);
			outbyte (TIMER2,t>>8);

			outbyte(IO_PPI,SPK_ON);

			unlock(save);
			timeout((word)cosilence,0,HZ/3);
			break;
			    }


		default  : {

			if (chr<32)
				{
				chr+=64;
				coout('^');
				}
			essav=_ES;
			_ES=0x30;	/* video mem selector */
			t=((vd_madd+tp->t_colp+tp->t_rowp*COLN)<<1)&0x7fff;
			*(byte _es *)(t)=chr;
			*(byte _es *)(t+1)=vd_attr;
			_ES=essav;

			if (++tp->t_colp>=COLN)
				{
				tp->t_colp=0;
				if (++tp->t_rowp>RAWN)
					{
					tp->t_rowp=RAWN;
					scrollup();
					}
				}
			 break;
			 }
		}
	posit();
	}

posit()
	{
	register int t;
	t=(vd_madd+coat.t_colp+coat.t_rowp*COLN);
	outbyte (VIDCA,VIDCADDL);
	outbyte (VIDCD,t&0xff);
	outbyte (VIDCA,VIDCADDH);
	outbyte (VIDCD,t>>8);
	}
doesc(c)
	{
	if (esc==1)
		{
		switch (c)
			{
			case '[':
				escf='[';
				escpm=0;
				esc=2;
				break;
			case 'M':
				escex(c);
				break;
			default:
				esc=0;
				escpm=0;
				escf=0;
				break;
			}
		return;
		}
	else
	if (esc==2)
		{
		if (c>='0' && c<='9')
			{
			if (escpm<MPAR)
				{
				escp[escpm]*=10;
				escp[escpm]+=c-'0';
				}
			return;
			}
		if (c==';')
			{
			if (escpm<MPAR)
				escp[++escpm]=0;
			return;
			}
		escex(c);
		esc=0;
		escf=0;
		escp[0]=0;
		}		
	}

escex(c)
	{
	register int v;
	register struct tty *tp=&coat;
	static sax=1,say=1;
	byte fg,bg,t,i;
	if (escf=='[')	/*	parancs		*/
		{
		v=escp[0];
		switch(c)
		{
		case 'J':
			clear_screen(vd_attr);
			break;
		case 'A':
			tp->t_rowp-=(v==0)?1:v;
			if (tp->t_rowp<0)
				tp->t_rowp=0;
			break;
		case 'B':
			tp->t_rowp+=(v==0)?1:v;
			if (tp->t_rowp>RAWN)
				tp->t_rowp=RAWN;
			break;
		case 'C':
			tp->t_colp+=(v==0)?1:v;
			if (tp->t_colp>COLN)
				tp->t_colp=COLN;
			break;
		case 'D':
			tp->t_colp-=(v==0)?1:v;
			if (tp->t_colp<0)
			tp->t_colp=0;
			break;
		case 'H':
			if (v>COLN) 
				v=COLN;
			if (escp[1]>RAWN) 
				escp[1]=RAWN;
			tp->t_colp=((v==0)?1:v)-1;
			tp->t_rowp=((escp[1]==0)?1:v)-1;
			break;
		case 's':
			sax=tp->t_colp;
			say=tp->t_rowp;
			break;
		case 'u':
			tp->t_colp=sax;
			tp->t_rowp=say;
			break;
		case 'm':
			bg=vd_attr&(7<<4);
			fg=vd_attr&7;

			for (i=0;i<=escpm;i++)
				{
				v=escp[i];

				if (v<=37&&v>=30)	
					fg=coltab[v-30];
				else

				if (v>=40&&v<=47)
					bg=coltab[v-40]<<4;
				else

				switch(v)
					{
					case 0: vd_attr=0;
						fg=7;
						bg=0;
						break;
					case 1: vd_attr|=HIINT;
						break;
					case 4: vd_attr|=BLINK|HIINT;
						break;
					case 5: vd_attr|=BLINK;
						break;
					case 7: t=bg;
						bg=fg;
						fg=t;
						break;
					case 8: bg=fg;
						break;
					}
				vd_attr&=~COLM;
				vd_attr|=fg;
				vd_attr|=bg;
				}
			break;

			}

		}
	posit();
	}
