/*	asy.c
 *	rs232 asyncronous communication interface tty driver
 *
 *	(c) Szigeti Szabolcs 1992
 *
 *		minor device : 0 -> COM1 ( char dev )
 *			       1 -> COM2 ( char dev )
 *			       2 -> COM3 ( char dev )
 *			       3 -> COM4 ( char dev )
 *
 */

/*
	BBBBB     AAA    DDDD
	B    B   A   A   D   D
	B    B  A     A  D    D
	BBBBB   AAAAAAA  D    D  UNABLE TO SEND CHARS
	B    B  A     A  D    D
	B    B  A     A  D   D
	BBBBB   A     A  DDDD
*/

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\machine.h"
#include "h\tty.h"
#include "h\systm.h"

#define MAJOR 2
#define NUNIT 4

#define DEV1	0
#define DEV2	1
#define DEV3	2
#define DEV4	3

#define THR  0  /* TransmitterHolding	*/
#define RBR  0	/* ReceiverBuffer	*/
#define DLRL 0	/* DivisorLatch Low	*/
#define DLRH 1	/* DivisorLatch High	*/
#define IER  1	/* InterruptEnable	*/
#define IIR  2	/* InterruptIdent	*/
#define LCR  3	/* LineControlRegister	*/
#define MCR  4	/* ModemControlRegister */
#define LSR  5	/* LineStatus		*/
#define MSR  6	/* ModemStatus		*/

#define DLAB 128	/* Div Latch Addr	*/
#define SBRK 64
#define STPR 32 	
#define EPRT 16         /* Even parity		*/
#define PREN 8		/* Parity enable	*/
#define NSTB 4		/* Stop bits		*/
#define WLMS 3		/* Word length mask	*/
#define WL5  0		/* Word length 5 bits	*/
#define WL6  1		/*	       6	*/
#define WL7  2		/*	       7	*/
#define WL8  3		/*             8        */

#define EITM 8		/* Modem IT enable	*/
#define EITR 4		/* Receive IT enable	*/
#define EITT 2		/* Transmitter IT enable*/
#define EITS 1		/* Receiver Status IT en*/

#define TSRE	64	/* TransShiftEmpty	*/
#define THRE	32	/* TransHoldingEmpty	*/
#define BI	16	/* BreakInt		*/
#define FE	8	/* FramingError		*/
#define PE	4	/* ParityError		*/
#define OE	2	/* Overrun		*/
#define DR	1	/* DataReady		*/

#define LOOP	16	/* Loop test mode	*/
#define OUT2	8
#define OUT1	4
#define RTS	2
#define DTR	1

#define RERR	(FE|PE|OE)	/* Receiver error condition	*/

#define ITNON	1
#define ITRST	6
#define ITRCH	4
#define ITTCH	2
#define ITMST	0
#define ITMSK	6

asstart();

struct tty astp[NUNIT];

char   exists[NUNIT]={1,1,1,1};

static int baudtab[] = 
	{
	-1,
/*	    50     75    110    134    150    200    300    600		*/

	0x0900,0x0600,0x0417,0x0359,0x0300,0x0240,0x0180,0x00c0,

/*	  1200   1800   2400   4800   9600  19200,  extb		*/

	0x0060,0x0040,0x0030,0x0018,0x000c,0x0006,-1
	};

static int base[] = {
			0x3f8,	/* com 1 */
			0x2f8,	/* com 2 */
			0x3e8,	/* com 3 */
			0x2e8	/* com 4 */
		    };
asopen(dev)
register int dev;
	{
	static int inited=0;
	register struct tty *tp;
	if (!inited)
		{
		asinit();
		inited++;
		}
	dev=minor(dev);
	if (!exists[dev]||dev>=NUNIT)
		{
		u->u_error=ENXIO;
		return;
		}
	tp=&astp[dev];

	if (cup->p_ttyp==NULL)
		{
		cup->p_ttyp=tp;
		}
	outbyte (base[dev]+MCR,RTS|DTR|OUT2|OUT1);
	outbyte(base[dev]+IER,EITM|EITR|EITT|EITS);

	if((tp->t_state&ISOPEN)==0)
		{
		tp->t_state|=ISOPEN|CARR_ON|SSTART;
		tp->t_flags|=ECHO|CRMOD;
		tp->t_addr=asstart;
		tp->t_kill='@';
		tp->t_erase='#';
		}
	}
asclose(dev)
register int dev;
	{
	register struct tty *tp;

	tp=&astp[minor(dev)];
	flushtty(tp);
	tp->t_state=0;
	outbyte (base[minor(dev)]+MCR,DTR);
	outbyte(base[dev]+IER,0);

	}



asread(dev)
	{
	ttread(&astp[minor(dev)]);
	}

aswrite(dev)
	{
	ttwrite(&astp[minor(dev)]);
	}

assgtty(dev,v)
register int dev;
	{
	dev=minor(dev);
	if (!exists[dev])
		{
		u->u_error=ENXIO;
		return(-1);
		}
	ttysgtty (&astp[dev],v);
	assettty (dev);
	}

assettty(dev)
	{
	byte lcr;
	register word baud;
	register word m2;

	m2=astp[dev].t_flags;

	if ((baud=baudtab[astp[dev].t_speeds&0xff])<0)
		{
		u->u_error=EINVAL;
		return;
		}
	lcr=WL7;
	if((m2&ANYP)==ODDP)
		lcr |= PREN;
	else
	if((m2&ANYP)==EVENP)
		lcr |= EPRT|PREN;
		
	outbyte (base[dev]+LCR ,DLAB);
	outbyte (base[dev]+DLRL,baud&0xff);
	outbyte (base[dev]+DLRH,(baud>>8)&0xff);
	outbyte (base[dev]+LCR ,lcr);
	outbyte (base[dev]+IER,EITM|EITR|EITT|EITS);

	}
as1int()
	{
	register int iid;
	enable();
printf ("AS1");
	if (exists[DEV1])
		{
		iid=inbyte(base[DEV1]+IIR);
		if (!(iid&ITNON))
			asint (DEV1,iid);
		}
	if (exists[DEV3])
		{
		iid=inbyte(base[DEV3]+IIR);
		if (!(iid&ITNON))
			asint (DEV3,iid);
		}
	intack1();

	}
as2int()
	{
	register int iid;
	enable();
printf("AS2");
	if (exists[DEV2])
		{
		iid=inbyte(base[DEV2]+IIR);
		if (!(iid&ITNON))
			asint (DEV2,iid);
		}
	if (exists[DEV4])
		{
		iid=inbyte(base[DEV4]+IIR);
		if (!(iid&ITNON))
			asint (DEV4,iid);
		}	
	intack1();
	}

asint(dev,ii)
register int dev,ii;
	{
	switch (ii&ITMSK)
		{
		case ITRST:
				asrstint(dev)
				; break;
		case ITRCH:
		
				asrec (dev);
				break;
                case ITTCH:
				asstart (&astp[dev]);
				if (astp[dev].t_outq.c_cc==0 ||
				    astp[dev].t_outq.c_cc==TTLOWAT)
					wakeup((int)&astp[dev].t_outq);
				break;

		case ITMST:	printf ("MST");
				break;
		}
	}
asrstint(dev)
register int dev;
	{
	register int lsr;
	if ((lsr=inbyte(base[dev]+LSR))&RERR)	/* receive error occured*/
		{
		prdev ("Lost char",MAJOR<<8|dev);
		return;				/* discard character	*/
		}
	if (lsr&BI)
		{
		ttyinput (CINTR,&astp[dev]);
		return ;
		}
	}
asrec(dev)
register int dev;
	{

	while (inbyte(base[dev]+LSR)&DR)
		{
		ttyinput (32|inbyte (base[dev]+RBR),&astp[dev]);
		}
	}

asstart(tp)
register struct tty *tp;
	{
	register int c;

	if (tp->t_state&TIMEOUT)
		return;
	if((inbyte(base[minor(tp->t_dev)]+LSR)&(TSRE|THRE))==0)
		return;

	if ((c=getc(&tp->t_outq))>=0)
		{
printf ("Out:%c ",c);
		outbyte (base[minor(tp->t_dev)]+THR,c);
		}
	}
/*
 *  Test for the existence of asynchronous lines
 */

asinit()
	{
	register int i;
	for (i=0;i<NUNIT;i++)
		{
		outbyte (base[i]+LCR,EPRT|PREN|WL5);
		if (inbyte (base[i]+LCR)!=(EPRT|PREN|WL5))
			exists[i]=0;
		else
		{
		outbyte (base[i]+LCR,STPR|WL7);
		if (inbyte (base[i]+LCR)!=(STPR|WL7))
			exists[i]=0;
		}
		astp[i].t_dev=(MAJOR<<8)|(i&0xff);
		astp[i].t_speeds=(7<<8)|7;
		astp[i].t_state=SSTART|(exists[i]?CARR_ON:0);
		astp[i].t_flags=ECHO|CRMOD;
		astp[i].t_addr=asstart;
		astp[i].t_kill='@';
		astp[i].t_erase='#';
		if (exists[i])
			{
			outbyte(base[i]+MCR,DTR);
			assettty(i);
			}
		}

	}