#include <windows.h>
#include <stdio.h>
#include <tchar.h>

int main(void)
{
    HANDLE hPipe;
    TCHAR  szPipe[64], RdBuffer[1024], WrBuffer[1024];
    int    i;
    DWORD  Size;
    DWORD  dwProcessId = GetCurrentProcessId();
    LPTSTR pszCmdLine;
    DWORD  dwMode = PIPE_READMODE_MESSAGE | PIPE_WAIT;
    
    //
    // Machine name (if any) is passed as command line param.
    //
    pszCmdLine = GetCommandLine();
    while (*pszCmdLine && *pszCmdLine != TEXT(' ')) {
        pszCmdLine++;
    } 

    if (*pszCmdLine) {
        wsprintf(szPipe,TEXT("\\\\%s\\pipe\\wdjpipe1"),++pszCmdLine);
    } else {
        lstrcpy(szPipe,TEXT("\\\\.\\pipe\\wdjpipe1"));
    }

    //
    // Connect to an available instance of the named pipe.
    //

    _tprintf(TEXT("CLNT: Attempting connection to pipe %s\n"),
            szPipe);

    while (TRUE) {

        hPipe = CreateFile(szPipe, GENERIC_READ | GENERIC_WRITE, 0, 
                  NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

        if (hPipe != INVALID_HANDLE_VALUE) break;

        if (GetLastError() != ERROR_PIPE_BUSY) {
            _tprintf(TEXT("CLNT: Open failed %d\n"), GetLastError());
            return EXIT_FAILURE;
        }

        // if busy, wait 30 seconds
        if (!WaitNamedPipe(szPipe, 30000)) {
            _tprintf(TEXT("CLNT: Exceeded wait for pipe\n"));
            return EXIT_FAILURE;
        }
    }

    SetNamedPipeHandleState(hPipe, &dwMode, NULL, NULL);

    for (i=0; i < 5000; i++) {

        wsprintf(WrBuffer, TEXT("Client-%d-%d"), dwProcessId, i);
        Size = (lstrlen(WrBuffer)+1) * sizeof(TCHAR);

        if (!TransactNamedPipe(hPipe, &WrBuffer, Size, RdBuffer, 1024, 
                               &Size, NULL)) {
           CloseHandle(hPipe);
           return EXIT_FAILURE;
        }
        _tprintf(TEXT("CLNT wrote <%s>, read <%s>\n"),
                WrBuffer, RdBuffer);
    }

    CloseHandle(hPipe);
    return EXIT_SUCCESS;
}
