#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <tlhelp32.h>
#include <stdio.h>
#include <conio.h>

/* GetProcAddress semi-automation */
#define GETPROC(proc,functype,hmodule) \
            p##proc = (functype)GetProcAddress ((hmodule), #proc)
            
/* toolhelp32 functions */
typedef HANDLE (WINAPI *TH32SNAPSHOT)(DWORD,DWORD);
typedef BOOL (WINAPI *PROCESSWALK)(HANDLE,LPPROCESSENTRY32);

/* VxDCall alias from VCALL.DLL */
DWORD WINAPI VCall (DWORD);

/* VW32DEMO Device IO Control subfunctions */
typedef enum {
   VW32DEMO_HITCOUNT = 1,
   VW32DEMO_RMDIR
}VW32DEMO_IOCTL;

HANDLE hVxD;   
/* VxD name for Device IOCTL */
static char *devname = "\\\\.\\VW32DEMO.VXD";

void Usage (void)
{
   fputs ("\nusage: 'VW32TEST -1' - Dump Hit Count",stderr);
   fputs ("\n       'VW32TEST -2' - Reject RmDir",stderr);
   fputs ("\n       'VW32TEST -3' - Process View\n",stderr);
}

void CountWin32ServiceHits (void)
{
DWORD in[3] = {0};

   fputs ("\nCollecting Hit Counts",stderr);
   fputs ("\nHit any key when get tired ...\n",stderr);
   /* wait until key is pressed */
   while (!kbhit ());

   puts ("\nService \tHit Count\n");
   do
   {
      DeviceIoControl (hVxD,
                       VW32DEMO_HITCOUNT,
                       in, sizeof(in),
                       NULL, 0,
                       NULL,NULL);
      printf ("%08lX\t%ld\n", in[1], in[2]);
   }
   while(in[0]);
}

void PreventDeleteDirectory (void)
{
   DeviceIoControl (hVxD,VW32DEMO_RMDIR,NULL,0,NULL,0,NULL,NULL);
   /* wait until key is pressed */
   /* No Win32 app is able to delete any directory, */
   /* while this loop is running */
   fputs ("\nTry to remove empty directory from Explorer",stderr);
   fputs ("\nHit any key when get annoyed ...",stderr);
   while (!kbhit ());
   /* remove Int21 service hook */
   DeviceIoControl (hVxD,VW32DEMO_RMDIR,NULL,0,NULL,0,NULL,NULL);
}

void UnobfuscatedProcessView (void)
{
DWORD obfuscator;
HANDLE hProcSnap;
HMODULE k32;
TH32SNAPSHOT pCreateToolhelp32Snapshot;
PROCESSWALK  pProcess32First, pProcess32Next;
PROCESSENTRY32 pe;
BOOL result;

   obfuscator = VCall (0x00000000, GetCurrentProcessId ());
   printf ("\nWin32 Process ID Obfuscator = %08lX\n", obfuscator);
      
   k32 = GetModuleHandle ("KERNEL32");
   GETPROC(CreateToolhelp32Snapshot,TH32SNAPSHOT,k32);
   GETPROC(Process32First,PROCESSWALK,k32);
   GETPROC(Process32Next,PROCESSWALK,k32);

   if (pCreateToolhelp32Snapshot && 
       pProcess32First && 
       pProcess32Next)
      if (hProcSnap = (pCreateToolhelp32Snapshot) 
                           (TH32CS_SNAPPROCESS,0))
      {
         puts ("\nEncoded PID  Decoded PID  Filename\n");
         pe.dwSize = sizeof(pe);
         for (result = pProcess32First(hProcSnap, &pe); 
              result; 
              result = pProcess32Next(hProcSnap, &pe))
            printf ("%-13lX%-13lX%s\n", 
                    pe.th32ProcessID, 
                    pe.th32ProcessID ^ obfuscator, 
                    pe.szExeFile);
            
         CloseHandle (hProcSnap);
      }           
}

int main(int argc, char *argv[])
{
   if (argc < 2 || '-' != argv[1][0])
   {
      Usage ();
      return (1);
   }
   
   hVxD = CreateFile(devname,0,0,NULL,0,
                     FILE_FLAG_DELETE_ON_CLOSE,NULL);
                    
   if (INVALID_HANDLE_VALUE == hVxD)
   {
      // Footprnt is not installed
      fputs ("\nUnable to locate VW32DEMO.VXD",stderr);
      return (1);      
   }                       

   switch (argv[1][1])
   {
      case '1':
         CountWin32ServiceHits ();
         break;

      case '2':
         PreventDeleteDirectory ();
         break;

      case '3':
         UnobfuscatedProcessView ();
         break;

      default:
         Usage ();
         break;
   }

   CloseHandle (hVxD);
   return (0);
}
