-------------------------------Listing 1------------------------------------
//
// JUL97.CPP
//
// This program demonstrates a problem in Borland's
// puttext() routine in the 5.01 release of their
// C++ compiler.  For some reason, the library refuses
// to execute legal calls to puttext() that write to
// the last two columns of the screen in text mode.
//
// Compile this program using the following command:
//
//  BCC Jul97.cpp
//
//  When run, it displays two identical sections
//  of text.  The first prints lines of 73 through 80
//  characters using printf.  The second section does
//  the same using puttext().
//
//  Recompile using this line:
//
//  BCC32 Jul97.cpp
//
//  Now the puttext() section will be missing two lines,
//  the ones of length 79 and 80.
//
#include <stdio.h>
#include <conio.h>


main()
{
   char put_buf[ 80 * 2 ];
   char printf_buf[ 81 ];
   for ( int i = 0 ; i < 80 ; i++ ) {
        put_buf[ i*2 ] = "0123456789"[ i % 10 ];
        put_buf[ i*2 + 1 ] = 7;
        printf_buf[ i ] = "0123456789"[ i % 10 ];
   }
   printf_buf[ 80 ] = '\0';
   clrscr();
   //
   // print lines of length 80 down to 73 chars using printf()
   //
   gotoxy( 1, 1 );
   printf( "printf() output:" );
   for ( int i = 0 ; i < 8 ; i++ ) {
        gotoxy( 1, 3 + i );
        printf( printf_buf );
        printf_buf[ 79 - i ] = '\0';
    }
   //
   // print lines of length 80 down to 73 chars using puttext()
   //
    gotoxy( 1, 12 );
    printf( "puttext() output:" );
    for ( int i = 0 ; i < 8 ; i++ )
       puttext( 1, i + 14, 80 - i, i + 14, put_buf );
    gotoxy( 1, 23 );
    return 0;
}



