/*/

Binary file to ASM conversion utility.

Created : Feb 8/97

/*/

#include <qlib.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>

int hi,ho;
#define bufsiz (1024*16)
byte bufi[bufsiz];
byte bufo[bufsiz];
word bpi,bpo;
word bsi;
byte enter[]={13,10,0};

void flush(void)
{
  //flush output
  write(ho,bufo,bpo);
  bpo=0;
}

void outstr(byte *s)
{
  while (*s)
  {
    if (bpo==bufsiz) flush();
    bufo[bpo++]=*s;
    s++;
  }
}  

void main(byte _argc,byte **_argv)
{
  byte a,c;
  byte tmpstr[10];

  if (_argc!=4)
  {
    printf("Binary 2 ASM Converter v1.00 (32bit) by : Peter Quiring\n");
    printf("BIN2ASM <binary_filename> <asm_filename> <label>\n");
    return;
  }

  hi=open(_argv[1],O_BINARY|O_RDONLY);
  ho=open(_argv[2],O_BINARY|O_CREAT|O_TRUNC|O_RDWR);

  if (hi==-1 || ho==-1)
  {
    printf("File I/O Error!");
    exit(0);
  }

  bpi=bufsiz;
  bsi=bufsiz;

  outstr(".data");
  outstr(enter);
  outstr(_argv[3]);  //output label name
  c=0;

  do
  {
    if (bpi==bsi)
    {
      bpi=0;
      bsi=read(hi,bufi,bufsiz);
      if (!bsi) break;
    }
    
    a=bufi[bpi++];
    itoa(a,tmpstr,16);  //hex
    if (c) outstr(",");
    else outstr(" db ");
    if (a>15) outstr("0");
    else outstr("00");
    outstr(tmpstr);
    outstr("h");
    c++;
    if (c==16)
    {
      c=0;
      outstr(enter);
    }
  } while (1);

  flush();
  close(ho);
  close(hi);
}

