'Date: 11-23-96 (12:14)
'From: Dave Shea
'Subj: Wave.Bas (1 / 3)

' DMAPlay by Mike Huff 1996
DEFINT A-Z
DECLARE FUNCTION DMADone% ()
DECLARE FUNCTION ResetDSP% ()
DECLARE SUB WriteDSP (byte%)
DECLARE FUNCTION ReadDSP% ()
DECLARE SUB WriteDAC (byte%)
DECLARE SUB SpeakerState (OnOff%)
DECLARE SUB DMAState (StopGo%)
DECLARE FUNCTION ReadDAC% ()
DECLARE SUB DMAPlay (Segment&, Offset&, Length&, Freq%)
DECLARE SUB DMARecord (Segment&, Offset&, Length&, Freq%)
DECLARE FUNCTION LSB% (LongByte&)
DECLARE FUNCTION MSB% (LongByte&)
DECLARE FUNCTION Page% (LongByte&)
DECLARE SUB CalcIO (BasePort%)
COMMON SHARED DSPReset%, DSPRead%, DSPWrite%, LenPort%
COMMON SHARED DSPWriteStat%, DSPDataAvail%, Channel%
DECLARE SUB CalcIO (BasePort%)
DECLARE SUB DMAPlay (Segment&, Offset&, Length&, Freq%)
DECLARE SUB SpeakerState (OnOff%)
DIM SHARED Buffer(1 TO 1) AS STRING * 32767            'Strings are_
' unsigned chars
   
    WAVfile$ = "C:\windows\ding.wav"'RTRIM$(COMMAND$)
    Hz = 22025                                  '11025, 22050
    CalcIO &H220                                'Change to whatever yours is set at
    Channel% = 1                                'Change to your DMA channel
    OPEN WAVfile$ FOR BINARY AS #1              'Windows 3.1 Chimes.wav 22kHz
    GET #1, 44, Buffer(1)                       'Skip the header and get samples from the file
    Junk% = ResetDSP%                           'Reset the SBs Digital Signal Processor
    SpeakerState 1                              'Turn on the speaker
    DMAPlay VARSEG(Buffer(1)), VARPTR(Buffer(1)), LOF(1) - 44, Hz  'Play it!
    DO
    LOOP UNTIL DMADone%  ' Loops until file is done playing.
    CLOSE #1
DEFSNG A-Z


SUB CalcIO (BasePort%)
' Calculate port addresses.
IF BasePort% = 0 THEN EXIT SUB
Bport$ = LTRIM$(HEX$(BasePort%))
IF LEN(Bport$) <> 3 THEN EXIT SUB
bp$ = "2" + MID$(Bport$, 2, 1)
DSPReset% = VAL("&H" + bp$ + "6")
DSPRead% = VAL("&H" + bp$ + "A")
DSPWrite% = VAL("&H" + bp$ + "C")
DSPWriteStat% = VAL("&H" + bp$ + "C")
DSPDataAvail% = VAL("&H" + bp$ + "E")

END SUB

FUNCTION DMADone%
Count% = INP(LenPort%)
Count2% = INP(LenPort%)
Count& = CLNG(Count% + 1) * CLNG(Count2% + 1)
IF (Count& - 1) = &HFFFF& THEN Junk% = INP(DSPDataAvail%): DMADone% = -1
END FUNCTION

SUB DMAPlay (Segment&, Offset&, Length&, Freq%)
' Transfers and plays the contents of the buffer.
Length& = Length& - 1
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel%
    CASE 0
       PgPort% = &H87
       AddPort% = &H0
       LenPort% = &H1
       ModeReg% = &H48
    CASE 1
       PgPort% = &H83
       AddPort% = &H2
       LenPort% = &H3
       ModeReg% = &H49
    CASE 2
       PgPort% = &H81
       AddPort% = &H4
       LenPort% = &H5
       ModeReg% = &H4A
    CASE 3
       PgPort% = &H82
       AddPort% = &H6
       LenPort% = &H7
       ModeReg% = &H4B
    CASE ELSE
       PRINT "Sorry this library does not support the 16 bit channels.";
       EXIT SUB
END SELECT

OUT &HA, &H4 + Channel%
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, LSB%(MemLoc&)
OUT AddPort%, MSB%(MemLoc&)
OUT PgPort%, Page%(MemLoc&)
OUT LenPort%, LSB%(Length&)
OUT LenPort%, MSB%(Length&)
OUT &HA, Channel%

TimeConst% = INT(256 - 1000000 \ Freq%)
WriteDSP &H40
WriteDSP TimeConst%
WriteDSP &H14
WriteDSP LSB%(Length&)
WriteDSP MSB%(Length&)

END SUB

SUB DMARecord (Segment&, Offset&, Length&, Freq%)
Length& = Length& - 1
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel%
    CASE 0
       PgPort% = &H87
       AddPort% = &H0
       LenPort% = &H1
       ModeReg% = &H44
    CASE 1
       PgPort% = &H83
       AddPort% = &H2
       LenPort% = &H3
       ModeReg% = &H45
    CASE 2
       PgPort% = &H81
       AddPort% = &H4
       LenPort% = &H5
       ModeReg% = &H46
    CASE 3
       PgPort% = &H82
       AddPort% = &H6
       LenPort% = &H7
       ModeReg% = &H47
    CASE ELSE
       EXIT SUB
END SELECT

OUT &HA, &H4 + Channel%
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, LSB%(MemLoc&)
OUT AddPort%, MSB%(MemLoc&)
OUT PgPort%, Page%(MemLoc&)
OUT LenPort%, LSB%(Length&)
OUT LenPort%, MSB%(Length&)
OUT &HA, Channel%

TimeConst% = INT(256 - 1000000 \ Freq%)
WriteDSP &H40
WriteDSP TimeConst%
WriteDSP &H24
WriteDSP LSB%(Length&)
WriteDSP MSB%(Length&)

END SUB

SUB DMAState (StopGo%)
' Stops or continues DMA play.
IF StopGo% THEN WriteDSP &HD4 ELSE WriteDSP &HD0
END SUB

FUNCTION LSB% (LongByte&)
' Gets the LSB of a long integer.
LSB% = LongByte& AND &HFF&

END FUNCTION

FUNCTION MSB% (LongByte&)
' Gets the MSB from a long integer.
MSB% = (LongByte& AND &HFFFF&) \ &H100

END FUNCTION

FUNCTION Page% (LongByte&)
' Gets the memory page of the buffer.
IF (LongByte& AND 65536) THEN P% = P% + 1
IF (LongByte& AND 131072) THEN P% = P% + 2
IF (LongByte& AND 262144) THEN P% = P% + 4
IF (LongByte& AND 524288) THEN P% = P% + 8
Page% = P%
END FUNCTION

FUNCTION ReadDAC%
' Reads a byte from the DAC.
WriteDSP &H20
ReadDAC% = ReadDSP%

END FUNCTION

FUNCTION ReadDSP%
' Reads a byte from the DSP
DO
LOOP UNTIL INP(DSPDataAvail%) AND &H80
ReadDSP% = INP(DSPDataAvail%)

END FUNCTION

FUNCTION ResetDSP%
' Resets the DSP
OUT DSPReset%, 1
Junk% = INP(DSPReset%)
Junk% = INP(DSPReset%)
Junk% = INP(DSPReset%)
Junk% = INP(DSPReset%)
OUT DSPReset%, 0
IF INP(DSPDataAvail%) AND &H80 = &H80 AND INP(DSPRead%) = &HAA THEN
   ResetDSP% = -1
ELSE
   ResetDSP% = 0
END IF

END FUNCTION

SUB SpeakerState (OnOff%)
' Turns speaker on or off.
IF OnOff% THEN WriteDSP &HD1 ELSE WriteDSP &HD3

END SUB

SUB WriteDAC (byte%)
' Writes a byte to the DAC.
WriteDSP &H10
WriteDSP byte%

END SUB

SUB WriteDSP (byte%)
' Writes a byte to the DSP
DO
LOOP WHILE INP(DSPWriteStat%) AND &H80
OUT DSPWrite%, byte%

END SUB

