' =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
' MASK.BAS  by  Dave Shea
' Released to Public Domain on January 19th, 1997.
'
' Compile: MicroSoft Quick Basic 4.5, PDS 7.1
'
' Desc: Demonstrates the technique of masking a graphics array.
'
' (Use at your own risk)
' =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

CLS : SCREEN 13
DIM Circ%(1557), MCirc%(1557)

TCol = 0                             'Color to be transparent
                                     '(I ALWAYS use 0)
MCol = 255                           'Mask color

FOR a = 15 TO 1 STEP -1
 CIRCLE (160, 100), a * 2, a         'Draw the circle
 PAINT (160, 100), a
NEXT

GET (130, 75)-(190, 125), Circ%      'Store it in array Circ%

FOR a = 130 TO 190
 FOR b = 75 TO 125
                    'The following commands search the circle, and
                    'change any pixel that's NOT the transparent
                    'color to the transparent color, and any pixel
                    'that IS the transparent color to the mask color
                    '(This is the masking process)

  IF POINT(a, b) = TCol THEN PSET (a, b), MCol
  IF POINT(a, b) <> TCol AND POINT(a, b) <> MCol THEN PSET (a, b), TCol
 NEXT
NEXT

GET (130, 75)-(190, 125), MCirc%      'Get the new Masked Circle

CLS

FOR a = 1 TO 200
 LINE (1, a)-(320, a), a              'Draw some lines for a background
NEXT

PUT (130, 75), MCirc%, AND            'Lay down the mask using AND
PUT (130, 75), Circ%, XOR             'Lay down circle using XOR
                                      '(which is the default for PSET)
