'SCROLBOX.BAS Scroll Box Demonstration
'by Kurt Kuzba
'Public Domain - No warranties are expressed or implied

'This program demonstrates the use of a configurable scroll box with
'hi-lite marker and line number display.

DECLARE FUNCTION ScrollBox% (lim%, high%, wide%, LIN%, COL%)
'$DYNAMIC$

TYPE textline: l AS STRING * 80: END TYPE
DIM SHARED txt(800) AS textline

OPEN "c:\autoexec.bat" FOR INPUT AS #1
  t% = 0
  WHILE ((t% < 800) AND (NOT EOF(1)))
    LINE INPUT #1, txt(t%).l: t% = t% + 1
  WEND
CLOSE 1

'ScrollBox (# of items, height of box, width of box, YPos, XPos
'selected% = ScrollBox%(t%, 22, 76, 1, 1)
selected% = ScrollBox%(t%, 10, 40, 5, 5)

COLOR 2, 0: CLS : PRINT "You hit ENTER on array item"; selected%
PRINT "The text on that line was:"
PRINT txt(selected%).l
END

REM $STATIC
FUNCTION ScrollBox% (lim%, high%, wide%, LIN%, COL%)
   COLOR 7, 0: CLS : sel% = 0: top% = 0: ex% = lim%
   COLOR 9, 1: LOCATE 1, 1, 0: s$ = STRING$(wide%, " ")
   FOR t% = 0 TO high% + 1
      LOCATE LIN% + t%, COL%
      PRINT STRING$(wide% + 4, CHR$(177));
   NEXT
   LIN% = LIN% + 1: COL% = COL% + 2
   WHILE lim% = ex%
      COLOR 9, 1: LOCATE LIN% - 1, COL%
      PRINT MID$(STR$(sel% + 1), 2) + STRING$(3, CHR$(177))
      FOR t% = 0 TO (high% - 1)
         LOCATE LIN% + t%, COL%: COLOR 1, 3
         IF t% + top% = sel% THEN COLOR 0, 7
         PRINT LEFT$(txt(top% + t%).l + s$, wide%)
      NEXT: p% = 0: p$ = " HPIQGO" + CHR$(13)
      WHILE p% < 2: p% = INSTR(p$, RIGHT$(INKEY$, 1)): WEND
      SELECT CASE p%
         CASE IS = 2   'CURSOR UP
            IF sel% > 0 THEN sel% = sel% - 1
            IF sel% < top% THEN top% = sel%
         CASE IS = 3   'CURSOR DOWN
            IF sel% < (lim% - 1) THEN sel% = sel% + 1
            IF sel% > (top% + (high% - 2)) THEN top% = sel% - high% + 1
         CASE IS = 4   'PAGE UP
            top% = top% - high%: sel% = sel% - high%
            IF top% < 0 THEN top% = 0
            IF sel% < 0 THEN sel% = 0
         CASE IS = 5   'PAGE DOWN
            top% = top% + high%: sel% = sel% + high%
            IF top% >= lim% - high% THEN top% = lim% - high%
            IF top% < 0 THEN top% = 0
            IF sel% >= lim% THEN sel% = lim% - 1
         CASE IS = 6   'HOME
            top% = 0: sel% = 0
         CASE IS = 7   'END
            sel% = lim% - 1: top% = sel% - high% + 1
            IF top% < 0 THEN top% = 0
         CASE IS = 8   'ENTER
            lim% = sel%
      END SELECT
   WEND
   ScrollBox% = sel%
END FUNCTION

