DEFINT A-Z

'$INCLUDE: 'qb.bi'

DECLARE FUNCTION Exist% (FileName$)

'Test Program
'This file should exist on most systems
File$ = "C:\AUTOEXEC.BAT"
A = Exist(File$)
IF A < 0 THEN PRINT File$; " Exists" ELSE PRINT File$; " Not Found"
'This is a dummy file and should not really exist
File$ = "dummy.fil"
A = Exist(File$)
IF A < 0 THEN PRINT File$; " Exists" ELSE PRINT File$; " Not Found"

'***********************************************************************
'* FUNCTION Exist%
'*
'* PURPOSE
'*    Uses DOS ISR 21H, Function 4EH (Find First Matching Directory
'*    Entry) to determine the existence of FileName$.
'***********************************************************************
FUNCTION Exist% (FileName$) STATIC
	 DIM IRegsX AS RegTypeX, ORegsX AS RegTypeX

	 IRegsX.ax = &H4E00
	 IRegsX.cx = &H3F                          'search for all files
	 FileName$ = FileName$ + CHR$(0)           'must end with null byte

	 IRegsX.ds = VARSEG(FileName$)             'load DS:DX with
	 IRegsX.dx = SADD(FileName$)               '  address of FileName$

	 InterruptX &H21, IRegsX, ORegsX
	 Exist% = ORegsX.ax = 0                    'if ax contains a value,
																						 '  remove the null byte
	 FileName$ = LEFT$(FileName$, LEN(FileName$) - 1)
END FUNCTION

