{****************************************************************************

                  Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}
unit scanner;

  interface

    uses
       strings,dos,cobjects,globals,errors,symtable,systems,files,verbose;

    const
       id_len = 14;

    type
       ident = string[id_len];

    const
{$ifdef L_C}
       anz_keywords = 32;

       keyword : array[1..anz_keywords] of ident = (
          'auto','break','case','char','const','continue','default','do',
          'double','else','enum','extern','float','for','goto','if',
          'int','long','register','return','short','signed','sizeof','static',
          'struct','switch','typedef','union','unsigned','void','volatile',
          'while');
{$else}
       anz_keywords = 84;

       keyword : array[1..anz_keywords] of ident = (
                 'ABSOLUTE','AND',
                 'ARRAY','AS','ASM','ASSEMBLER','BEGIN',
                 'BREAK','CASE','CLASS',
                 'CONST','CONSTRUCTOR','CONTINUE',
                 'DESTRUCTOR','DISPOSE','DIV','DO','DOWNTO','ELSE','END',
                 'EXCEPT',
                 'EXIT','EXPORT','EXPORTS','EXTERNAL','FAIL','FALSE','FAR',
                 'FILE','FINALLY','FOR',
                 'FORWARD','FUNCTION','GOTO','IF','IMPLEMENTATION','IN',
                 'INHERITED','INITIALIZATION',
                 'INLINE','INTERFACE','INTERRUPT','IS',
                 'LABEL','LIBRARY','MOD','NEAR','NEW','NIL','NOT','OBJECT',
                 'OF','ON','OPERATOR','OR','OTHERWISE','PACKED','PRIVATE',
                 'PROCEDURE','PROGRAM','PROPERTY','PROTECTED','PUBLIC',
                 'RAISE','RECORD','REPEAT','SELF',
                 'SET','SHL','SHR','STRING','THEN','TO',
                 'TRUE','TRY','TYPE','UNIT','UNTIL',
                 'USES','VAR','VIRTUAL','WHILE','WITH','XOR');

       keyword_token : array[1..anz_keywords] of ttoken = (
                 _ABSOLUTE,_AND,
                 _ARRAY,_AS,_ASM,_ASSEMBLER,_BEGIN,
                 _BREAK,_CASE,_CLASS,
                 _CONST,_CONSTRUCTOR,_CONTINUE,
                 _DESTRUCTOR,_DISPOSE,_DIV,_DO,_DOWNTO,
                 _ELSE,_END,_EXCEPT,
                 _EXIT,_EXPORT,_EXPORTS,_EXTERNAL,_FAIL,_FALSE,_FAR,
                 _FILE,_FINALLY,_FOR,
                 _FORWARD,_FUNCTION,_GOTO,_IF,_IMPLEMENTATION,_IN,
                 _INHERITED,_INITIALIZATION,
                 _INLINE,_INTERFACE,_INTERRUPT,_IS,
                 _LABEL,_LIBRARY,_MOD,_NEAR,_NEW,_NIL,_NOT,_OBJECT,
                 _OF,_ON,_OPERATOR,_OR,_OTHERWISE,_PACKED,_PRIVATE,
                 _PROCEDURE,_PROGRAM,_PROPERTY,_PROTECTED,_PUBLIC,
                 _RAISE,_RECORD,_REPEAT,_SELF,
                 _SET,_SHL,_SHR,_STRING,_THEN,_TO,
                 _TRUE,_TRY,_TYPE,_UNIT,_UNTIL,
                 _USES,_VAR,_VIRTUAL,_WHILE,_WITH,_XOR);
{$endif}

    function yylex : ttoken;
    procedure initscanner(const d,n,e : string);
    procedure donescanner;

    { the asm parser use this function getting the input }
    function asmgetchar : char;

    { this procedure is called at the end of each line }
    { and the function does the statistics }
    procedure write_line;

    type
       tpreproctoken = (PP_IFDEF,PP_IFNDEF,PP_ELSE,PP_ENDIF,PP_IFOPT);

       ppreprocstack = ^tpreprocstack;

       tpreprocstack = object
          t : tpreproctoken;
          accept : boolean;
          next : ppreprocstack;
          name : string;
          line_nb : longint;
          constructor init(_t : tpreproctoken;a : boolean;n : ppreprocstack);
          destructor done;
       end;

    var
       pattern,orgpattern : string;
       { true, if type declarations are parsed }
       parse_types : boolean;

    { macros }

    const
{$ifdef TP}
       maxmacrolen = 1024;
{$else}
       maxmacrolen = 16*1024;
{$endif}

    type
       tmacrobuffer = array[0..maxmacrolen-1] of char;

    var
       macropos : longint;
       macrobuffer : ^tmacrobuffer;
       preprocstack : ppreprocstack;
       inputbuffer : pchar;
       inputpointer : word;
       s_point : boolean;
       c : char;
       kommentarebene : word;
{this is usefull to get the write filename
for the last instruction of an include file !}
Const        FileHasChanged : Boolean = False;

  implementation

    const
       newline = #10;

    procedure reload;

      var
         readsize : word;
         i : longint;

      begin
         if filehaschanged then
           begin
{$ifdef EXTDEBUG}
              writeln ('Note: Finished reading ',current_module^.current_inputfile^.name^);
              write  (' Coming back to ');
              current_module^.current_inputfile^.next^.write_file_line(output);
              writeln;
{$endif EXTDEBUG}
              current_module^.current_inputfile:=current_module^.current_inputfile^.next;

              { this was missing !}
              c:=inputbuffer[inputpointer];
              inc(inputpointer);
{$ifdef EXTDEBUG}
              write('Next 16 char "');
              for i:=-1 to 14 do
                write(inputbuffer[inputpointer+i]);
              writeln('"');
{$endif EXTDEBUG}
              filehaschanged:=false;
              exit;
           end;
         if current_module^.current_inputfile=nil then
           internalerror(14);
         if current_module^.current_inputfile^.filenotatend then
           begin
              { load the next piece of source }
              blockread(current_module^.current_inputfile^.f,inputbuffer^,
                current_module^.current_inputfile^.bufsize-1,readsize);

              inputbuffer[readsize]:=#0;
              c:=inputbuffer[0];

              { inputpointer points always to the _next_ character to read }
              inputpointer:=1;
              if eof(current_module^.current_inputfile^.f) then
                begin
                   current_module^.current_inputfile^.filenotatend:=false;

                   { if this is the main source file then EOF }
                   if current_module^.current_inputfile^.next=nil then
                     inputbuffer[readsize]:=#26;
                end;
           end
         else
           begin
              current_module^.current_inputfile^.close;
              inputbuffer:=current_module^.current_inputfile^.next^.buf;
              inputpointer:=current_module^.current_inputfile^.next^.bufpos;

              if assigned(current_module^.current_inputfile^.next) then
                begin
                   c:=inputbuffer[inputpointer];
                   filehaschanged:=True;
{$ifdef EXTDEBUG}
                   write('Next 16 char "');
                   for i := 0 to 15 do write(inputbuffer[inputpointer+i]);
                     writeln('"');
{$endif}
                   inputbuffer[inputpointer] := #0;
                   { if c=#10 writeline is called but increment the old
                     inputstack instead of the new one }
                   if c=#10 then
                     begin
                        inc(current_module^.current_inputfile^.next^.line_no);
                        dec(current_module^.current_inputfile^.line_no);
                     end;
                end;
            end;
      end;

    procedure write_line;

      var
         status : tcompilestatus;

      begin
{$ifdef ver0_6}
         status.totalcompiledlines:=abslines;
         status.currentline:=current_module^.current_inputfile^.line_no;
         status.currentsource:=current_module^.current_inputfile^.name^+current_module^.current_inputfile^.ext^;
         status.totallines:=0;
{$else}
         with status do
           begin
              totalcompiledlines:=abslines;
              currentline:=current_module^.current_inputfile^.line_no;
              currentsource:=current_module^.current_inputfile^.name^+current_module^.current_inputfile^.ext^;
              totallines:=0;
           end;
{$endif}
         if compilestatusproc(status) then
{$ifdef FPK}
           do_stop();
{$else}
           do_stop;
{$endif}
         inc(current_module^.current_inputfile^.line_no);
         inc(abslines);
      end;

    procedure kommentar;forward;

    procedure skipspace;

      begin
         while (c=' ') or (c=#9) or (c=#13) or (c=#12) or (c=#10) do
           begin
              if c=#10 then write_line;
              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;if c='{' then kommentar;
           end;
      end;

    function is_keyword(var token : ttoken) : boolean;

      var
         m,n,k : integer;

      begin
         { there are no keywords with a length less than 2 }
         if length(pattern)<=1 then
           begin
              is_keyword:=false;
              exit;
           end;

         m:=1;
         n:=anz_keywords;
         while m<=n do
           begin
              k:=m+(n-m) div 2;
              if pattern=keyword[k] then
                begin
                   token:=keyword_token[k];
                   is_keyword:=true;
                   exit;
                end
              else if pattern>keyword[k] then m:=k+1 else n:=k-1;
          end;
        is_keyword:=false;
     end;

    constructor tpreprocstack.init(_t : tpreproctoken;a : boolean;n : ppreprocstack);

      begin
         t:=_t;
         accept:=a;
         next:=n;
      end;

    destructor tpreprocstack.done;

      begin
      end;

    var
       { save value for pattern }
       hs2 : string;

    procedure handle_switches;

      function read_string : string;

        var
           hs : string;

        begin
           hs:='';
           while ((ord(c)>=ord('A')) and (ord(c)<=ord('Z')))
                   or ((ord(c)>=ord('a')) and (ord(c)<=ord('z')))
                   or (c='_')
                   or ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
             begin
                hs:=hs+upcase(c);
                c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
             end;
           read_string:=hs;
        end;

      function read_number : longint;

        var
           hs : string;
           l : longint;
           w : word;

        begin
           read_number:=0;
           hs:='';
           while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
             begin
                hs:=hs+c;
                c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
             end;
           val(hs,l,w);
           read_number:=l;
        end;

      procedure skip_until_pragma;

        begin
        if c=#26 then fatalerror(endoffile);
        if c=#10 then write_line;
           repeat
             while (c<>'{') and (kommentarebene>0) do
               begin
                  if c='{' then inc(kommentarebene);
                  if c='}' then dec(kommentarebene);
                  c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                  if c=#26 then fatalerror(endoffile);
                  if c=#10 then write_line;
               end;
               c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
               if c='$' then
                 break;
               if c=#26 then fatalerror(endoffile);
               if c=#10 then write_line;
               if c='{' then inc(kommentarebene);
               if c='}' then dec(kommentarebene);
           until false;
           c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
        end;

      var
         hs : string;
         hp : pinputfile;
         mac : pmacrosym;
         startebene : word;
         i : longint;
         ht : ttoken;

      procedure popstack;

        var
           hp : ppreprocstack;

        begin
           hp:=preprocstack^.next;
           dispose(preprocstack,done);
           preprocstack:=hp;
        end;

      procedure write_c(c : char);

        begin
           if errortext then
             write(errorfile,c)
           else
             write(c);
        end;

      var
         _d : dirstr;
         _n : namestr;
         _e : extstr;

      begin
         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
         hs:=read_string;
{$ifdef EXTDEBUG}
         writeln('Handling switch "',hs,'" at line ',current_module^.current_inputfile^.line_no);
{$endif}
         if hs='I' then
           begin
              skipspace;
              hs:=c;
              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
              while (c<>' ') and (c<>'}') and (c<>'*') and (c<>#13) and (c<>#10) do
                begin
                   hs:=hs+c;
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
              { read until end of comment }
              while c<>'}' do
                begin
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                   if c=#10 then write_line;
                end;
              {
              dec(kommentarebene);
              }
              { Initialization }

              if (hs='-') then
                aktswitches:=aktswitches-[cs_iocheck]
              else if (hs='+') then
                aktswitches:=aktswitches+[cs_iocheck]
              else
                begin
                   fsplit(hs,_d,_n,_e);

                   hp:=new(pinputfile,init(current_module^.current_inputfile^.path^+_d,_n,_e));
                   hp^.reset;
                   if ioresult=0 then
                     begin
                        current_module^.current_inputfile^.bufpos:=inputpointer;
                        hp^.next:=current_module^.current_inputfile;
                        current_module^.current_inputfile:=hp;
                        current_module^.sourcefiles.register_file(hp);

                        inputbuffer:=current_module^.current_inputfile^.buf;
                        Comment (V_Used,current_module^.current_inputfile^.next^.get_file_line+
                                 ' Note: Start reading file '+current_module^.current_inputfile^.name^);
                        reload;

                        { we have read the }
                        { comment end      }
                        dec(kommentarebene);
{$ifdef EXTDEBUG}
  		        if (kommentarebene>0) then
                          begin
                             current_module^.current_inputfile^.write_file_line(output);
                             writeln (' Note: Comment level ',kommentarebene,' found');
                          end;
{$endif}
                     end
                   else
                     begin
                        exterror:=strpnew(_d+_n+_e);
                        error(cannot_open_incfile);
                     end;
                end;
           end
         { conditional compiling ? }
         else if (hs='ELSE') or (hs='IFDEF') or (hs='IFNDEF') or
           (hs='ENDIF') or (hs='ELSE') then
           begin
              while true do
                begin
                   if hs='ENDIF' then
                     begin
                        { we can always accept an ELSE }
                        if assigned(preprocstack) then
                          begin
                             Comment (V_Conditional,
                                  current_module^.current_inputfile^.get_file_line+
                                  ' Note: ENDIF '+preprocstack^.name+' found');
                             if preprocstack^.t=PP_ELSE then
                               popstack;
                          end
                        else
                          error(preprocerror);

                        { now pop the condition }
                        if assigned(preprocstack) then
                          begin
                             { we only use $ifdef in the stack }
                             if (preprocstack^.t=PP_IFDEF) then
                               popstack
                             else
                               error(too_much_endifs);
                          end
                       else
                          error(preprocerror);
                     end
                   else if hs='IFDEF' then
                     begin
                        skipspace;
                        hs:=read_string;
                        mac:=pmacrosym(macros^.search(hs));
                        preprocstack:=new(ppreprocstack,init(PP_IFDEF,
                          { the block before must be accepted }
                          { the symbole must be exist and be defined }
                          (
                           (preprocstack=nil) or
                            preprocstack^.accept
                          ) and
                           assigned(mac) and
                           mac^.defined,
                          preprocstack));
                        preprocstack^.name:=hs;
                        preprocstack^.line_nb:=current_module^.current_inputfile^.line_no;
                        Comment (V_Conditional,
                             current_module^.current_inputfile^.get_file_line+
                              ' Note: IFDEF '+preprocstack^.name+' found, ');
                             if preprocstack^.accept then
                               Comment (V_Conditional,'accepted')
                             else
                               Comment (V_Conditional,'rejected');
                     end
                   else if hs='IFNDEF' then
                     begin
                        skipspace;
                        hs:=read_string;
                        mac:=pmacrosym(macros^.search(hs));
                        preprocstack:=new(ppreprocstack,init(PP_IFDEF,
                          { the block before must be accepted }
                          (
                           (preprocstack=nil) or
                           preprocstack^.accept
                          ) and
                           not(assigned(mac) and
                           mac^.defined),
                          preprocstack));
                        preprocstack^.name:=hs;
                        preprocstack^.line_nb:=current_module^.current_inputfile^.line_no;
                        Comment (V_Conditional,
                             current_module^.current_inputfile^.get_file_line+
                             ' Note: IFNDEF '+preprocstack^.name+' found, ');
                             if preprocstack^.accept then
                               Comment(V_Conditional,'accepted')
                             else
                               Comment(V_conditional,'rejected');
                     end
                   else if hs='ELSE' then
                     begin
                        if assigned(preprocstack) then
                          begin
                             preprocstack:=new(ppreprocstack,init(PP_ELSE,
                             { invert }
                             not(preprocstack^.accept) and
                             { but only true, if only the ifdef block is }
                             { not accepted                              }
                             (
                               (preprocstack^.next=nil) or
                               (preprocstack^.next^.accept)
                             ),
                             preprocstack));
                             preprocstack^.line_nb := current_module^.current_inputfile^.line_no;
                             preprocstack^.name := preprocstack^.next^.name;
                             comment (V_Conditional, current_module^.current_inputfile^.get_file_line+
                                      ' Note: ELSE '+preprocstack^.name+' found, ');
                          end
                        else
                          error(preprocerror);
                     end
                   else if hs='IFOPT' then
                     begin
                        skipspace;
                        hs:=read_string;
                        preprocstack:=new(ppreprocstack,init(PP_IFDEF,
                          false,
                          preprocstack));
                     end;

                   { accept the text ? }
                   if (preprocstack=nil) or preprocstack^.accept then
                     break
                   else
                     begin
                        Comment (V_Conditional,'Skipping until ...');
                        skip_until_pragma;
                        hs:=read_string;
                     end;
                end;
           end
         else if hs='MESSAGE' then
           begin
              skipspace;
              write_c(c);
              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
              while c<>'}' do
                begin
                   write_c(c);
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
{$ifdef DOS}
              write_c(#13);
{$endif}
              write_c(#10);
           end
         else if hs='WARNING' then
           begin
              skipspace;
              warning(user_defined);
              write_c(c);
              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
              while c<>'}' do
                begin
                   write_c(c);
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
{$ifdef DOS}
              write_c(#13);
{$endif}
              write_c(#10);
           end
         else if hs='ERROR' then
           begin
              skipspace;
              error(user_defined);
              write_c(c);
              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
              while (c<>'}') do
                begin
                   write_c(c);
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
{$ifdef DOS}
              write_c(#13);
{$endif}
              write_c(#10);
           end
         else if hs='L' then
           begin
              skipspace;
              hs:='';
              while (c<>' ') and (c<>'}') and (c<>#10) and (c<>#13) do
                begin
                   hs:=hs+c;
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
{$ifdef tp}
              hs:=globals.lowercase(hs);
{$else}
              hs:=lowercase(hs);
{$endif}
              linkofiles.insert(hs);
           end
         else if hs='R' then
           begin
               if c='-' then
                 aktswitches:=aktswitches-[cs_rangechecking]
               else aktswitches:=aktswitches+[cs_rangechecking];
           end
         else if hs='Q' then
           begin
               if c='-' then
                 aktswitches:=aktswitches-[cs_check_overflow]
               else aktswitches:=aktswitches+[cs_check_overflow];
           end
         else if hs='S' then
           begin
               if c='-' then
                 aktswitches:=aktswitches-[cs_check_stack]
               else aktswitches:=aktswitches+[cs_check_stack];
           end
         else if hs='DEFINE' then
           begin
              skipspace;
              hs:=read_string;
              mac:=pmacrosym(macros^.search(hs));
              if not assigned(mac) then
                begin
                   mac:=new(pmacrosym,init(hs));
                   mac^.defined:=true;
                   Comment (V_Macro,'Macro defined: '+mac^.name);
                   macros^.insert(mac);
                end
              else
                begin
                   Comment (V_Macro,'Macro defined: '+mac^.name);
                   mac^.defined:=true;

                   { delete old definition }
                   if assigned(mac^.buftext) then
                     begin
                        freemem(mac^.buftext,mac^.buflen);
                        mac^.buftext:=nil;
                     end;
                end;
              if support_macros then
                begin
                   { key words are never substituted }
                   hs2:=pattern;
                   pattern:=hs;
                   if is_keyword(ht) then
                     warning(keyword_cant_be_a_macro);
                   pattern:=hs2;

                   skipspace;
                   { !!!!!! handle macro params, need we this? }

                   { may be a macro? }
                   if c='=' then
                     begin
                        { first char }
                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                        macropos:=0;
                        while (c<>'}') do
                          begin
                             macrobuffer^[macropos]:=c;
                             if c=#10 then write_line;
                             c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                             if c=#26 then fatalerror(endoffile);

                             inc(macropos);
                             if macropos>maxmacrolen then
                               fatalerror(macro_buffer_overflow);
                          end;

                        { free buffer of macro ?}
                        if assigned(mac^.buftext) then
                          freemem(mac^.buftext,mac^.buflen);

                        { get new mem }
                        getmem(mac^.buftext,macropos);
                        mac^.buflen:=macropos;

                        { copy the text }
                        move(macrobuffer^,mac^.buftext^,macropos);
                     end;
                end;
           end
         else if hs='UNDEF' then
           begin
              skipspace;
              hs:=read_string;
              mac:=pmacrosym(macros^.search(hs));
              if not assigned(mac) then
                begin
                   mac:=new(pmacrosym,init(hs));
                   Comment (V_Macro,'Macro undefined: '+mac^.name);
                   mac^.defined:=false;
                   macros^.insert(mac);
                end
              else
                begin
                   Comment (V_Macro,'Macro undefined: '+mac^.name);
                   mac^.defined:=false;
                   { delete old definition }
                   if assigned(mac^.buftext) then
                     begin
                        freemem(mac^.buftext,mac^.buflen);
                        mac^.buftext:=nil;
                     end;
                end;
           end
         else if hs='PACKRECORDS' then
           begin
              skipspace;
              if upcase(c)='N' then
                begin
                   hs:=read_string;
                   if hs='NORMAL' then
                     aktpackrecords:=2
                   else warning(only_pack_records_);
                end
              else
                case read_number of
                   1 : aktpackrecords:=1;
                   2 : aktpackrecords:=2;
                   4 : aktpackrecords:=4;
                   else warning(only_pack_records_);
                end;
           end
         { that is not a good solution
         because BP cannot compile such a directive
         else if hs='I386_INTEL' then
           aktasmmode:=I386_INTEL
         else if hs='I386_DIRECT' then
           aktasmmode:=I386_DIRECT
         else if hs='I386_ATT' then
           aktasmmode:=I386_ATT                     }
         else warning(ill_switch);
      end;

    procedure kommentar;

      begin
         inc(kommentarebene);
{$ifdef EXTDEBUG}
         { only warn for over one => incompatible with BP }
         if (kommentarebene>1) then
           begin
              current_module^.current_inputfile^.write_file_line(output);
              writeln(' Note: Comment level ',kommentarebene,' found');
           end;
{$endif EXTDEBUG}
         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
         while true do
           begin
              { handle compiler switches }
              if (kommentarebene=1) and (c='$') then
                handle_switches;
              { handle_switches can dec kommentarebene, }
              { if there is an include file             }
              while (c<>'}') and (kommentarebene>0) do
                begin
                   if c='{' then
                     kommentar
                   else
                     begin
                        if c=#26 then fatalerror(endoffile);
                        if c=#10 then write_line;
                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                     end;
                end;
              { this is needed for the include files      }
              { if there is a end of comment then read it }
              if c='}' then
                begin
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                   dec(kommentarebene);
{$ifdef EXTDEBUG}
                   if (kommentarebene>0) then
                     begin
                        current_module^.current_inputfile^.write_file_line(output);
                        writeln(' Note: Comment level ',kommentarebene,' found');
                     end;
{$endif EXTDEBUG}
                end;
              { checks }{ }
              if c='{' then
                begin
                   inc(kommentarebene);
{$ifdef EXTDEBUG}
                   if (kommentarebene>0) then
                     begin
                        current_module^.current_inputfile^.write_file_line(output);
                        writeln(' Note: Comment level ',kommentarebene,' found');
                     end;
{$endif EXTDEBUG}
                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                end
              else
                break;
           end;
      end;

   const
      yylexcount : longint = 0;

   function yylex : ttoken;

     var
        y : ttoken;
        code : word;
        l : longint;
        hs : string;
        mac : pmacrosym;
        hp : pinputfile;
        hp2 : pchar;

     begin
        { was the last character a point ? }

        { this code is needed because the scanner if there is a 1. found if  }
        { this is a floating point number or range like 1..3                 }
        if s_point then
          begin
             s_point:=false;
             if c='.' then
               begin
                  c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                  yylex:=POINTPOINT;
                  exit;
               end;
             yylex:=POINT;
             exit;
          end;

        if c='{' then kommentar;
        while (c=' ') or (c=#9) or (c=#13) or (c=#12) or (c=#10) do
          begin
             if c=#10 then write_line;
             c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
             if c='{' then kommentar;
          end;
        case c of
           'A'..'Z','a'..'z','_' : begin
                         orgpattern:=c;
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while ((ord(c)>=ord('A')) and (ord(c)<=ord('Z')))
                            or ((ord(c)>=ord('a')) and (ord(c)<=ord('z')))
                            or ((ord(c)>=ord('0')) and (ord(c)<=ord('9')))
                            or (c='_') do
                           begin
                              orgpattern:=orgpattern+c;
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                           pattern:=orgpattern;
                           uppervar(pattern);
                           if is_keyword(y) then
                             yylex:=y
			   else
                             begin
                                { this takes some time ... }
                                if support_macros then
                                  begin
                                     mac:=pmacrosym(macros^.search(pattern));
                                     if assigned(mac) and (assigned(mac^.buftext)) then
                                       begin
                                          { don't forget the last char }
                                          dec(inputpointer);
                                          current_module^.current_inputfile^.bufpos:=inputpointer;

                                          { this isn't a proper way, but ... }
                                          hp:=new(pinputfile,init('','Macro '+pattern,''));

                                          hp^.next:=current_module^.current_inputfile;
                                          current_module^.current_inputfile:=hp;
                                          current_module^.sourcefiles.register_file(hp);

                                          { set an own buffer }
                                          getmem(hp2,mac^.buflen+1);
                                          current_module^.current_inputfile^.setbuf(hp2,mac^.buflen+1);

                                          inputbuffer:=current_module^.current_inputfile^.buf;

                                          { copy text }
                                          move(mac^.buftext^,inputbuffer^,mac^.buflen);

                                          { put end sign }
                                          inputbuffer[mac^.buflen+1]:=#0;

                                          { load c }
                                          c:=inputbuffer[0];

                                          { point to the next char }
                                          inputpointer:=1;

                                          { handle empty macros }
                                          if c=#0 then reload;

                                          { play it again ... }
                                          inc(yylexcount);
                                          if yylexcount>16 then
                                            warning(macro_deep_ten);
{$ifdef TP}
                                          yylex:=yylex;
{$else}
                                          { for you, FPKPascal ... }
                                          yylex:=yylex();
{$endif}
                                          { that's all folks }
                                          dec(yylexcount);
                                          exit;
                                       end;
                                  end;
                                yylex:=ID;
                             end;
                           exit;
                      end;
           '$'      : begin
                         pattern:=c;
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) or
                                (ord(upcase(c))>=ord('A')) and (ord(upcase(c))<=ord('F')) do
                           begin
                              pattern:=pattern+c;
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                         yylex:=INTCONST;
                         exit;
                      end;
{$ifdef FPK}
           '%'      : begin
                         pattern:=c;
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while (c='0') or (c='1') do
                           begin
                              pattern:=pattern+c;
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                         yylex:=INTCONST;
                         exit;
                      end;
{$endif}
           '0'..'9' : begin
                         pattern:=c;
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
                           begin
                              pattern:=pattern+c;
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                         if (c='.') or (upcase(c)='E') then
                           begin
                              if c='.' then
                                begin
                                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if not((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) then
                                     begin
                                        s_point:=true;
                                        yylex:=INTCONST;
                                        exit;
                                     end;
                                   pattern:=pattern+'.';
                                   while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
                                     begin
                                        pattern:=pattern+c;
                                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                     end;
                                end;
                              if upcase(c)='E' then
                                begin
                                   pattern:=pattern+'E';
                                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if (c='-') or (c='+') then
                                     begin
                                        pattern:=pattern+c;
                                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                     end;
                                   if not((ord(c)>=ord('0')) and (ord(c)<=ord('9')))
                                     then fatalerror(ill_character);
                                   while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
                                     begin
                                        pattern:=pattern+c;
                                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                     end;
                                end;
                              yylex:=REALNUMBER;
                              exit;
                           end;
                         yylex:=INTCONST;
                         exit;
                      end;
           ';'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=SEMICOLON;
                         exit;
                      end;
           '['      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=LECKKLAMMER;
                         exit;
                      end;
           ']'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=RECKKLAMMER;
                         exit;
                      end;
           '('      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='*' then
                           begin
                              inc(kommentarebene);
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              while true do
                                begin
                                   { this is currently not supported }
                                   if c='$' then
                                     error(wrong_styled_switch);
                                   repeat
                                      while c<>'*' do
                                        begin
                                           if c=#26 then fatalerror(endoffile);
                                           if c=#10 then write_line;
                                           c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                        end;
                                      if c=#26 then fatalerror(endoffile);
                                      if c=#10 then write_line;
                                      c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   until c=')';
                                   dec(kommentarebene);

                                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   { check for *)(* }
                                   if c='(' then
                                     begin
                                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                        if c<>'*' then
                                          begin
                                             yylex:=LKLAMMER;
                                             exit;
                                          end;
                                        inc(kommentarebene);
                                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                     end
                                   else
                                     begin
{$ifdef FPK}
                                        yylex:=yylex();
{$else FPK}
                                        yylex:=yylex;
{$endif FPK}
                                        exit;
                                     end;
                                end;
                           end;
                         yylex:=LKLAMMER;
                         exit;
                      end;

           ')'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=RKLAMMER;
                         exit;
                      end;
           '+'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_PLUSASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=PLUS;
                              exit;
                           end;
                      end;
           '-'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_MINUSASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=MINUS;
                              exit;
                           end;
                      end;
           ':'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='=' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=ASSIGNMENT;
                              exit;
                           end
                         else
                           begin
                              yylex:=COLON;
                              exit;
                           end;
                      end;
           '*'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_STARASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=STAR;
                              exit;
                           end;
                      end;
           '/'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_SLASHASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=SLASH;
                              exit;
                           end;
                      end;
           '='      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=EQUAL;
                         exit;
                      end;
           '.'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='.' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=POINTPOINT;
                              exit;
                           end
                         else
                         yylex:=POINT;
                         exit;
                      end;
           '@'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=KLAMMERAFFE;
                         exit;
                      end;
           ','      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=COMMA;
                         exit;
                      end;
           '''','#','^' :
                      begin
                         if c='^' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              c:=upcase(c);
                              if not(parse_types) and (c>='A') and (c<='Z') then
                                begin
                                   pattern:=chr(ord(c)-64);
                                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                end
                              else
                                begin
                                   yylex:=CARET;
                                   exit;
                                end;
                           end
                         else pattern:='';
                         while true do
                           case c of
                             '#' :
                                begin
                                   hs:='';
                                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if c='$' then
                                     begin
                                        hs:='$';
                                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                        while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) or
                                          (ord(upcase(c))>=ord('A')) and (ord(upcase(c))<=ord('F')) do
                                          begin
                                             hs:=hs+upcase(c);
                                             c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          end;
                                     end
                                   else
                                   { FPKPascal supports binary constants }
                                   { %10101 evalutes to 37               }
{$ifdef FPK}
                                   if c='%' then
                                     begin
                                        c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                        while (c='0') or (c='1') do
                                          begin
                                             hs:=hs+upcase(c);
                                             c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          end;
                                     end
                                   else
{$endif}
                                     begin
                                        while (ord(c)>=ord('0')) and (ord(c)<=ord('9')) do
                                          begin
                                             hs:=hs+c;
                                             c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          end;
                                     end;
                                   val(hs,l,code);
                                   if (code<>0) or (l<0) or (l>255) then
                                     error(ill_char_const);
                                    pattern:=pattern+chr(l);
                                 end;
                             '''' :
                                begin
                                   c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if c=#13 then
                                     begin
                                        error(string_exceed_line);
                                        break;
                                     end;
                                   repeat
                                     if c=''''then
                                       begin
                                          c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          if c='''' then
                                            begin
                                               pattern:=pattern+'''';
                                               c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                               if c=#13 then
                                                 begin
                                                    error(string_exceed_line);
                                                    break;
                                                 end;
                                            end
                                          else break;
                                       end
                                     else
                                       begin
                                          pattern:=pattern+c;
                                          c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          if c=#13 then
                                            begin
                                               error(string_exceed_line);
                                               break
                                            end;
                                       end;
                                   until false;
                                end;
                             '^' : begin
                                      c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                      c:=upcase(c);
                                      if (c>='A') or (c<='Z') then
                                        pattern:=pattern+chr(ord(c)-64)
                                      else fatalerror(ill_character);
                                      c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   end;
                             else break;
                           end;
                         { strings with length 1 become const chars }
                         if length(pattern)=1 then
                           yylex:=CCHAR
                           else yylex:=CSTRING;
                         exit;
                      end;
           '>'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='=' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=GTE;
                              exit;
                           end
                         else if c='>' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_SHR;
                              exit;
                           end
                         else
                           begin
                              yylex:=GT;
                              exit;
                           end;
                      end;
           '<'      : begin
                         c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='>' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=UNEQUAL;
                              exit;
                           end
                         else if c='=' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=LTE;
                              exit;
                           end
                         else if c='<' then
                           begin
                              c:=inputbuffer[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_SHL;
                              exit;
                           end
                         else
                           begin
                              yylex:=LT;
                              exit;
                           end;
                      end;
           #26      : begin
                         yylex:=_EOF;
                         exit;
                      end;
           else
             begin
                exterror:=strpnew(c);
                fatalerror(ill_character);
             end;
        end;
     end;

    const last_asmgetchar_was_a_comment : boolean = false;

    function asmgetchar : char;

      begin
         if c='{' then
           begin
              kommentar;
              { a comment is a seperator }
              asmgetchar:=';';
              last_asmgetchar_was_a_comment:=true;
           end
         else
           begin
              if last_asmgetchar_was_a_comment then
                begin
                   last_asmgetchar_was_a_comment:=false;
                   asmgetchar:=c;
                   exit;
                end;
              c:=inputbuffer[inputpointer];
              inc(inputpointer);if c=#0 then reload;
              asmgetchar:=c;
           end;
      end;

   procedure initscanner(const d,n,e : string);

     begin
        current_module^.current_inputfile:=new(pinputfile,init(d,n,e));
        current_module^.current_inputfile^.reset;

        current_module^.sourcefiles.register_file(current_module^.current_inputfile);

        if ioresult<>0 then
          fatalerror(cannot_open_input);

        inputbuffer:=current_module^.current_inputfile^.buf;
        preprocstack:=nil;
        reload;
        kommentarebene:=0;
        s_point:=false;
     end;

   procedure donescanner;

     var
        st : string;

     begin
        if assigned(preprocstack) then
          begin
             if preprocstack^.t=PP_IFDEF then
               st:='$IFDEF ' else st := '$ELSE ';
             exterror:=strpnew('for '+st+'at '+
             preprocstack^.name+' '+
               +tostr(preprocstack^.line_nb));
             error(endif_expect);
          end;
     end;

end.
