{****************************************************************************

                      Copyright (c) 1996 by Florian Klaempfl

 ****************************************************************************}

{
  this unit reads inline assembler for the i386 (att styled)

  History:
       9th december 1996:
         + created from rai386

  What's to do:
    o local labels
    o instructions with operands
    o pascal labels
    o data
    o expressions
}
unit ratti386;

  interface

     uses
        cobjects,globals,errors,aasm,symtable,scanner,tree,i386,
        rasm386,attasmi3;

     function assemble : ptree;

  implementation

    const
       _count_asmkeywords = 8;

       _asmkeywords : array[1.._count_asmkeywords] of tasmkeyword = (
                 'DB','DD','DF','DP','DQ','DT','DW','END');

       _asmkeyword_token : array[1.._count_asmkeywords] of tasmtoken = (
                 A_DB,A_DD,A_DF,A_DP,A_DQ,A_DT,A_DW,A_END);

    function assemble : ptree;

      var
         id,hid : string;
         instruc : tasmop;
         size : topsize;

      function read_operand(var op : pointer) : longint;

        function read_register : tregister;

          var
             s : string;
             found : boolean;
             i : tregister;

          begin
             i:=R_NO;
             consume(A_PERCENT);
             if actasmtoken=A_ID then
               begin
                  s:='%'+actasmpattern;
                  found:=false;
                  for i:=R_EAX to R_SS do
                    if upper(attasmi3._reg2str[i])=s then
                      begin
                         found:=true;
                         break;
                      end;
                  if not(found) then
                    error(register_name_expected)
                  else
                    read_register:=i;
                  consume(A_ID);
               end
             else
               error(register_name_expected);
          end;

        var
           optype : longint;

        begin
           case actasmtoken of
              A_PERCENT : begin
                             op:=pointer(read_register);
                             case tregister(op) of
                                R_EAX..R_EDI : optype:=ao_reg32;
                                R_AX..R_DI : optype:=ao_reg16;
                                R_AL..R_DH : optype:=ao_reg8;
                                R_CS,R_ES,R_DS,R_SS : optype:=ao_sreg2;
                                R_FS,R_GS : optype:=ao_sreg3;
                                R_NO : optype:=ao_reg;
                                else internalerror(30005);
                             end;
                          end;
              else consume(A_ID);
           end;
           if ((optype and ao_reg8)<>0) and (tregister(op)=R_CL) then
             inc(optype,ao_shiftcount);
           if ((optype and ao_reg16)<>0) and (tregister(op)=R_DX) then
             inc(optype,ao_inoutportreg);
           read_operand:=optype;
        end;

      var
         p : paasmoutput;

         { true, if the current instruction fits to any template }
         fits : boolean;

         { true, if an assembler instruction is recognized }
         found : boolean;

         { true, if the operands are swaped }
         do_swap : boolean;
         i,opcount : longint;

         { type of the operands }
         optyp1,optyp2,optyp3 : longint;

         op1,op2,op3 : pointer;

         hi : tasmop;

         hs : topsize;

      begin
         { setup the scanner }
         { for AT&T assembler }
         count_asmkeywords:=_count_asmkeywords;

         { the pointer don't match, because the generic array has }
         { 255 elements                                           }
         asmkeywords:=pointer(@_asmkeywords);
         asmkeyword_token:=pointer(@_asmkeyword_token);

         p:=new(paasmoutput,init);
         c:=asmgetchar;
         actasmtoken:=gettoken;
         while actasmtoken<>A_END do
           begin
              case actasmtoken of
                 A_KLAMMERAFFE : begin
                                  { local label }
                                 end;
                 A_ID : begin
                           id:=actasmpattern;
                           found:=false;

                           { search for an asm instruction }
                           { without cutting off the size  }
                           { prefix                        }
                           for instruc:=attasmi3.firstop to attasmi3.lastop do
                             if id=upper(attasmi3.op2str[instruc]) then
                               begin
                                  found:=true;
                                  size:=S_NO;
                                  break;
                               end;

                           { search for all possible prefixes }
                           for hs:=S_WL downto S_B do
                             if copy(id,length(id)-length(opsize2str[hs])+1,
                               length(opsize2str[size]))=upper(opsize2str[hs]) then
                               begin
                                  hid:=copy(id,1,length(id)-length(opsize2str[hs]));
                                  for hi:=attasmi3.firstop to attasmi3.lastop do
                                    if hid=upper(attasmi3.op2str[hi]) then
                                      begin
                                         found:=true;
                                         instruc:=hi;
                                         size:=hs;
                                         break;
                                      end;
                                  if found then
                                    break;
                               end;

                           if found then
                             begin
                                consume(A_ID);
                                if actasmtoken<>A_SEPERATOR then
                                  begin
                                     optyp1:=read_operand(op1);
                                     opcount:=1;
                                     if actasmtoken<>A_SEPERATOR then
                                       begin
                                          optyp2:=read_operand(op2);
                                          opcount:=2;
                                          if actasmtoken<>A_SEPERATOR then
                                            begin
                                               optyp3:=read_operand(op3);
                                               opcount:=3;
                                            end;
                                       end;
                                  end
                                else
                                  begin
                                     { assembler instruction with no operand }
                                     opcount:=0;
                                  end;
                                { after reading the operands }
                                { search the instruction     }
                                { setup startvalue from cache }
                                if ins_cache[instruc]<>-1 then
                                  i:=ins_cache[instruc]
                                else i:=0;
                                fits:=false;
                                while not(fits) do
                                  begin
                                     { set the instruction cache, if the instruction }
                                     { occurs the first time                         }
                                     if (it[i].i=instruc) and (ins_cache[instruc]=-1) then
                                       ins_cache[instruc]:=i;

                                     if (it[i].i=instruc) and (opcount=it[i].ops) then
                                       begin
                                          do_swap:=false;
                                          { first fit }
                                          case opcount of
                                             0 : begin
                                                    fits:=true;
                                                    p^.concat(new(pai386,op_none(instruc,S_NO)));
                                                 end;
                                             1 : if (optyp1 and it[i].o1)<>0 then
                                                   begin
                                                      fits:=true;
                                                      if ((optyp1 and ao_reg)<>0) then
                                                        begin
                                                           case size of
                                                              S_B : if (optyp1 and ao_reg8)=0 then
                                                                      error(_asm_size_mismatch);
                                                              S_W : if (optyp1 and ao_reg16)=0 then
                                                                      error(_asm_size_mismatch);
                                                              S_L : if (optyp1 and ao_reg32)=0 then
                                                                      error(_asm_size_mismatch);
                                                              S_NO : ;
                                                              else error(_asm_size_mismatch);
                                                           end;
                                                           p^.concat(new(pai386,op_reg(instruc,size,tregister(op1))));
                                                        end;
                                                   end;
                                             2 : if ((optyp1 and it[i].o1)<>0) and
                                                    ((optyp2 and it[i].o2)<>0) then
                                                   begin
                                                      fits:=true
                                                   end
                                                 { if the operands can be swaped }
                                                 { then swap them                }
                                                 else if ((it[i].m and af_d)<>0) and
                                                    ((optyp1 and it[i].o2)<>0) and
                                                    ((optyp2 and it[i].o1)<>0) then
                                                    begin
                                                       do_swap:=true;
                                                       fits:=true;
                                                    end;
                                             3 : if ((optyp1 and it[i].o1)<>0) and
                                                    ((optyp2 and it[i].o2)<>0) and
                                                    ((optyp3 and it[i].o3)<>0) then
                                                   fits:=true;
                                          end;
                                       end;
                                     if it[i].i=A_NONE then
                                       begin
                                          error(_no_instr_match);
                                          break;
                                       end;
                                     inc(i);
                                  end;
                             end;
                           consume(A_SEPERATOR);
                        end;
                 A_SEPERATOR : consume(A_SEPERATOR);
                 else consume(A_ID);
              end;
           end;
         assemble:=genasmnode(p);
      end;

end.
