Unit v2heap;

Interface

Function GrowHeap(size :longint) : integer;

Function HeapSize : Longint;

Implementation

    type
       pfreerecord = ^tfreerecord;

       tfreerecord = record
          next : pfreerecord;
          size : longint;
       end;


var _HeapSize : longint;

Function HeapSize : Longint;
Begin
HeapSize:=_HeapSize;
End;

Function GrowHeap(size :longint) : integer;
Var NewPos : pointer;
         hp : pfreerecord;


Begin
Size := Size+$FFFF;
Size := Size and $FFFF0000;
{ Allocate by 64K size }
asm
   movl Size,%eax
   pushl %eax
   call ___sbrk
   addl $4,%esp
   movl %eax,NewPos
end;
   if (longint(NewPos) = -1) then
     Begin
     GrowHeap:=0;
{$IfDef DEBUG}
     writeln('Call to GrowHeap failed');
{$EndIf DEBUG}
     Exit;
     End else
     Begin
     hp:=pfreerecord(freelist);
     if not assigned(hp) then
       begin
       freelist:=heapptr;
       hp:=pfreerecord(freelist);
       hp^.size:=heapend-heapptr;
       hp^.next:=nil;
       heapptr:=newpos;
       heapend:=newpos+size;
       end else
       begin
       while assigned(hp^.next) and (longint(hp^.next) < longint(NewPos))
         do hp:=hp^.next;
       if hp^.next = nil then
         Begin
         hp^.next:=pfreerecord(heapptr);
         hp:=pfreerecord(heapptr);
         hp^.size:=heapend-heapptr;
         hp^.next:=nil;
         heapptr:=NewPos;
         heapend:=NewPos+Size;
         end else
	 begin
         pfreerecord(NewPos)^.Size:=Size;
         pfreerecord(NewPos)^.Next:=hp^.next;
         hp^.next:=pfreerecord(NewPos);
         end;
       End;
{$IfDef DEBUG}
     writeln('Call to GrowHeap succedeed');
{$EndIf DEBUG}
     Cal_memavail;
     _HeapSize:=_HeapSize+Size;
     GrowHeap:=2;{ try again }
     Exit;
     End;
End;

Begin
HeapError:=@GrowHeap;
_HeapSize:=longint(heapend)-longint(heaporg);
End.