/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __LB_POINTERCHUNK__
#include "LB_PointerChunk.h"
#endif
#ifndef __LB_CHUNKDATA__
#include "LB_ChunkData.h"
#endif
#ifndef __MM_MEMORYMANAGER__
#include "MM_MemoryManager.h"
#endif
#ifndef __SN_EXCEPTION__
#include "SN_Exception.h"
#endif
#ifndef __EX_EXTERMINATOR__
#include "EX_Exterminator.h"
#endif

LB_PointerChunk::LB_PointerChunk(Ptr pData)
{
	// Use the data pointer.
	UseData((LB_DataReference) pData);
}

LB_PointerChunk::LB_PointerChunk(LB_DataSize dataSize)
{
	// Create the data pointer.
	Ptr			pData;
	
	MM_AllocateNonRelocatableData(dataSize, pData);
	UseData((LB_DataReference) pData);
}

LB_PointerChunk::~LB_PointerChunk()
{
	// This must be here because by the time we get to the LB_DataChunk destructor,
	// we can no longer access the subclass's methods.
	DestroyData();
}

SN_Error LB_PointerChunk::DestroyData()
{
	SN_Error			result;
	
	EX_TRY
	{
		EX_THROW_FALSE(HasValidData());
		
		Ptr			pData = GetData();
		
		// If the pointer exists, release it from memory.
		EX_THROW_ERROR(MM_ReleaseNonRelocatableData(pData));
		UseData(nil);
	}
	catch (SN_Exception& rException)
	{
		result = rException;
	}
	
	return result;
}

SN_Error LB_PointerChunk::RetrieveData(LB_ChunkData& rChunkData)
{
	SN_Error			result;
	
	EX_TRY
	{
		rChunkData.UseData(nil);
		EX_THROW_FALSE(HasValidData());

		// The chunk data acts as a pointer.
		rChunkData.UseData(GetData());
		rChunkData.UseChunk(this);
		
		AddDependancy();
	}
	catch (SN_Exception& rException)
	{
		result = rException;
	}
	
	return result;
}

LB_DataSize LB_PointerChunk::GetDataSize()
{
	LB_DataSize			result = 0;
	
	if (HasValidData())
		// The data size is the size of the pointer.
		result = GetPtrSize((Ptr) GetData());
		
	return result;
}

LB_DataSize LB_PointerChunk::SetDataSize(LB_DataSize newSize)
{
	if (HasValidData())
		// Resize the data.
		SetPtrSize((Ptr) GetData(), newSize);
		
	return GetDataSize();
}
