/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __LB_DATACHUNK__
#include "LB_DataChunk.h"
#endif
#ifndef __SN_EXCEPTION__
#include "SN_Exception.h"
#endif
#ifndef __EX_EXTERMINATOR__
#include "EX_Exterminator.h"
#endif
 
LB_DataChunk::LB_DataChunk()
{
	lbd_refCount = 0;
	UseData(nil);
}

LB_DataChunk::~LB_DataChunk()
{
	// Can't release data here because by the time we get to the LB_DataChunk destructor,
	// we can no longer access the subclass's methods.
}

SN_Error LB_DataChunk::UseData(LB_DataReference dataReference)
{
	SN_Error			result;
	
	EX_TRY
	{
		// This is new data, so all other dependants are invalid.
		EX_THROW_ERROR(RemoveAllDependancies());
		
		// Store the data (it isn't necessarily a Handle).
		this->lbd_dataReference = dataReference;
	}
	catch (SN_Exception& rException)
	{
		result = rException;
	}
	
	return result;
}

SN_Error LB_DataChunk::ReleaseData(LB_DataReference dataReference)
{
	SN_Error			result;
	
	if (MyDependancy(dataReference))
		result = RemoveDependancy();
		
	return result;
}

Boolean LB_DataChunk::MyDependancy(LB_DataReference dataReference)
{
	Boolean			result = false;
	
	if (GetData() == dataReference && CountDependancies() > 0)
		// This is my dependancy.
		result = true;
	
	return result;
}

LB_DataSize LB_DataChunk::ExtractData(Ptr pDestination, LB_DataSize extractOffset, LB_DataSize extractSize)
{
	LB_DataSize			result = 0;
	Ptr					pData = GetRealData();
	
	EX_TRY
	{
		// This must be able to fit inside the destination.
		EX_THROW_TRUE((extractOffset + extractSize) > GetPtrSize(pDestination));
		
		// Check the validity of the pointers.
		EX_THROW_NIL(pData);
		EX_THROW_NIL(pDestination);
		
		// Offset the source pointer.
		pData = (Ptr) (((long) pData) + extractOffset);
		
		// Copy the data into the data chunk.
		BlockMove(pData, pDestination, extractSize);
		result = extractSize;
	}
	catch (SN_Exception& error)
	{
	}
	
	return result;
}

LB_DataSize LB_DataChunk::StuffData(Ptr pData, LB_DataSize stuffOffset, LB_DataSize stuffSize)
{
	Ptr				pDestination = GetRealData();
	LB_DataSize		result = 0;

	EX_TRY
	{
		// This must be able to fit inside the data chunk.
		EX_THROW_TRUE((stuffOffset + stuffSize) > GetDataSize());
		
		// Check the validity of the pointers.
		EX_THROW_NIL(pData);
		EX_THROW_NIL(pDestination);
		
		// Offset the destination pointer.
		pDestination = (Ptr) (((long) pDestination) + stuffOffset);
		
		// Copy the data into the data chunk.
		BlockMove(pData, pDestination, stuffSize);
		result = stuffSize;
	}
	catch (SN_Exception& error)
	{
	}
		
	return result;
}

LB_DataSize LB_DataChunk::StuffAndOffsetData(Ptr pData, LB_DataSize& rStuffOffset, LB_DataSize stuffSize)
{
	LB_DataSize			result = StuffData(pData, rStuffOffset, stuffSize);
	
	// Increment the total data offset.
	rStuffOffset += result;
	
	return result;
}

LB_DataSize LB_DataChunk::StuffOffsetAndResizeData(Ptr pData, LB_DataSize& rStuffOffset, LB_DataSize stuffSize)
{
	if ((rStuffOffset + stuffSize) > GetDataSize())
		// This data is too big to be stuffed into the chunk, so the chunk must be resized.
		SetDataSize(rStuffOffset + stuffSize);
		
	return StuffAndOffsetData(pData, rStuffOffset, stuffSize);
}

SN_Error LB_DataChunk::AddDependancy()
{
	SN_Error			result;
	
	lbd_refCount++;
	
	return  result;
}
	
SN_Error LB_DataChunk::RemoveDependancy()
{
	SN_Error			result;
	
	lbd_refCount--;
	
	return result;
}

SN_Error LB_DataChunk::RemoveAllDependancies()
{
	SN_Error result;
	
	lbd_refCount = 0;
	
	return result;
}
