/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __LB_CHUNKDATA__
#define __LB_CHUNKDATA__

#ifndef __LB_TYPES__
#include "LB_Types.h"
#endif

/*
	LB_ChunkData used to update LB_DataChunk's refCount in destructor.
 */

class LB_DataChunk; 
class LB_ChunkData
{
protected:
	LB_DataChunk*		lbc_pChunk;
	LB_DataReference	lbc_pData;
	
public:
	LB_ChunkData();
	LB_ChunkData(Ptr pData);
	virtual ~LB_ChunkData();
	
	// Data size routines.
	LB_DataSize GetDataSize();

	// Accessors.
	LB_DataReference GetData() { return lbc_pData; };	
	LB_DataChunk* GetChunk() { return lbc_pChunk; };
	Boolean HasChunk() { return (GetChunk() != nil); };
	
	// Mutators.
	void UseData(LB_DataReference pData);
	void UseChunk(LB_DataChunk* pChunk) { this->lbc_pChunk = pChunk; };
};

#endif
