/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __FT_TAGGABLEOBJECT__
#define __FT_TAGGABLEOBJECT__

#ifndef __FT_TAG__
#include "FT_Tag.h"
#endif
#ifndef __LL_COLLECTABLE__
#include "LL_Collectable.h"
#endif
#ifndef __SN_ERROR__
#include "SN_Error.h"
#endif
#ifndef __TW_PASCALSTRING__
#include "TW_PascalString.h"
#endif

/*
	FT_TaggableObject provides properties for all objects that can have tags
	attached to them.
 */
 
class FT_TaggableObject:virtual public LL_Collectable<FT_Tag>
{
protected:
	virtual SN_Error AddTag(FT_Tag& rTag);
	virtual SN_Error RetrieveTagElement(FT_TagName tagName, FY_TCollection<FT_Tag>::FY_CollectionElement*& rpElement);
	 
public:
	FT_TaggableObject();
	virtual ~FT_TaggableObject();
	virtual SN_Error Dispose(Boolean destroy = true, Boolean stopOnError = false);

	// Basic tag routines.	
	virtual SN_Error AttachTag(FT_TagName tagName, FT_TagType tagType,
							   FT_TagData tagData, FT_TagDataSize tagDataSize);
	virtual SN_Error RemoveTag(FT_TagName tagName);
	virtual SN_Error RemoveAllTags();
	virtual SN_Error RetrieveTag(FT_TagName tagName, FT_Tag*& rpTag);
	virtual SN_Error CountTags(FT_TagIndex& rTagCount);

	// Data allocation routines.
	virtual SN_Error AllocateTagData(FT_TagData& rTagData, FT_TagDataSize tagDataSize);
	virtual SN_Error DisposeTagData(FT_TagData& rTagData);
	virtual SN_Error ResizeTagData(FT_TagData& rTagData, FT_TagDataSize tagDataSize);
	virtual FT_TagData GetAllocatedTagData(FT_TagDataSize tagDataSize);

	// Advanced tag routines.
	virtual SN_Error AttachDataTag(FT_TagName tagName, FT_TagType tagType, FT_TagData tagData);
	virtual SN_Error AttachDataTagWithValue(FT_TagName tagName, FT_TagType tagType, FT_TagData tagData, Ptr pDefaultData);
	virtual SN_Error AttachTagWithValue(FT_TagName tagName, FT_TagType tagType, FT_TagData tagData, FT_TagDataSize tagDataSize, Ptr pDefaultData);
	virtual SN_Error AttachCreatedTag(FT_TagName tagName, FT_TagType tagType, FT_TagData tagData, FT_TagDataSize tagDataSize, FT_Tag*& rpTag);
	virtual SN_Error AttachExtendedTag(FT_TagName tagName, FT_TagType tagType, FT_Tag* pTag);
	virtual SN_Error RetrieveTagNeedsDataAndType(FT_TagName tagName, FT_TagType tagType, FT_Tag*& rpTag);
	virtual SN_Error RetrieveAndStuffTagNeedsDataAndType(FT_TagName tagName, FT_TagType tagType, FT_Tag*& rpFoundTag, Ptr pStuffedData);
	virtual SN_Error RetrieveTagWithIndex(FT_TagIndex tagIndex, FT_Tag*& rpTag);
	virtual SN_Error RetrieveTagWithTypeAndIndex(FT_TagType tagType, FT_TagIndex tagIndex, FT_Tag*& rpTag);
	
	// Data routines.
	virtual SN_Error CalculateTotalDataSize(FT_TagDataSize& rTotalDataSize);
	virtual SN_Error CalculateTotalDataSizeWithHeader(FT_TagDataSize& rTotalDataSize, FT_TagDataSize headerSize);
	virtual SN_Error RetrieveTagData(FT_TagName tagName, FT_TagData& rTagData);
	virtual SN_Error RetrieveTagDataReference(FT_TagName tagName, Ptr& rpTagData);
};

#endif
