/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __FT_TAG__
#define __FT_TAG__

#ifndef __FT_TYPES__
#include "FT_Types.h"
#endif
#ifndef __LL_TYPABLE__
#include "LL_Typable.h"
#endif
#ifndef __SN_ERROR__
#include "SN_Error.h"
#endif

/*
	FT_Tag provides properties for all objects that can be attached to other objects.
 */

class FT_Tag:public LL_Typable
{
protected:
	FT_TagData			ftt_tagData;
	FT_TagDataSize		ftt_tagDataSize;
	FT_TagName			ftt_tagName;
	
public:
	FT_Tag();
	virtual ~FT_Tag();
	virtual SN_Error Dispose(Boolean destroy = true, Boolean stopOnError = false);

	// Data routines.
	virtual SN_Error ResizeData(FT_TagDataSize tagDataSize);
	
	// Accessors.
	virtual Boolean HasData();
	virtual FT_TagData GetData();
	virtual FT_TagDataSize GetDataSize();
	virtual FT_TagDataSize GetDataSizeWithHeader(FT_TagDataSize headerSize);
	virtual FT_TagName GetName() { return ftt_tagName; };
		
	// Mutators.
	virtual void SetData(FT_TagData tagData, FT_TagDataSize tagDataSize);
	virtual void SetName(FT_TagName tagName) { this->ftt_tagName = tagName; };
	virtual void SetDataSize(FT_TagDataSize tagDataSize) { this->ftt_tagDataSize = tagDataSize; };
};
 
#endif
