package bmsi.tui;
import java.awt.*;
import java.awt.image.*;

/** Lobotomized FontMetrics for TUI displays.
 * TUI supports multiple fonts, but all are the same size.  It is often
 * possible to support simple size variations.  For instance, a double high
 * font could be implemented with 2 font banks - top part and bottom part.
 * Some TUI hardware can set specific lines to double high or double wide.
 * This does not fit into the window model and could only be used in a
 * device specific manner.  Typical TUI displays have from 2 - 4 128 char
 * font banks.  The Link terminals used by BMS have 4 banks.  EGA/VGA text
 * mode on PC's also has 4 banks.  Software text mode emulation under Windows
 * or OS/2, however, has only 2 banks which are hardwired to the IBMPC
 * charset.
 */

class TUIFontMetrics extends FontMetrics {
  private Dimension scale;
  TUIFontMetrics(Font font,TUIKit toolkit) {
    super(font);
    scale = toolkit.scale(new Dimension(1,1));
  }
  public int getLeading() { return 0; }
  public int getAscent() { return scale.height; }
  public int getDescent() { return 0; }
  public int getMaxAscent() { return scale.height; }
  public int getMaxDescent() { return 0; }
  public int getMaxAdvance() { return scale.width; }
  public int charWidth(int ch) { return scale.width; }
  public int charWidth(char ch) { return scale.width; }
  public int stringWidth(String s) { return s.length() * scale.width; }
  public int charsWidth(char [] data,int pos,int len) {
    return len * scale.width;
  }
  public int bytesWidth(byte [] data,int pos,int len) {
    return len * scale.width;
  }
}

/** ColorModel for monochrome terminals.
 * Colors are black, gray, white, and transparent.
 */

class TUIColorModel extends ColorModel {
  TUIColorModel() { super(2); }
  private static short[] alpha = { 255,255,255,0 };
  private static short[] bright = { 0, 127, 255, 0 };
  public int getAlpha(int pixel) { return alpha[pixel]; }
  public int getBlue(int pixel) { return bright[pixel]; }
  public int getRed(int pixel) { return bright[pixel]; }
  public int getGreen(int pixel) { return bright[pixel]; }
  static int getGrayLevel(Color c) {
    int red = c.getRed();
    int blue = c.getBlue();
    int green = c.getGreen();
    return (red + blue + blue + green) / 4;
  }
  static int getTextPixel(Color c) {
    int gray = getGrayLevel(c);
    if (gray < 32) return 0;
    if (gray < 192) return 1;
    return 2;
  }
}
