package bmsi.tui;

import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/** TUISync is responsible for ensuring that a toolkit.flush() is
    eventually called.  We currently do this by queueing a new event
    to a dummy component. */
class TUISync extends MenuItem implements ActionListener {
  private TUIKit toolkit;
  TUISync(TUIKit toolkit) {
    this.toolkit = toolkit;
    addActionListener(this);
  }
  public void actionPerformed(ActionEvent e) {
    toolkit.flush();
  }
  //  arrange for flush at a later time
  final void queue() {
    toolkit.theQueue.postEvent(
      new ActionEvent(this,ActionEvent.ACTION_PERFORMED,"",0)
    );
  }
}
