package bmsi.tui;
import java.io.IOException;

/** The interface for local java.awt.peer implementations which have a
  counterpart in a remote program.  This will soon become an abstract base
  class so that more behaviour can be standardized.
 */

interface RemotePeer {
  /** execute a command from our remote object */
  void remoteMethod(int cmd) throws IOException;
  /** return the object id our remote object knows us by. */
  int getID();
  /** return the java.awt Component or MenuComponent for this peer. */
  Object getTarget();
  /** the methods we and our remote object must implement.
     @see TUIGraphics
   */
  final static int
    DISABLE = 1,
    ENABLE = 2,
    HIDE = 3,
    SHOW = 4,
    NEXTFOCUS = 5,
    REQUESTFOCUS = 6,
    RESHAPE = 7,	// IIII
    SETBACKGROUND = 8,	// I
    SETFOREGROUND = 9, // I
    SETFONT = 10,	// sII

    SETALIGNMENT = 12, // I
    SETTEXT = 13,	// s
    GETSELECTEND = 14,	// Ri
    GETSELECTBEG = 15,	// Ri
    GETTEXT = 16,	// Rs
    SELECT = 17,	// II
    SETEDITABLE = 18,	// I
    SETECHOCHAR = 19,	// I
    ADDCHOICEITEM = 20,	// sI
    REPLACETEXT = 21,	// sII
    TOBACK = 22,
    TOFRONT = 23,
    SETCURSOR = 24,	// I (mouse cursor type)
    SETMENU = 25,	// o
    SETRESIZABLE = 26,	// I
    SETTITLE = 27,	// s
    ADDCOMPONENT = 28,	// o
    REPAINT = 29,	// IIII
    SELECTCHOICE = 30,	// I
    SETSTATE = 31,	// I
    ADDLISTITEM = ADDCHOICEITEM,
    CLEARLIST = 32,
    DELITEMS = 33,	// II
    DESELECT = 34,	// I
    REMOVECHOICE = 35,	// I
    MAKEVISIBLE = 36,	// I
    SELECTLIST = SELECTCHOICE,
    SETMULTIPLE = 37,	// I
    SCROLL_LINEINC = 38,
    SCROLL_PAGEINC = 39,
    SETVALUE = 40,	// I
    SETVALUES = 41,	// IIII
    KEYPRESS = 42,	// II
    BEEP = 43,
    SETMODIFIED = 44,
    SCROLL_LINEDEC = 45,
    SCROLL_PAGEDEC = 46,
    NEWFRAME = 100,	// I
    NEWWINDOW = 101,	// I
    SYNC = 102,
    NEWMENU = 103,	// I
    NEWMENUITEM = 104,	// I
    NEWMENUBAR = 105,	// I
    RETSHORT = 106,	// I
    SCREENSIZE = 107,	// II
    NEWLABEL = 108,	// I
    RETSTRING = 109,	// s
    NEWTEXTAREA = 110,	// I
    NEWTEXTFIELD = 111,	// I
    NEWPANEL = 112,	// I
    NEWBUTTON = 113,	// I
    NEWCANVAS = 114,	// I
    NEWCHOICE = 115,	// I
    NEWLIST = 116,	// I
    NEWCHECKBOX = 117,	// I
    NEWCHECKMENUITEM = 118, // I
    NEWSCROLLPANE = 119,// I
    NEWDIALOG = 120,	// I
    NEWFILEDIALOG = 121,// I
    NEWPOPUPMENU = 122, // I
    NEWHORZSCROLL = 123,// I
    NEWVERTSCROLL = 124,// I
    // MenuBar
    ADDHELPMENU = 200,	// o
    ADDMENU = 201,	// o
    DELMENU = 202,	// I
    // MenuItem
    SETLABEL = SETTEXT,	// s
    // Menu
    ADDITEM = 203,	// o
    ADDSEP = 204,
    DELITEM = 205,	// I
    MENUPICK = 206,
    // Program
    RUNCLASS = 500,	// s
    SETEXTENSION = 501,	// s
    SETSCALE = 502,	// II

    DISPOSE = 0;
}
