package bmsi.tui;

import java.io.File;
import java.io.FilenameFilter;

/** This FilenameFilter was adapted from sun.awt.tiny.  It was supposed to do
 unix style wildcards, but didn't work at all at first!  It seems to be OK
 now but I haven't tested it thoroughly and it does not support '?' or '['.  
 I.e., only '*' is recognized.  I have a 'C' routine that can be ported when
 I get a chance.

 As long as we are used only in FileDialog there is little danger since the
 generated list is just to look at.  I would *not* use this class for a
 delete utility without full testing!
 */

class FileDialogFilter implements FilenameFilter {
  String filter;

  public FileDialogFilter(String string) {
    filter = string;
  }

  public boolean accept(File dir, String filename) {
    File file = new File(dir, filename);
    if (file.isDirectory() || filter.equals("*"))
      return true;
    else
      return handleStar(filename, filter);
  }

  private static boolean handleStar(String name, String filter) {
    int flen = filter.length();
    int nlen = name.length();
    int k1 = 0;
    int i2 = 0;
    int j2 = 0;
    if (flen == 0)
      return true;
    while (j2 < nlen) {
      char ch1 = filter.charAt(k1);
      if (ch1 == 42) {
	String string3 = filter.substring(k1 + 1);
	String string4 = name.substring(i2);
	if (handleStar(string4, string3))
	  return true;
	i2 = ++j2;
	k1 = 0;
      }
      else {
	char ch3 = name.charAt(i2);
	if (ch1 == ch3) {
	  k1++;
	  if (++i2 == nlen && k1 == flen)
	    return true;
	  if (i2 < nlen && k1 == flen)
	    return false;
	  if (i2 == nlen)
	    j2 = nlen;
	}
	else {
	  i2 = ++j2;
	  k1 = 0;
	  if (j2 == nlen)
	    return false;
	}
      }
    }
    for (int k2 = k1; k2 < flen; k2++) {
      char ch2 = filter.charAt(k2);
      if (ch2 != 42)
	return false;
    }
    return true;
  }
}
