#include "toolhelp.h"
#include "string.h"
#include <windows.h>
#include <tlhelp32.h>

jobject CreateProcessEntry32( JNIEnv * env, LPPROCESSENTRY32 lppe);

BOOL SetDWORDField( JNIEnv * env, DWORD field, jobject procEntry32, char *szField);
BOOL SetStringField( JNIEnv * env, char *field, jobject procEntry32, char *szField);

BOOL IsValidField(jfieldID jfield, char *szField);
BOOL AddObject (JNIEnv *env, jobject vector, jobject ProcEntry32);



JNIEXPORT jboolean JNICALL Java_ToolHelp_CreateToolhelp32Snapshot
  (JNIEnv *env, jobject, jint, jint process, jobject vector)
{
	HANDLE handle =  CreateToolhelp32Snapshot(
		TH32CS_SNAPPROCESS, 
		process);

	BOOL first = TRUE;
	
	jobject ProcEntry32;
	PROCESSENTRY32 ppe;
	do {
		ppe.dwSize = sizeof( PROCESSENTRY32 );

		if(first)
		{
			first = FALSE;
			if ( !Process32First( handle, &ppe))
				return FALSE;
		}
		else
		{
			if ( !Process32Next( handle, &ppe))
				return FALSE;
		}
		ProcEntry32 = CreateProcessEntry32(env, &ppe);
	}
	while(AddObject(env, vector,ProcEntry32 ) );	
	
	return TRUE;
}

BOOL AddObject (JNIEnv *env, 
				jobject vector, 
				jobject ProcEntry32)
{
	if(ProcEntry32 == NULL)
		return FALSE;

	jmethodID jmAddElement = env->GetMethodID(
		env->GetObjectClass(vector),
		"addElement", 
		"(Ljava/lang/Object;)V");

	if(jmAddElement == NULL)
		return FALSE;

	env->CallVoidMethod(vector, jmAddElement, ProcEntry32);
	return TRUE;
}

jobject CreateProcessEntry32( JNIEnv * env, 
							 LPPROCESSENTRY32 lppe)
{
	
	jclass jcProcEntry32 =  env->FindClass("ProcessEntry32");
	if(jcProcEntry32 == NULL)
		return NULL;

	jmethodID jmProcEntry32 = env->GetMethodID(jcProcEntry32,
		"<init>", 
		"()V");

	if(jmProcEntry32 == NULL)
		return NULL;

  	jobject joProcEntry32 = env->NewObject(
		jcProcEntry32,
		jmProcEntry32,
		"");

	if(joProcEntry32 == NULL)
		return NULL;

	if (!SetDWORDField(env, lppe->cntUsage, 
		joProcEntry32, "cntUsage"))
		return NULL;

	if (!SetDWORDField(env, lppe->th32ProcessID, 
		joProcEntry32, "th32ProcessID"))
		return NULL;

	if (!SetDWORDField(env, lppe->th32DefaultHeapID, 
		joProcEntry32, "th32DefaultHeapID"))
		return NULL;

	if (!SetDWORDField(env, lppe->cntThreads, 
		joProcEntry32, "cntThreads"))
		return NULL;

	if (!SetDWORDField(env, lppe->th32ModuleID, 
		joProcEntry32, "th32ModuleID"))
		return NULL;

	if (!SetDWORDField(env, lppe->th32ParentProcessID, 
		joProcEntry32, "th32ParentProcessID"))
		return NULL;

	if (!SetDWORDField(env, lppe->pcPriClassBase, 
		joProcEntry32, "pcPriClassBase"))
		return NULL;

	if (!SetDWORDField(env, lppe->dwFlags, 
		joProcEntry32, "dwFlags"))
		return NULL;

	if (!SetStringField(env, lppe->szExeFile, 
		joProcEntry32, "szExeFile"))
		return NULL;

	return joProcEntry32;
}


BOOL SetDWORDField( JNIEnv * env, 
				   DWORD field, 
				   jobject procEntry32,
				   char *szField)
{
	jfieldID jfield =  env->GetFieldID( 
		env->GetObjectClass(procEntry32),
		szField, 
		"I");
	
	if ( !IsValidField(	jfield, szField) )
		return FALSE;
	
	env->SetIntField(procEntry32, 
		jfield, 
		field);

	return TRUE;
}

BOOL SetStringField( JNIEnv * env, 
					char *szString, 
					jobject procEntry32, 
					char *szField)
{
	jfieldID jfield =  env->GetFieldID( 
		env->GetObjectClass(procEntry32),
		szField, 
		"Ljava/lang/String;");

	if ( !IsValidField(	jfield, szField) )
		return FALSE;

	jstring  jstringObject = env->NewStringUTF(	
		szString,
		strlen(szString));

	env->SetObjectField(
		procEntry32, 
		jfield, 
		jstringObject);
	return TRUE;
}

BOOL IsValidField(jfieldID jfield, 
				  char *szField)
{
	if(jfield == NULL)
	{
		OutputDebugString ("Process");
		OutputDebugString (szField);
		OutputDebugString ("\n");
		return FALSE;
	}
	
	return TRUE;
}



