

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 18 "semaphor.d"
#include <string.h> 

#define	CLASS	Semaphore_c
#define	ivType	Semaphore_iv_t

#include "generics.h"

object	Semaphore_c;


#line 28 "semaphor.c"
typedef struct  _Semaphore_iv_t  {
	object iObj;
	char * iName;
	int iCount;
	int iMaximum;
	object iWaiting_threads;
	struct _Semaphore_iv_t * iNext;
}	Semaphore_iv_t;


#line 39 "semaphor.c"
typedef struct  _Semaphore_cv_t  {
	struct _Semaphore_iv_t * cMsl;
}	Semaphore_cv_t;

static	Semaphore_cv_t	*Semaphore_cv;



#line 34 "semaphor.d"
cmeth objrtn New(object self, char *name, int cnt, int mx)
{ 
	object obj = oSuper(Semaphore_c, gNew, self)(self); 
	ivType *iv = ivPtr(obj); 

	iv->iObj = obj; 
	if (name) { 
		iv->iName = Tnalloc(char, strlen(name)+1); 
		strcpy(iv->iName, name); 
	} 
	iv->iCount = cnt; 
	iv->iMaximum = mx; 
	iv->iNext = Semaphore_cv->cMsl; 
	Semaphore_cv->cMsl = iv; 
	return obj; 
} 

cmeth objrtn Semaphore_cm_gNew(object self)
{ 
	return New(self, NULL, 1, 1); 
} 

imeth int Semaphore_im_gWaitFor(object self)
{ Semaphore_iv_t *iv = GetIVs(Semaphore, self);
	object ct; 

	INHIBIT_THREADER; 
	if (!(ct = gFindStr(Thread, NULL))) { 
		ENABLE_THREADER; 
		return 0; 
	} 
	if (iv->iCount) { 
		iv->iCount--; 
		ENABLE_THREADER; 
		return 0; 
	} 
	gWaitSemaphore(ct, self); 

	if (!iv->iWaiting_threads) 
		iv->iWaiting_threads = gNew(LinkObject); 
	gAddLast(iv->iWaiting_threads, ct); 
	ENABLE_THREADER; 

	__dynace_yield(); 
	return 0; 
} 

imeth objrtn Release(object self, int cnt)
{ Semaphore_iv_t *iv = GetIVs(Semaphore, self);
	object thread; 

	iv->iCount += cnt; 
	if (iv->iCount > iv->iMaximum) 
		iv->iCount = iv->iMaximum; 
	INHIBIT_THREADER; 
	while (iv->iCount && iv->iWaiting_threads && (thread = gFirst(iv->iWaiting_threads))) { 
		gDisposeFirst(iv->iWaiting_threads); 
		gReleaseSemaphore(thread); 
		iv->iCount--; 
	} 
	ENABLE_THREADER; 
	return self; 
} 

imeth objrtn Semaphore_im_gDispose(object self)
{ Semaphore_iv_t *iv = GetIVs(Semaphore, self);
	ivType *t, *p; 

	INHIBIT_THREADER; 
	while (iv->iWaiting_threads && gFirst(iv->iWaiting_threads)) 
		Release(self, iv->iMaximum); 
	if (iv->iWaiting_threads) 
		gDispose(iv->iWaiting_threads); 
	if (iv->iName) 
		free(iv->iName); 
	for (p=NULL, t=Semaphore_cv->cMsl ; t ; p=t, t=t->iNext) 
		if (t == iv) { 
		if (p) 
			p->iNext = t->iNext; 
		else 
			Semaphore_cv->cMsl = t->iNext; 
		break; 
	} 
	oSuper(Semaphore_c, gDispose, self)(self); 
	ENABLE_THREADER; 
	return NULL; 
} 

imeth objrtn Semaphore_im_gGCDispose(object self)
{ Semaphore_iv_t *iv = GetIVs(Semaphore, self);
	ivType *t, *p; 

	INHIBIT_THREADER; 
	if (iv->iWaiting_threads && gFirst(iv->iWaiting_threads)) { 
		ENABLE_THREADER; 
		return NULL; 
	} 
	if (iv->iName) 
		free(iv->iName); 
	for (p=NULL, t=Semaphore_cv->cMsl ; t ; p=t, t=t->iNext) 
		if (t == iv) { 
		if (p) 
			p->iNext = t->iNext; 
		else 
			Semaphore_cv->cMsl = t->iNext; 
		break; 
	} 
	oSuper(Semaphore_c, gDispose, self)(self); 
	ENABLE_THREADER; 
	return NULL; 
} 

cmeth objrtn Semaphore_cm_gFindStr(object self, char *name)
{ 
	ivType *iv; 

	USE(self); 
	if (!name) 
		return NULL; 
	for (iv=Semaphore_cv->cMsl ; iv ; iv=iv->iNext) 
		if (iv->iName && !strcmp(iv->iName, name)) 
		return iv->iObj; 
	return NULL; 
} 

imeth int Semaphore_im_gCount(object self)
{ Semaphore_iv_t *iv = GetIVs(Semaphore, self);
	return iv->iCount; 
} 

imeth char * Semaphore_im_gName(object self)
{ Semaphore_iv_t *iv = GetIVs(Semaphore, self);
	return iv->iName; 
} 



imeth objrtn Semaphore_im_gRemoveWaits(object self, object thrd)
{ Semaphore_iv_t *iv = GetIVs(Semaphore, self);
	object linkSequence, linkValue, thread; 

	if (!iv->iWaiting_threads) 
		return self; 
	INHIBIT_THREADER; 
	linkSequence = gSequenceLinks(iv->iWaiting_threads); 
	while (linkValue = gNext(linkSequence)) { 
		thread = gValue(linkValue); 
		if (thread == thrd) { 
			gDispose(linkValue); 
			break; 
		} 
	} 
	if (linkValue) 
		gDispose(linkSequence); 
	ENABLE_THREADER; 
	return self; 
} 

imeth objrtn Semaphore_im_gCopy(object self)
{ 
	return gShouldNotImplement(self, "Copy/DeepCopy"); 
} 


#line 213 "semaphor.c"

objrtn	Semaphore_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (Semaphore_c) {
		LEAVECRITICALSECTION(cs);
		return Semaphore_c;
	}
	INHIBIT_THREADER;
	Semaphore_c = gNewClass(Class, "Semaphore", sizeof(Semaphore_iv_t), sizeof(Semaphore_cv_t), END);
	cMethodFor(Semaphore, gNewSemaphore, New);
	cMethodFor(Semaphore, gFindStr, Semaphore_cm_gFindStr);
	cMethodFor(Semaphore, gNew, Semaphore_cm_gNew);
	iMethodFor(Semaphore, gCount, Semaphore_im_gCount);
	iMethodFor(Semaphore, gRemoveWaits, Semaphore_im_gRemoveWaits);
	iMethodFor(Semaphore, gRelease, Release);
	iMethodFor(Semaphore, gDispose, Semaphore_im_gDispose);
	iMethodFor(Semaphore, gName, Semaphore_im_gName);
	iMethodFor(Semaphore, gGCDispose, Semaphore_im_gGCDispose);
	iMethodFor(Semaphore, gCopy, Semaphore_im_gCopy);
	iMethodFor(Semaphore, gDeepDispose, Semaphore_im_gDispose);
	iMethodFor(Semaphore, gDeepCopy, Semaphore_im_gCopy);
	iMethodFor(Semaphore, gWaitFor, Semaphore_im_gWaitFor);

	Semaphore_cv = GetCVs(Semaphore);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return Semaphore_c;
}



