



/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

#ifndef	_DYNL_H
#define	_DYNL_H

/*  What kind of machine?  */

#ifdef	_MSC_VER
#if	_MSC_VER >= 900  &&  defined(_M_IX86)
#define	MSC32
#else
#define MSC16
#endif
#endif

#ifdef	__WATCOMC__
#ifdef	M_I86
#define	WATCOM16
#else
#define WATCOM32
#endif
#endif


#if	defined(__TURBOC__)  ||  defined(__BORLANDC__)
#ifdef	__MSDOS__
#define BC16
#else
#define BC32
#endif
#endif

#ifdef	__SC__		/*  Symantec C  */
#ifdef	_WIN32
#define	SYMC32
#else
#define	SYMC16
#endif
#endif


#include <stdio.h>
/*#include <malloc.h>*/
#include <stdlib.h>
#include <setjmp.h>
#include <stdarg.h>
#ifdef	__WATCOMC__
#include <string.h>
#endif

#ifdef	BOEHM_GC
#include "gc.h"
#define	malloc(x)	GC_malloc_ignore_off_page(x)
#define	free(x)
#define	calloc(n,s)	GC_malloc_ignore_off_page((n)*(s))
#define	realloc(p,s)	GC_realloc(p,s)
#endif


#ifdef	RTKERNEL
#ifndef	NATIVE_THREADS
#define	NATIVE_THREADS
#endif
#include "dynrtk.h"
#endif

#ifdef	NATIVE_THREADS
typedef	CRITICAL_SECTION	CRITICALSECTION;
#define	INITIALIZECRITICALSECTION(cs)	InitializeCriticalSection(&cs)
#define	DELETECRITICALSECTION(cs)	DeleteCriticalSection(&cs)
#define	ENTERCRITICALSECTION(cs)	EnterCriticalSection(&cs)
#define	LEAVECRITICALSECTION(cs)	LeaveCriticalSection(&cs)
#else
typedef	int	CRITICALSECTION;
#define	INITIALIZECRITICALSECTION(cs)	USE(cs)
#define	DELETECRITICALSECTION(cs)	USE(cs)
#define	ENTERCRITICALSECTION(cs)	USE(cs)
#define	LEAVECRITICALSECTION(cs)	USE(cs)
#endif

#define	NULLOBJ	((object)0)

#if defined( _WINDOWS)  ||  defined(MSC32)  ||  defined(MSC16)
#if defined(MSC32)  &&  !defined(WIN32)
#define	WIN32
#endif
#include <windows.h>
#include <windowsx.h>
#include <sql.h>
#ifndef	WIN32
#include <ole2.h>
#include <dispatch.h>
//  redefine the following without the __export so I can use static functions
#undef	STDMETHODIMP
#undef	STDMETHODIMP_
#define	STDMETHODIMP		HRESULT FAR CDECL
#define	STDMETHODIMP_(t)	t FAR CDECL
#endif
#undef	NULL
#define NULL	((void *)0)
#include "dynwin.h"
#endif

#include "findfile.h"

#ifdef	__cplusplus
extern "C"  {
#endif

/*  objects must be declared volatile because if the variable is kept in a
    register, it may not be garbage collected  */

#if	defined(MSC32)  ||  defined(BC32)  ||  (defined(unix) && defined(i386))
typedef	struct	_Object_iv_t	 *object;
#else
typedef	struct	_Object_iv_t	 * volatile object;
#endif

/*  objrtn is used to signify functions which return objects.  It is necessary
    because some compilers (GNU) don't like function return types declared as
    volatile.   */

typedef	struct	_Object_iv_t	 *objrtn;

typedef	objrtn	(*ofun)();
typedef	int	(*ifun)();

void	InitDynace(void *);
void	InitKernel(void *, int);
ofun	_FindMethod(object, object);
ofun	_FindMethod2(object, object, int);
objrtn	_jumpToMethod(ofun f);
void	*GetIVptr(object, object);
int	IsObj(object);
void	InitGenerics(void);
void	_IC_exec(object *);


#define TRACE_DONT_CARE		0
#define TRACE_OFF		1
#define TRACE_ON		2
#define TRACE_ALL		3

#define	_cat2_(a, b)	a##b
#define _cat_(a, b)	_cat2_(a, b)

#define Generic(x)	_cat_(x, _g)


#define InitClass(c)	c##_initialize()

#define ivPtr(x)	((ivType *) GetIVptr((x), CLASS))
#define ivsPtr		ivPtr(self)
#define accessIVs	ivType *iv = ivsPtr
#define accessIVsOf(x)	ivType *iv = ivPtr(x)

#define	GetIVs(c,x)	((c##_iv_t *) GetIVptr((x), c##_c))
#define	GetCVs(c)	((c##_cv_t *) GetIVptr(c##_c, ClassOf(c##_c)))

#define ivMethodFor(c,g,m,f)	\
	gNewMethod(Method_c, #m, c##_c, Generic(g), (ofun) m, (ofun) f)
#define cvMethodFor(c,g,m,f)	\
	gNewMethod(Method_c, #m, ClassOf(c##_c), Generic(g), (ofun) m, (ofun) f)

#define iMethodFor(c,g,m)	\
	gNewMethod(Method_c, #m, c##_c, Generic(g), (ofun) m, (ofun) m)
#define cMethodFor(c,g,m)	\
	gNewMethod(Method_c, #m, ClassOf(c##_c), Generic(g), (ofun) m, (ofun) m)

#define ClassOf(x)	(object) *((object *) (x))

#define imeth		static
#define cmeth		static
#define ivmeth		static
#define cvmeth		static
#define END		(object) 0

#define IsInstanceOf(i,c)	(ClassOf(i) == (c))
#define IsaMetaClass(x)		(ClassOf(x) == MetaClass_c)
#define IsaClass(x)		(IsaMetaClass(ClassOf(x)) || IsaMetaClass(x))

#define EQ(a,b)		((a) == (b))
#define NEQ(a,b)	((a) != (b))


#define tFindMethod(t, c, g, l)  (*(t (*)()) _FindMethod2(c, g, l))


/* get instance method from a class object */
#define imcPointer(c,g)  (g##_t) gFindMethod(c, Generic(g), 1)

/* get class method from a class object */
#define cmcPointer(c,g)  (g##_t) gFindMethod(ClassOf(c), Generic(g), 1)

/* get instance method from an instance object */
#define imiPointer(i,g)  (g##_t) gFindMethod(ClassOf(i), Generic(g), 1)

/* get class method from an instance object */
#define cmiPointer(i,g)  (g##_t) gFindMethod(ClassOf(ClassOf(i)), Generic(g), 1)

#define iSuper(c,g)	(*(g##_t)_FindMethod2(c, Generic(g), 2))
#define cSuper(c,g)	(*(g##_t)_FindMethod2(ClassOf(c), Generic(g), 2))
#define typedSuper(t,g)	(*tFindMethod(t, ClassOf(self), Generic(g), 2))
#define typedGeneric(t,g) 	(*(t (*)()) g)

#if 0
#define oSuper(c, g, x)	\
	((ClassOf(ClassOf(x)) == MetaClass_c) ? cSuper(c, g) : iSuper(c, g))
#else
#define oSuper(c,g,x)	(*(g##_t)_FindMethod2((ClassOf(ClassOf(x)) == MetaClass_c) ? ClassOf(c) : c, Generic(g), 2))
#endif
	
#define RespondsTo(i,g)	(gFindMethod(ClassOf(i), Generic(g), 1) != NULL)

#define RegisterVariable(v)	gRegisterMemory(Dynace_c, (void *)&v, (long) sizeof(object))

	
extern	int	_CheckObjects_;
extern	object	_LastGeneric_;		/*  last generic called  */
extern	CRITICALSECTION  _CI_CS_;	/*  used during class initialization  */


#define GetArg(type)	va_arg(_rest_, type)

#define ChkArg(obj, argn)						\
	if (_CheckObjects_  &&  !IsObj(obj))				\
		gInvalidObject(_LastGeneric_, argn, self)

#define ChkArgTyp(obj, argn, argType)					\
	if (_CheckObjects_)  {						\
		if (!IsObj(obj))					\
			gInvalidObject(_LastGeneric_, argn, self);	\
		if (argType)  {						\
			object	lg = _LastGeneric_;			\
			if (!gIsKindOf(obj, argType))			\
				gInvalidType(lg, argn, self, argType, obj); \
			_LastGeneric_ = lg;				\
		}							\
	}

#define ChkArgNul(obj, argn)           if (obj)  ChkArg(obj, argn)

#define ChkArgTypNul(obj, argn, argType) 	\
	if (obj)  ChkArgTyp(obj, argn, argType)


/*  Thread stuff  */


/*  thread states   */

#define NEW_THREAD		0
#define	RUNNING_THREAD		1
#define HOLD_THREAD		2
#define DONE_THREAD		3
#define EXPUNGE_THREAD		4
#define WAITING_FOR_THREAD	5
#define WAITING_FOR_SEMAPHORE	6

#define DEFAULT_PRIORITY	100

extern	int	_tick_count;
extern	int	_no_context_switch;
extern	jmp_buf	_t_start;

extern	void	(*__dynace_yield)(void);
extern	void	_start_threader(char *stkpos), _start_thread(void);

#define INHIBIT_THREADER	_no_context_switch++
#define ENABLE_THREADER		if (_no_context_switch) _no_context_switch--

#if 0  /*  Debugging or to disable Threads  */
#define YIELD	
#else
#define YIELD	if (!_tick_count  &&  !_no_context_switch)  (*__dynace_yield)()
#endif

#define StartThreader(x)		\
	_start_threader((char *) &x);	\
	if (setjmp(_t_start))		\
		_start_thread()


/*  End of thread specific stuff  */

#ifndef	MSC32
#define IGTYPE	static
#else
#define IGTYPE	static	__declspec(naked) 
#endif

#if	!defined(MSC32)  &&  !defined(__alpha)
#define GenericBody(g)   _jumpToMethod( _FindMethod(self, Generic(g)) )
#endif

#ifdef	__alpha
#define GenericBody(g)  				\
	va_list args; va_start(args, self);             \
	_jumpToMethod( _FindMethod(self, Generic(g)) )
#endif

#ifdef	MSC32
#define GenericBody(g)					\
	_asm {	push	DWORD PTR Generic(g) }		\
	_asm {	push	DWORD PTR [esp+8] }		\
	_asm {	call	_FindMethod	 }		\
	_asm {	add	esp, 8	 }			\
	_asm {	jmp	eax }
#endif



#if 0
#ifndef	__alpha
#define defGeneric(t, g)   					\
	object	Generic(g) = (object) 0;			\
	static	t	_##g(object i, ...)			\
        {							\
		_jumpToMethod( _FindMethod(i, Generic(g)) ); 	\
	}							\
        t	(*g)(object i, ...) = _##g;
#else
#define defGeneric(t, g)                                        \
        object  Generic(g) = (object) 0;                        \
        static  t       _##g(object i, ...)                     \
        {                                                       \
                va_list args; va_start(args, i);                \
                _jumpToMethod( _FindMethod(i, Generic(g)) );    \
        }                                                       \
        t       (*g)(object i, ...) = _##g;
#endif
#endif /* 0 */

#define externGeneric(t, g)					\
	extern	object	Generic(g);				\
	extern	t	(*g)(object i, ...);



#define InitGeneric(x)	Generic(x) = gNewWithStr(GenericFunction_c, #x)


#if 0 /* DPP_FASTWIDE  */

typedef	struct  {
	object	fill1;
	unsigned short fill2, fill3;
}	*OHead;

#define	ClassID(c)		*(int *)((OHead)(c) + 1)
#define	MethCache(g)		(*(ofun **)((OHead)Generic(g) + 1))
#define	MethodPointer(g, obj)	MethCache(g)[ClassID(ClassOf(obj))]


#if	DPP_STRATEGY > 2
inline	void	gInvalidObject(object self, int argn, object arg1);
#endif

#if	DPP_STRATEGY <= 2
void	(*gInvalidObject)(object self, int argn, object arg1);
#endif


#define FW_GENERIC(g) 						\
	if (_CheckObjects_)  {					\
		if (!IsObj(self))				\
			gInvalidObject(Generic(g), 1, self);	\
		_LastGeneric_ = Generic(g);			\
	}							\
	YIELD;							\
	if (!(_meth_ = MethodPointer(g, self)))			\
		MethodPointer(g, self) = _meth_ = _FindMethod(self, Generic(g))
	

#endif

#if	DPP_FASTWIDE

typedef	struct  {
	objrtn	fill1;
	unsigned short fill2, fill3;
	int	id;
}	*CHead;

typedef	struct  {
	objrtn	fill1;
	unsigned short fill2, fill3;
	ofun	*mc;
}	*GHead;

#define	MethodPointer(g, obj)   \
        ((GHead)Generic(g))->mc[((CHead)ClassOf(obj))->id]

#if	DPP_STRATEGY > 2
inline	void	gInvalidObject(object self, int argn, object arg1);
#endif

#if	DPP_STRATEGY <= 2
void	(*gInvalidObject)(object self, int argn, object arg1);
#endif

#ifndef	SMALL_FW

#define FW_GENERIC(g) 						\
	if (_CheckObjects_)  {					\
		if (!IsObj(self))				\
			gInvalidObject(Generic(g), 1, self);	\
		_LastGeneric_ = Generic(g);			\
	}							\
	YIELD;							\
	if (!(_meth_ = MethodPointer(g, self)))			\
		MethodPointer(g, self) = _meth_ = _FindMethod(self, Generic(g))

#else

#define FW_GENERIC(g) 						\
	if (!(_meth_ = MethodPointer(g, self)))			\
		MethodPointer(g, self) = _meth_ = _FindMethod(self, Generic(g))

#endif	

#endif



#ifndef  Talloc
extern	void	*Chkmem(void *, char *, int);
#define	 Talloc(t)   (t *) Chkmem(malloc(sizeof(t)), __FILE__, __LINE__)
#define	 Tcalloc(t)  (t *) Chkmem(calloc(1, sizeof(t)), __FILE__, __LINE__)
#define	 Tnalloc(t,n)   (t *) Chkmem(malloc((n) * sizeof(t)), __FILE__, __LINE__)
#define	 Tncalloc(t,n)  (t *) Chkmem(calloc((n), sizeof(t)), __FILE__, __LINE__)
#define  Tnrealloc(t,n,b) (t *) Chkmem(realloc((void*)(b), (n) * sizeof(t)), __FILE__, __LINE__)
#endif

#define	StackAlloc(c)	gStackAlloc(c, alloca(gInstanceSize(c)))

#if 0
#if defined(__TURBOC__)  /*  ||  defined(unix)  */
#include "generics.h"
#else
#include <generics.h>
#endif
#endif


/*  from the Stream class  */
extern	object	stdoutStream_o, stdinStream_o, stderrStream_o;
extern	object	traceStream_o;
#define stdoutStream	(stdoutStream_o ? stdoutStream_o : (File_initialize(), stdoutStream_o))
#define stdinStream	(stdinStream_o ? stdinStream_o : (File_initialize(), stdoutStream_o))
#define stderrStream	(stderrStream_o ? stderrStream_o : (File_initialize(), stdoutStream_o))
#define traceStream	(traceStream_o ? traceStream_o : (File_initialize(), stdoutStream_o))



/*  Used by Hash  */

#define BIG_INT		(sizeof(int) > 2 ? 320000001.0 : 32001.0)


#if !defined(unix) && !defined(vms) && !defined(__WATCOMC__) && _M_IX86 < 300 && !defined (__MWERKS__)
#define _HUGE	huge
#else
#define _HUGE
#endif

/* macro to make believe a variable is used to keep picky compilers happy  */
#define USE(x)		(void) x

#ifdef	__alpha
#define vPrintf		fix_vPrintf
#define vSprintf	fix_vSprintf
#endif

#ifdef	__WATCOMC__
#define	ASSIGN_VA_LIST(t,f)	memcpy(&t, &f, sizeof t)
#else
#define	ASSIGN_VA_LIST(t,f)	t = f
#endif

#if	DPP_STRATEGY == 1
#define	MAKE_REST(lst)		\
	va_list	_rest_;		\
	va_list _rest2_;	\
	va_start(_rest_, lst);	\
	ASSIGN_VA_LIST(_rest2_, _rest_)
#else
#define	MAKE_REST(lst)		\
	va_list	_rest2_; 	\
	ASSIGN_VA_LIST(_rest2_, _rest_)
#endif

#define	RESET_REST	ASSIGN_VA_LIST(_rest_, _rest2_)

#if	defined(__WATCOMC__)  &&  defined(__cplusplus)
#pragma warning 472 9
#endif

#ifdef	__cplusplus
}
#endif


#endif  /*  _DYNL_H  */


/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


