
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#include <string.h>
#include <math.h>
#include "memalloc.h"


defclass  StringAssociation : Association  {
	char	*iKey;
	iValue;
};

cmeth	gNewWithStrObj, <vNew> (char *key, value)
{
	int	len = key ? strlen(key) : 0;
	object	assoc;
	ivType	*iv;

	ChkArgNul(value, 3);
	assoc = gNew(super);
	iv = ivPtr(assoc);
	iKey = (char *) MA_malloc(len+1, &iKey);
	strcpy(iKey, key ? key : "");
	iValue = value;
	return assoc;
}

imeth	gDeepCopy()
{
	object	nobj;
	ivType	*iv2;

	nobj = gDeepCopy(super);
	iv2 = ivPtr(nobj);
	if (iKey)  {
		iv2->iKey = (char *) MA_malloc(strlen(iKey)+1, &iv2->iKey);
		strcpy(iv2->iKey, iKey);
	}
	if (iValue)
		iv2->iValue = gDeepCopy(iValue);
	return nobj;
}

imeth	gCopy()
{
	object	nobj;
	ivType	*iv2;

	nobj = gCopy(super);
	iv2 = ivPtr(nobj);
	if (iKey)  {
		iv2->iKey = (char *) MA_malloc(strlen(iKey)+1, &iv2->iKey);
		strcpy(iv2->iKey, iKey);
	}
	iv2->iValue = iValue;
	return nobj;
}

imeth	gValue()
{
	return iValue;
}

imeth	gChangeValue(value)
{
	object	ret;
	ChkArgNul(value, 2);
	ret = iValue;
	iValue = value;
	return ret;
}

imeth	char	*gStringKey()
{
	return iKey;
}

imeth	gChangeStringKey(char *key)
{
	int	len = key ? strlen(key) : 0;

	if (iKey)  {
		if (len > (int) strlen(iKey))
			iKey = (char *) MA_realloc(iKey, len+1);
	} else
		iKey = (char *) MA_malloc(len+1, &iKey);
	strcpy(iKey, key ? key : "");
	return self;
}

imeth	object	gDispose, gGCDispose ()
{
	if (iKey)
		MA_free(iKey);
	return gDispose(super);
}

imeth	object	gDeepDispose()
{
	if (iKey)
		MA_free(iKey);
	if (iValue)
		gDeepDispose(iValue);
	return gDeepDispose(super);
}

imeth	gStringRepValue()
{
	object	s, t;
	
	t = iValue ? gStringRepValue(iValue) : (object) NULL;
	s = vSprintf(String, "( \"%s\", ", iKey ? iKey : "(null)");
	vBuild(s, NULL, t ? (char *) t : "(null)", " )", NULL);
	if (t)
		gDispose(t);
	return s;
}

imeth	int	gHash()
{
	register char	 c = 'a';
	char	*s = iKey;
	double	t;
	register unsigned short	 k=0;  /* must be short	 */

	if (s)
		while (*s)
			k += *s++ ^ c++;
	t = .6125423371	* k;
	t = t < 0.0 ? -t : t;
	return (int) (BIG_INT * (t - floor(t)));
}

imeth	int	gCompare(arg)
{
	ChkArg(arg, 2);
	return strcmp(iKey?iKey:"", gStringKey(arg));
}




/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

