


/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */


#include "array1.h"


defclass  PointerArray : Array  {
 init:	init_class;
};


#define TYPE	void *


static	gIndex_t	_index;


cvmeth	vNew(unsigned rank, ...)
{
	static	gNewArray_t	cnew = NULL;
	MAKE_REST(rank);

	if (!cnew)
		cnew = cmcPointer(Array, gNewArray);
	return cnew(self, AT_PNTR, rank, _rest_);
}

ivmeth	void	*vPointerValue(...)
{
	MAKE_REST(self);
	return *((TYPE *) _index(self, _rest_));
}

ivmeth	vChangeValue(void *val, ...)
{
	MAKE_REST(val);
	*((TYPE *) _index(self, _rest_)) = val;
	return self;
}

static	void	init_class(void)
{
	_index = imcPointer(Array, gIndex);
}




/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */



