
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef	unix
#include <io.h>
#endif

#if	defined(sparc)  ||  defined(unix)
#include <unistd.h>
#define	tell(h)		lseek(h, 0L, SEEK_CUR)
#endif


defclass  LowFile : Stream  {
	iName;
	int	iHandle;
};

/* extern	long	lseek(), tell(); */

cmeth	gNew()
{
	return gShouldNotImplement(self, "gNew");
}

cmeth	gOpenLowFile, <vNew> (char *name, int oflag, int pmode)
{
	object	obj;
	ivType	*iv;
	int	handle;

	if (IsObj((object) name))
		name = gStringValue((object) name);
	handle = open(name, oflag, pmode);
	if (handle == -1)
		return NULL;
	obj = gNew(super);
	iv = ivPtr(obj);
	iName = gNewWithStr(String, name);
	iHandle = handle;
	return obj;
}


imeth	object	gDispose, gDeepDispose, gGCDispose ()
{
	close(iHandle);
	gDispose(iName);
	return gDispose(super);
}

imeth	int	gRead(char *buf, unsigned n)
{
	return read(iHandle, buf, n);
}

imeth	int	gWrite(char *buf, unsigned n)
{
	return write(iHandle, buf, n);
}

imeth	char	*gGets(char *buf, int sz)   /*  very slow - not for real use  */
{
	int	h = iHandle;
	int	i, r;
	char	c;

	if (sz <= 0)
		return NULL;
	if (sz-- == 1)  {
		*buf = '\0';
		return buf;
	}
	for (i=0 ; i < sz ; )  {
		r = read(h, &c, 1);
		if (!r  &&  !i  ||  r < 0)
			return NULL;
		if (!r)
			break;
		buf[i++] = c;
		if (c == '\n')
			break;
	}
	buf[i] = '\0';
	return buf;
}

imeth	long	gAdvance(long n)
{
	int	h = iHandle;
	long	p = tell(h);
	long	r = lseek(h, n, SEEK_CUR);
	return r >= 0L ? r-p : 0L;
}

imeth	long	gRetreat(long n)
{
	int	h = iHandle;
	long	p = tell(h);
	long	r = lseek(h, -n, SEEK_CUR);
	return r >= 0L ? p-r : 0L;
}

imeth	long	gSeek(long n)
{
	long	r = lseek(iHandle, n, SEEK_SET);
	return r;
}

imeth	long	gPosition()
{
	return tell(iHandle);
}

imeth	long	gLength()
{
	struct	stat	sb;
	int	r;

	r = fstat(iHandle, &sb);
	return r ? -1L : sb.st_size;
}

imeth	char	*gName()
{
	return gStringValue(iName);
}

imeth	int	gEndOfStream()
{
#ifndef unix	/*  eof() not available on unix  */
	return eof(iHandle);
#else
	gShouldNotImplement(self, "EndOfStream");
	iHandle = iHandle;   /*  keep the compiler happy  */
	return 0;  /*  never reached  */
#endif
}

imeth	int	gFileHandle()
{
	return iHandle;
}





/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

