
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


defclass  LookupKey : Association  {
	iKey;
};

cmeth	gNewWithObj, <vNew> (key)
{
	object	luk;
	ivType	*iv;

	ChkArgNul(key, 2);
	luk = gNew(super);
	iv = ivPtr(luk);
	iKey = key;
	return luk;
}

imeth	gDeepCopy()
{
	object	nobj;
	ivType	*niv;

	nobj = gDeepCopy(super);
	niv = ivPtr(nobj);
	if (niv->iKey)
		niv->iKey = gDeepCopy(iKey);
	return nobj;
}

imeth	gKey()
{
	return iKey;
}

imeth	gChangeKey(key)
{
	object	old;
	ChkArgNul(key, 2);
	old = iKey;
	iKey = key;
	return old;
}

imeth	object	gDeepDispose()
{
	if (iKey)
		gDeepDispose(iKey);
	return gDispose(super);
}

imeth	gStringRepValue()
{
	return iKey ? gStringRepValue(iKey) : gNew(String);
}

imeth	int	gHash()
{
	return iKey ? gHash(iKey) : 0;
}

imeth	int	gCompare(arg)
{
	ChkArgNul(arg, 2);
	if (!iKey  &&  !arg)
		return 0;
	if (!iKey)
		return -1;
	if (!arg)
		return 1;
	return gCompare(iKey, gKey(arg));
}




/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

