
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



defclass  LinkObject : LinkList;


#define FIRST	gNext
#define LAST	gPrevious

cvmeth	vMakeList(...)
{
	object	lst, obj;
	MAKE_REST(self);

	lst = gNew(self);
	while (obj = GetArg(object))
		gAddBefore(lst, gNewWithObj(LinkValue, obj));  //  same as gAddLast
	return lst;
}

ivmeth	vGetValues(...)
{
	object	*var, seq, obj;
	MAKE_REST(self);

	seq = gSequence(self);
	obj = gNext(seq);
	while (var = GetArg(object *)) {
		*var = obj;
		if (obj)
			obj = gNext(seq);
	}
	if (obj)
		gDispose(seq);
	return self;
}

imeth	gAddFirst(obj)
{
	object	lnk;

	ChkArgNul(obj, 2);
	lnk = gNewWithObj(LinkValue, obj);
/*	gAddFirst(super, lnk);  */
	gAddAfter(self, lnk);
	return self;
}

imeth	gFirst()
{
/*	object	lnk = gFirst(super);   */
	object	lnk = FIRST(self);
	return lnk ? gValue(lnk) : NULLOBJ;
}

imeth	gAddLast(obj)
{
	object	lnk;

	ChkArgNul(obj, 2);
	lnk = gNewWithObj(LinkValue, obj);
/*	gAddLast(super, lnk);  */
	gAddBefore(self, lnk);
	return self;
}

imeth	gLast()
{
/*	object	lnk = gLast(super);  */
	object	lnk = LAST(self);
	return lnk ? gValue(lnk) : NULLOBJ;
}

imeth	gSequence()
{
	return gNewWithObj(LinkObjectSequence, FIRST(self));
}

imeth	gSequenceLinks()
{
	return gNewWithObj(LinkSequence, FIRST(self));
}

imeth	gNth(int idx)
{
	object	r = gNth(super, idx);
	return r ? gValue(r) : NULLOBJ;
}





/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

