
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

 
#include <math.h>



defclass  DoubleFloat : Number  {
	double	iVal;
};



cmeth	gNewWithDouble, <vNew> (double val)
{
	object	obj = gNew(super);
	ivType	*iv = ivPtr(obj);
	iVal = val;
	return(obj);
}

imeth	gStringRepValue()
{
	return vSprintf(String, "%f", iVal);
}

imeth	char	gCharValue()
{
	return (char) iVal;
}

imeth	short	gShortValue()
{
	return (short) iVal;
}

imeth	unsigned short	gUnsignedShortValue()
{
	return (unsigned short) iVal;
}

imeth	long	gLongValue()
{
	return (long) iVal;
}

imeth	double	gDoubleValue()
{
	return (double) iVal;
}

imeth	void	*gPointerValue()
{
	return (void *) &iVal;
}

imeth	gChangeValue(val)
{
	ChkArg(val, 2);
	iVal = gDoubleValue(val);
	return self;
}

imeth	gChangeCharValue(int val)
{
	iVal = (double) val;
	return self;
}

imeth	gChangeShortValue(int val)
{
	iVal = (double) val;
	return self;
}

imeth	gChangeUShortValue(unsigned val)
{
	iVal = (double) val;
	return self;
}

imeth	gChangeLongValue(long val)
{
	iVal = (double) val;
	return self;
}

imeth	gChangeDoubleValue(double val)
{
	iVal = (double) val;
	return self;
}

imeth	gRound(int p)	/*  round n to p places	 */
{
	double	r;

	r = pow(10.0, (double) p);
	if (iVal < 0.0)
		iVal = -(floor(.5 + -iVal * r) / r);
	else
		iVal = floor(.5 + iVal * r) / r;
	return self;
}

imeth	gTruncate(int p)		/* truncate n to p places  */
{
	double	r;

	r = pow(10.0, (double) p);
	if (iVal < 0.0)
		iVal = -(floor(-iVal * r) / r);
	else
		iVal = floor(iVal * r) / r;
	return self;
}

imeth	int	gHash()
{
	double	t;

	t = .6125423371	* iVal;
	t = t < 0.0 ? -t : t;
	return (int) (BIG_INT * (t - floor(t)));
}

imeth	int	gCompare(obj)
{
	double	sv, ov;

	ChkArg(obj, 2);
	if (ClassOf(obj) != CLASS)
		return gCompare(super, obj);
	if ((sv=iVal) < (ov=ivPtr(obj)->iVal))
		return -1;
	else if (sv == ov)
		return 0;
	else
		return 1;
}


/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */
