
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#include <math.h>

defclass  Character : Number  {
	char	iVal;
};


cmeth	gNewWithChar, <vNew> (int val)
{
	object	obj = gNew(super);
	ivType	*iv = ivPtr(obj);
	iVal = (char) val;
	return(obj);
}

imeth	gStringRepValue()
{
	return vSprintf(String, "'%c'", iVal);
}

imeth	char	gCharValue()
{
	return (char) iVal;
}

imeth	short	gShortValue()
{
	return (short) iVal;
}

imeth	unsigned short	gUnsignedShortValue()
{
	return (unsigned short) iVal;
}

imeth	long	gLongValue()
{
	return (long) iVal;
}

imeth	double	gDoubleValue()
{
	return (double) iVal;
}

imeth	gChangeValue(val)
{
	ChkArg(val, 2);
	iVal = gCharValue(val);
	return self;
}

imeth	gChangeCharValue(int val)
{
	iVal = (char) val;
	return self;
}

imeth	gChangeShortValue(int val)
{
	iVal = (char) val;
	return self;
}

imeth	gChangeUShortValue(unsigned val)
{
	iVal = (char) val;
	return self;
}

imeth	gChangeLongValue(long val)
{
	iVal = (char) val;
	return self;
}

imeth	gChangeDoubleValue(double val)
{
	iVal = (char) val;
	return self;
}

imeth	void	*gPointerValue()
{
	return (void *) &iVal;
}

imeth	gFormatChar, <vFormat> ()
{
	char	b[2];

	b[0] = iVal;
	b[1] = '\0';
	return gNewWithStr(String, b);
}

imeth	int	gHash()
{
	double	t;

	t = .6125423371	* (unsigned) iVal;
	t = t < 0.0 ? -t : t;
	return (int) (BIG_INT * (t - floor(t)));
}

imeth	int	gCompare(obj)
{
	short	sv, ov;

	ChkArg(obj, 2);
	if (ClassOf(obj) != CLASS)
		return gCompare(super, obj);
	if ((sv=iVal) < (ov=ivPtr(obj)->iVal))
		return -1;
	else if (sv == ov)
		return 0;
	else
		return 1;
}


/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */
