/**************************[ SoftC Libraries ]****************************
** Copyright (c) 1994, 1997 SoftC, Ltd.
** All Rights Reserved.
**************************************************************************
**
**      This module contains compiler-specific macros & definitions.
**/

/************************[ compilation switches ]************************/
#ifndef __SCCOMP_DOT_H__

/****************************[ header files ]****************************/
/************************[ constant definitions ]************************/
#define __SCCOMP_DOT_H__

#if defined( __TURBOC__ ) || defined( __BORLANDC__ )
  #if !defined( __BORLANDC__ )
    #define SC_BORLAND __TURBOC__
  #else
    #define SC_BORLAND __BORLANDC__
  #endif
  #define ANSI_PROTOTYPES
  #define SC_UNUSED_PARAMETER( a ) (void) a
  #define SC_FASTCALL _fastcall
  #define SC_NEAR _near
  #if defined( __DPMI16__ )
    #define SC_DPMI16
    #define SC_X16
    #define SC_FAR _far
  #elif defined( __DPMI32__ )
    #define SC_DPMI32
    #define SC_X32
    #define SC_FAR
  #elif defined( _Windows )
    #if defined( __DLL__ )
      #define SC_BUILDING_DLL
    #endif
    #if defined( __WIN32__ ) && !defined( __DPMI32__ )
      #define SC_WIN32
      #define SC_FAR
    #else
      #define SC_FAR _far
      #define SC_WIN16
    #endif
  #elif defined( __OS2__ )
         #define SC_OS2
         #define SC_FAR _far16
  #else
         #define SC_FAR _far
  #endif
  #ifdef __SMALL__
         #define SC_SMALL
  #endif
  #ifdef __MEDIUM__
         #define SC_MEDIUM
  #endif
  #ifdef __COMPACT__
         #define SC_COMPACT
  #endif
  #ifdef __LARGE__
         #define SC_LARGE
  #endif
  #ifdef __HUGE__
         #define SC_HUGE
  #endif

#elif defined( __WATCOMC__ )
  #define SC_WATCOM
  #define ANSI_PROTOTYPES
  #define SC_UNUSED_PARAMETER( a ) (void) a
  #define SC_FASTCALL
  #define SC_NEAR _near
  #define SC_FAR _far
  #if defined( __WINDOWS__ )
    #define SC_WIN16
  #endif
  #if defined( __NT__ )
    #define SC_WIN32
    #ifdef SC_WIN16
      #undef SC_WIN16
    #endif
  #endif
  #if defined( __SW_ZU )
    #define SC_BUILDING_DLL
  #endif
  #if defined( __OS2__ )
    #define SC_OS2
  #endif
  #if defined( __QNX__ )
    #define SC_UNIX
  #endif
  #ifdef M_I86SM
    #define SC_SMALL
  #endif
  #ifdef M_I86MM
    #define SC_MEDIUM
  #endif
  #ifdef M_I86CM
    #define SC_COMPACT
  #endif
  #ifdef M_I86LM
    #define SC_LARGE
  #endif

#elif defined( __SC__ )
  #define SC_SYMANTEC __SC__
  #define ANSI_PROTOTYPES
  #define SC_UNUSED_PARAMETER( a ) (void) a
  #define SC_FASTCALL _fastcall
  #define SC_NEAR _near
  #if defined( __O2__ )
    #define SC_OS2
    #define SC_FAR _far
  #elif defined( __NT__ )
    #ifdef _WINDLL
      #define SC_BUILDING_DLL
    #endif
    #define SC_WIN32
    #define SC_FAR
  #elif defined( _WINDOWS )
    #ifdef _WINDLL
      #define SC_BUILDING_DLL
    #endif
    #define SC_WIN16
    #define SC_FAR _far
  #elif defined( MSDOS )
    #define SC_PCDOS
    #define SC_FAR _far
  #endif
  #ifdef __SMALL__
    #define SC_SMALL
  #endif
  #ifdef __MEDIUM__
    #define SC_MEDIUM
  #endif
  #ifdef __COMPACT__
    #define SC_COMPACT
  #endif
  #ifdef __LARGE__
    #define SC_LARGE
  #endif

#elif defined( _MSC_VER )
  #define SC_MICROSOFT
  #define ANSI_PROTOTYPES
  #define SC_FASTCALL
  #if _MSC_VER <= 800
    #define SC_UNUSED_PARAMETER( a )
  #else
    #define SC_UNUSED_PARAMETER( a ) (void)(a)
  #endif
  #ifdef _WIN32
    #define SC_NEAR
    #define SC_FAR
    #define SC_WIN32
    #ifdef _DLL
      #define SC_BUILDING_DLL
    #endif
  #else
    #define SC_NEAR _near
    #define SC_FAR _far
    #if defined( _WINDOWS )
        #define SC_WIN16
        #if defined( _WINDLL )
          #define SC_BUILDING_DLL
        #endif
    #elif defined( MS_DOS )
        #define SC_PCDOS
    #endif
    #if ( _MSC_VER >= 800 )
          #pragma warning( disable : 4699 )
    #else
          #if defined( M_I86HM )
            #define SC_HUGE_MODEL
      #endif
    #endif
    #ifdef M_I86SM
        #define SC_SMALL
    #endif
    #ifdef M_I86MM
        #define SC_MEDIUM
    #endif
    #ifdef M_I86CM
          #define SC_COMPACT
    #endif
    #ifdef M_I86LM
        #define SC_LARGE
    #endif
    #ifdef M_I86HM
        #define SC_HUGE
    #endif
  #endif


#elif defined(__IBMC__) || defined(__IBMCPP__)
  #define SC_IBM
  #define ANSI_PROTOTYPES
  #define SC_FAR
  #define SC_UNUSED_PARAMETER( a )   (a = a)
  #define SC_FASTCALL
  #define SC_NEAR _near
  #define SC_OS2

#endif

/*
 *  __ERR_FLAG__ is used to flag unknown errors. The value defined
 *  must be a negative number so that it can be processed properly by the
 *  error handlers. The value 0xC000 should be used for compilers that
 *  define an integer as two bytes long. 0xC0000000 should be used for four
 *  byte integers.
 */

/*
 *  Little-Endian machines store data with the Most Significant Byte in
 *  the highest address byte (Intel 80x86, DEC VAX, Motorola 6502).
 *    define __LITTLE_ENDIAN__.
 *
 *  Big-Endian machines store data with the Most Significant Byte in the
 *  lowest address byte (Motorola 680x0, Sun SPARC).
 *    define __BIG_ENDIAN__.
 */

/*
 *  Enable checking for pre-existing errors.  With this definition enabled,
 *  if an error exists upon entry to a function, the function will immediately
 *  exit.
 */
/*#define __ERR_HALT__*/


/*
 *  Enable checking for NULL parameters.  With this definition enabled, each
 *  function will check for NULL parameters.  Some speed improvement can be
 *  achieved by disabling the NULL parameter check.
 */
#define __NULL_CHK__


/*
 *  Enable SoftC's extended file handling (PCDOS ONLY). Normally, DOS allows
 *  20 open files per program. You can change this by modifying your C
 *  startup code (supplied with your compiler) or by enabling SoftC's
 *  extended file handling code. SoftC's implementation will NOT allow your
 *  normal C file I/O routines to use more than 20 files.
 *
 *  #define __DOS_EXT__
 */


/*
 *  __ALIGNED__ is used to enable code which will use "memcpy" to transfer
 *  longs and shorts to/from files.  Some processors complain when longs are
 *  not on 4 byte boundaries and shorts are not on 2 byte boundaries. Index
 *  data will not always be found on these boundaries (due to key length).
 *  This flag is normally not needed for INTEL processors.
 */
/*#define __ALIGNED__*/


/*
 *  strcmpi is not defined in ANSI C but may be in your compiler.  If you do
 *  not have the strcmpi function comment out the define statement.  The module
 *  STRING.C contains a "strcmpi" function.
 */
#define __STRCMPI_DEF__


/*
 *  memmove is defined by ANSI, but many older UNIX compilers do not support
 *  it. Comment out the define statement if you do not have a memmove
 *  function.  The module MEMMOVE.C contains a "memmove" function.
 */
#define __MEMMOVE_DEF__

/* set default operating system */
#ifndef SC_ANSI
  #ifndef SC_PORT
    #ifndef SC_WINDOWS
      #ifndef SC_UNIX
	#ifndef SC_OS2
          #ifndef SC_PCDOS
            #if defined(SC_WIN16) || defined(SC_WIN32)
	      #define SC_WINDOWS
	    #elif defined(__DYNEX_V32__) || defined(__SCO_XS5__) || defined(__ATT_S5R4__) || defined(__SPARC__) || defined(__ULTRIX__) || defined(__QNX__)
	      #define SC_UNIX
	    #elif defined( __STDC__ ) && !defined( SC_WATCOM )
	      #define SC_ANSI
	    #else
	      #define SC_PCDOS
	    #endif
	  #endif
	#endif
      #endif
    #endif
  #endif
#endif

/* Portability definitions and includes */
#if defined( SC_PORT )
  #include <io.h>
  #include <errno.h>
  #include <fcntl.h>
  #include <sys/stat.h>
  #include <sys/locking.h>
  #define __ERR_FLAG__ 0xC000
  #define __MAX_FILES__ 20
  #ifndef __BIG_ENDIAN__
    #define __LITTLE_ENDIAN__
  #endif
  #define CONST const
  #undef SC_PCDOS
  #undef SC_UNIX
  #undef SC_WINDOWS
  #undef SC_OS2
  #undef SC_WIN16
  #undef SC_WIN32
#endif

/* ANSI definitions and includes */
#if defined( SC_ANSI )
  #include <errno.h>
  #include <stdio.h>
  #define __ERR_FLAG__ 0xC000
  #define __MAX_FILES__ 20
  #ifndef __BIG_ENDIAN__
    #define __LITTLE_ENDIAN__
  #endif
  #undef __STRCMPI_DEF__
  #define CONST const
  #if defined( SC_BORLAND )
    #define __SLEEP__
  #endif
  #undef SC_PCDOS
  #undef SC_UNIX
  #undef SC_WINDOWS
  #undef SC_OS2
  #undef SC_WIN16
  #undef SC_WIN32
#endif

/* DOS definitions and includes */
#if defined( SC_PCDOS )
  #include <share.h>
  #include <fcntl.h>
  #include <sys/stat.h>
  #include <errno.h>
  #include <io.h>
  #include <stdlib.h>
  #include <dos.h>
  #include <time.h>
  #define __ERR_FLAG__ 0xC000
  #define __MAX_FILES__ 40
  #ifndef __BIG_ENDIAN__
    #define __LITTLE_ENDIAN__
  #endif
  #define __DOS_EXT__
  #define CONST const
  #ifdef SC_BORLAND
    #include <values.h>
  #endif
  #ifdef SC_WATCOM
    #include <direct.h>
  #endif
#endif

/* Windows definitions and includes */
#if defined( SC_WINDOWS )
  #include <errno.h>
  #include <io.h>
  #include <windows.h>
  #include <dos.h>
  #include <stdlib.h>
  #ifdef SC_WIN16
    #define __ERR_FLAG__ 0xC000
  #else
    #define __ERR_FLAG__ 0xC0000000
  #endif
  #define __MAX_FILES__ 20
  #define __LITTLE_ENDIAN__
  #define CONST const
  #define __USE_FAR_HEAP__
  #if defined( SC_BUILDING_DLL ) && !defined( _LDATA )
    #define _LDATA 200
  #endif
  #if defined( SC_BORLAND ) && !defined( SC_WIN32 )
    #include <values.h>
  #endif
  #ifdef SC_WATCOM
    #include <sys/locking.h>
  #endif
#endif

/* OS/2 definitions and includes */
#if defined( SC_OS2 )
  #undef SC_FASTCALL
  #define SC_FASTCALL
  #undef SC_NEAR
  #define SC_NEAR

  #define INCL_DOS
  #define INCL_ERRORS
  #define __ERR_FLAG__ 0xC0000000
  #define __MAX_FILES__ 20
  #define __LITTLE_ENDIAN__
  #define CONST const
  #include <os2.h>
  #include <io.h>
  #include <fcntl.h>
  #include <sys\stat.h>
  #include <share.h>
  #include <sys\locking.h>
  #include <errno.h>
  #ifdef SC_BORLAND
    #include <dir.h>
    #include <dos.h>
  #endif
  #ifdef SC_WATCOM
    #include <stdlib.h>
    #include <dos.h>
    #include <direct.h>
    #include <bsedos.h>
  #endif
#endif

/* UNIX definitions and includes */
#if defined( SC_UNIX )
  #define __ERR_FLAG__ 0xC0000000
  #define __MAX_FILES__ 60
  #define __LITTLE_ENDIAN__
  #define CONST const
  #include <errno.h>
  #include <fcntl.h>
  #include <sys/types.h>
  #include <sys/stat.h>
  #include <time.h>
  #include <memory.h>
  #include <unistd.h>
  #ifdef __ATT_S5R4__
    #undef __STRUPR_DEF__
    #define _MAX_DIR 256
    #define _MAX_FNAME 256
    #define _MAX_EXT 256
    #include <share.h>
  #endif
  #ifdef __ULTRIX__
    #undef __STRUPR_DEF__
  #endif
  #ifdef __SCO_XS5__
    #undef __STRUPR_DEF__
    #undef __MEMMOVE_DEF__
  #endif
  #ifdef __SPARC__
    #undef ANSI_PROTOTYPES
    #undef __LITTLE_ENDIAN__
    #define __BIG_ENDIAN__
    #undef __STRUPR_DEF__
    #undef __MEMMOVE_DEF__
    #undef __STRCMPI_DEF__
    #define __ALIGNED__
  #endif
  #ifdef __WATCOMC__
    #include <share.h>
  #endif
  #ifndef SEEK_SET
    #define SEEK_SET 0
  #endif
  #ifndef SEEK_CUR
    #define SEEK_CUR 1
  #endif
  #ifndef SEEK_END
    #define SEEK_END 2
  #endif
  #ifndef O_BINARY
    #define O_BINARY 0
  #endif
#endif

#if defined( SC_BUILDING_DLL ) || defined( SC_USING_DLL )
  #if defined( SC_WIN32 ) && defined( SC_MICROSOFT )
    #define SC_FAR_POINTER *
  #else
    #define SC_FAR_POINTER far *
  #endif
  #if defined( SC_BUILDING_DLL )
    #if defined( SC_WATCOM )
      #define SC_CLASS_TYPE
    #elif defined( SC_WIN32 ) && defined( SC_MICROSOFT )
      #define SC_CLASS_TYPE       __declspec(dllexport)
    #else
      #define SC_CLASS_TYPE       _export
    #endif

    #if defined( SC_WIN32 )
      #ifdef SC_FASTCALL
        #undef SC_FASTCALL
        #define SC_FASTCALL
      #endif
      #ifdef SC_NEAR
        #undef SC_NEAR
        #define SC_NEAR
      #endif
      #if defined( SC_MICROSOFT )
        #define PROTOS            __declspec(dllexport)
        #define SC_TYPE           __declspec(dllexport)
        #define SC_PROTO
        #define SC_FUNCTION       pascal
        #define SC_CFUNCTION      _cdecl
      #else
        #define PROTOS            far pascal _export
        #define SC_TYPE
        #define SC_PROTO          _export
        #define SC_FUNCTION       _export pascal
        #define SC_CFUNCTION      _export cdecl
      #endif
    #else
      #define SC_WIN16
      #define PROTOS            _export _far pascal
      #define SC_TYPE
      #define SC_PROTO          _far
      #define SC_FUNCTION       _export _far pascal
      #define SC_CFUNCTION      _export _far cdecl
    #endif
  #else
    #if defined( SC_WIN32 ) && defined( SC_BORLAND )
      #define PROTOS            SC_FAR pascal
      #define SC_TYPE
      #define SC_CLASS_TYPE     _import
      #define SC_PROTO          _import
      #define SC_FUNCTION       _import pascal
      #define SC_CFUNCTION      _import cdecl
    #elif defined( SC_WIN32 ) && defined( SC_SYMANTEC )
      #define PROTOS            SC_FAR pascal
      #define SC_TYPE
      #define SC_CLASS_TYPE     _export
      #define SC_PROTO          _export
      #define SC_FUNCTION       _export pascal
      #define SC_CFUNCTION      _export cdecl
    #elif defined( SC_WIN32 ) && defined( SC_MICROSOFT )
      #define PROTOS            __declspec(dllimport)
      #define SC_TYPE           __declspec(dllimport)
      #define SC_CLASS_TYPE     __declspec(dllimport)
      #define SC_PROTO
      #define SC_FUNCTION       __declspec(dllimport) pascal
      #define SC_CFUNCTION      __declspec(dllimport) _cdecl
    #elif defined( SC_WATCOM )
      #define PROTOS            SC_FAR _pascal
      #define SC_TYPE
      #define SC_PROTO
      #define SC_CLASS_TYPE
      #define SC_FUNCTION       _far _pascal
      #define SC_CFUNCTION      _far cdecl
    #else
      #define PROTOS            SC_FAR pascal
      #define SC_TYPE
      #define SC_PROTO          _far
      #ifdef SC_BORLAND
        #if( SC_BORLAND >= 0x450 )
          #define SC_CLASS_TYPE _import
        #else
          #define SC_CLASS_TYPE   _huge
        #endif
      #else
        #define SC_CLASS_TYPE   _export
      #endif
      #define SC_FUNCTION       _export _far _pascal
      #define SC_CFUNCTION      _export _far cdecl
    #endif
  #endif
#else
  #define SC_FAR_POINTER *
  #define PROTOS
  #define SC_TYPE
  #define SC_PROTO
  #define SC_CLASS_TYPE
  #if defined( SC_BORLAND )
    #define SC_FUNCTION
  #else
    #define SC_FUNCTION SC_FASTCALL
  #endif
  #define SC_CFUNCTION
#endif

#if defined( SC_WIN16 )
  #define SCSINTF static SC_FASTCALL SC_NEAR
  #define SCSVOIDF static SCVOID SC_FASTCALL SC_NEAR
  #define SCSLONGF static SCLONG SC_FASTCALL SC_NEAR
  #define SCSULONGF static SCULONG SC_FASTCALL SC_NEAR
#else
  #define SCSINTF static SCINT
  #define SCSVOIDF static SCVOID
  #define SCSLONGF static SCLONG
  #define SCSULONGF static SCULONG
#endif

#endif
/****************************[ enumerations ]****************************/
/**************************[ macro defintions ]**************************/
/************************[ structure defintions ]************************/
/**************************[ type definitions ]**************************/
typedef char SCCHAR;
typedef char SC_FAR_POINTER SCCHARP;
typedef char SC_FAR_POINTER SC_FAR_POINTER SCCHARPP;
typedef unsigned char SCUCHAR;
typedef unsigned char SC_FAR_POINTER SCUCHARP;
typedef unsigned char SC_FAR_POINTER SC_FAR_POINTER SCUCHARPP;
typedef short SCSHORT;
typedef short SC_FAR_POINTER SCSHORTP;
typedef short SC_FAR_POINTER SC_FAR_POINTER SCSHORTPP;
typedef unsigned short SCUSHORT;
typedef unsigned short SC_FAR_POINTER SCUSHORTP;
typedef unsigned short SC_FAR_POINTER SC_FAR_POINTER SCUSHORTPP;
typedef int SCINT;
typedef int SC_FAR_POINTER SCINTP;
typedef int SC_FAR_POINTER SC_FAR_POINTER SCINTPP;
typedef unsigned int SCUINT;
typedef unsigned int SC_FAR_POINTER SCUINTP;
typedef unsigned int SC_FAR_POINTER SC_FAR_POINTER SCUINTPP;
typedef long SCLONG;
typedef long SC_FAR_POINTER SCLONGP;
typedef long SC_FAR_POINTER SC_FAR_POINTER SCLONGPP;
typedef unsigned long SCULONG;
typedef unsigned long SC_FAR_POINTER SCULONGP;
typedef unsigned long SC_FAR_POINTER SC_FAR_POINTER SCULONGPP;
typedef void SCVOID;
typedef void SC_FAR_POINTER SCVOIDP;
typedef void SC_FAR_POINTER SC_FAR_POINTER SCVOIDPP;
typedef float SCFLOAT;
typedef float SC_FAR_POINTER SCFLOATP;
typedef float SC_FAR_POINTER SC_FAR_POINTER SCFLOATPP;
typedef double SCDOUBLE;
typedef double SC_FAR_POINTER SCDOUBLEP;
typedef double SC_FAR_POINTER SC_FAR_POINTER SCDOUBLEPP;

#if defined( SC_WIN32 ) && defined( SC_MICROSOFT ) && (defined( SC_BUILDING_DLL ) || defined( SC_USING_DLL ))
  #define SCINTF PROTOS SCINT PASCAL
  #define SCULONGF PROTOS SCULONG PASCAL
  #define SCVOIDF PROTOS SCVOID PASCAL
  #define SCCHARPF PROTOS SCCHAR SC_FAR_POINTER PASCAL
#else
  #define SCINTF SCINT PROTOS
  #define SCULONGF SCULONG PROTOS
  #define SCVOIDF SCVOID PROTOS
  #define SCCHARPF SCCHAR SC_FAR_POINTER PROTOS
#endif

/*************************[ class definitions ]**************************/
/************************[ variable definitions ]************************/
/************************[ external declarations ]***********************/
/*************************[ function prototypes ]************************/

