/**********************[ SoftC Database Library ]*************************
** Copyright (c) 1996, 1997 SoftC, Ltd.
** All Rights Reserved.
**************************************************************************
**
**      This module contains the structure definitions, prototypes, etc.
**      level 2 functions.
**/

/************************[ compilation switches ]************************/
/****************************[ header files ]****************************/
/************************[ constant definitions ]************************/
#define PATH_LEN 81
#define DB_MAX_SLAVES 10
#define DB_MAX_INDICES 20

/****************************[ enumerations ]****************************/
enum {
   DB_OFF = 0,
   DB_ON,
   DB_REPLACERELATION,
   DB_REMOVERELATION,
   DB_ADDRELATION
};

/**************************[ macro defintions ]**************************/
/************************[ structure defintions ]************************/
class SC_CLASS_TYPE DBUse;

typedef struct {
   DBUse *pSlave;
   DBUCHAR *pCode;
} SLAVES;

typedef struct {
   DBINT wIndex;
   DBLONG lTag;
} INDEX;

/**************************[ type definitions ]**************************/
/*************************[ class definitions ]**************************/
class SC_CLASS_TYPE DBGlobal
{
// Friends
   friend class DBUse;

// Public variables and functions
public:
   DBGlobal( void );
   DBGlobal( CONST DBINT wHandles );
   virtual ~DBGlobal( void );

   virtual DBINT SC_PROTO setExclusive(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setStyle(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setBlockSize(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setDeleted(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setAutoLock(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setMultiLocks(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setDate(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setRetry(
      CONST DBINT wValue );
   virtual DBINT SC_PROTO setUnique(
      CONST DBINT wValue );

// Protected variables & functions
protected:
   DBINT wDefaultStyle;
   DBLONG lOpenMode;
   DBINT bDeleted;
   DBINT wBlockSize;
   DBINT bUnique;
   DBCHARP szLogFileName;

private:
   DBVOID SC_PROTO init( CONST DBINT wHandles );
};

class SC_CLASS_TYPE DBUse
{
// friends

// public for all to use
public:
   SC_PROTO DBUse( DBVOID );
   SC_PROTO DBUse( CONST DBINT wHandles );
   virtual SC_PROTO ~DBUse( DBVOID );

   DBUse& DBUse::operator() (
      CONST DBCHARP szFieldName);
   DBUse& DBUse::operator() (
      CONST DBINT wFieldNo);

   operator double() CONST;
   operator float() CONST;
   operator long() CONST;
   operator unsigned long() CONST;
   operator int() CONST;
   operator unsigned int() CONST;
   operator short() CONST;
   operator unsigned short() CONST;
   operator char() CONST;
   operator unsigned char() CONST;
   operator char*() CONST;

   DBUse& DBUse::operator= (CONST DBDOUBLE dValue);
   DBUse& DBUse::operator= (CONST DBFLOAT fValue);
   DBUse& DBUse::operator= (CONST DBLONG lValue);
   DBUse& DBUse::operator= (CONST DBULONG ulValue);
   DBUse& DBUse::operator= (CONST DBINT wValue);
   DBUse& DBUse::operator= (CONST DBUINT uwValue);
   DBUse& DBUse::operator= (CONST DBSHORT nValue);
   DBUse& DBUse::operator= (CONST DBUSHORT unValue);
   DBUse& DBUse::operator= (CONST DBCHAR cValue);
   DBUse& DBUse::operator= (CONST DBUCHAR ucValue);
   DBUse& DBUse::operator= (CONST DBCHARP szValue);

   virtual DBINT SC_PROTO DBUse::append( DBVOID );

   virtual DBINT SC_PROTO DBUse::beginTransaction( DBVOID );
   virtual DBINT SC_PROTO DBUse::endTransaction( DBVOID );
   virtual DBINT SC_PROTO DBUse::rollBack( DBVOID );

   virtual DBINT SC_PROTO DBUse::close( DBVOID );

   virtual DBINT SC_PROTO create(
      CONST DBCHARP szFileName,
      CONST DBINT wNumFields,
      CONST DBFIELD SC_FAR_POINTER pFields,
      CONST DBLONG lFlags = -1l );
   virtual DBINT SC_PROTO deleteRecord(
      CONST DBLONG lRecNo = 0l );
   virtual DBINT SC_PROTO recall(
      CONST DBLONG lRecNo = 0l );

   virtual DBINT SC_PROTO getHandles(
      DBINTP dataFile,
      DBINTP memoFile,
      DBINTP indexFile,
      DBLONGP tagHandleile );

   virtual DBINT SC_PROTO goTop( DBVOID );
   virtual DBINT SC_PROTO goBottom( DBVOID );
   virtual DBINT SC_PROTO goToRecord(
      CONST DBLONG lWhere );
   virtual DBINT SC_PROTO skip(
      CONST DBLONG lHowFar = 1l );
   virtual DBINT SC_PROTO seek(
      CONST DBCHARP szWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBDOUBLE dWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBFLOAT fWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBLONG lWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBULONG ulWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBSHORT nWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBUSHORT unWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBCHAR cWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBUCHAR ucWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBINT wWhat,
      CONST DBINT wMethod = DBKEYEQUAL );
   virtual DBINT SC_PROTO seek(
      CONST DBUINT uwWhat,
      CONST DBINT wMethod = DBKEYEQUAL );

   virtual DBINT SC_PROTO locate(
      CONST DBCHARP szFilter );
   virtual DBINT SC_PROTO locateNext(
      CONST DBLONG lRecNo = -1 );

   virtual DBINT SC_PROTO pack( DBVOID );

   virtual DBINT SC_PROTO index(
      CONST DBCHARP szExpression,
      CONST DBLONG lFlags = -1l );
   virtual DBINT SC_PROTO index(
      CONST DBCHARP szExpression,
      CONST DBCHARP szFileName,
      CONST DBLONG lFlags = -1l );
   virtual DBINT SC_PROTO index(
      CONST DBCHARP szExpression,
      CONST DBCHARP szFileName,
      CONST DBCHARP szTagName,
      CONST DBLONG lFlags = -1l );
   virtual DBINT SC_PROTO index(
      CONST DBCHARP szExpression,
      CONST DBCHARP szFileName,
      CONST DBCHARP szTagName,
      CONST DBCHARP szFilter,
      CONST DBLONG lFlags = -1l );
   virtual DBINT SC_PROTO reindex( DBVOID );

   virtual DBINT SC_PROTO replace( DBVOID );

   virtual DBINT SC_PROTO zap( DBVOID );

   virtual DBINT SC_PROTO getFieldCount( DBVOID );
   virtual DBFIELD SC_PROTO getFieldInfo(
      CONST DBCHARP szFieldName );
   virtual DBFIELD SC_PROTO getFieldInfo(
      CONST DBINT wFieldNo );

   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBCHAR &cValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBUCHAR &ucValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBSHORT &nValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBUSHORT &unValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBINT &wValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBUINT &uwValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBLONG &lValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBULONG &ulValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBFLOAT &rValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBDOUBLE &dValue);
   virtual DBINT SC_PROTO getField(
      CONST DBCHARP szFieldName,
      DBCHARP szValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBCHAR &cValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBUCHAR &ucValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBSHORT &nValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBUSHORT &unValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBINT &wValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBUINT &uwValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBLONG &lValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBULONG &ulValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBFLOAT &rValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBDOUBLE &dValue);
   virtual DBINT SC_PROTO getField(
      CONST DBINT wFieldNumber,
      DBCHARP szValue);

   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBCHAR cValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBUCHAR ucValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBSHORT nValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBUSHORT unValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBINT wValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBUINT uwValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBLONG lValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBULONG ulValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBFLOAT rValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBDOUBLE dValue);
   virtual DBINT SC_PROTO putField(
      CONST DBCHARP szFieldName,
      CONST DBCHARP szValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBCHAR cValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBUCHAR ucValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBSHORT nValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBUSHORT unValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBINT wValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBUINT uwValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBLONG lValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBULONG ulValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBFLOAT rValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBDOUBLE dValue);
   virtual DBINT SC_PROTO putField(
      CONST DBINT wFieldNumber,
      CONST DBCHARP szValue);

   virtual DBLONG SC_PROTO reccount( DBVOID );
   virtual DBLONG SC_PROTO recno( DBVOID );
   virtual DBINT SC_PROTO recsize( DBVOID );
   virtual DBINT SC_PROTO isRecordDeleted( DBVOID );

   virtual DBINT SC_PROTO flock( DBVOID );
   virtual DBINT SC_PROTO unlock( DBVOID );
   virtual DBINT SC_PROTO unlock(
      CONST DBLONG lRecNo );
   virtual DBINT SC_PROTO rlock(
      CONST DBLONG lRecNo = -1l );

   virtual DBINT SC_PROTO setExclusive(
      CONST DBINT iValue );
   virtual DBINT SC_PROTO setStyle(
      CONST DBINT iValue );
   virtual DBINT SC_PROTO setBlockSize(
      CONST DBINT iValue );
   virtual DBINT SC_PROTO setDeleted(
      CONST DBINT iValue );
   virtual DBINT SC_PROTO setAutoLock(
      CONST DBINT iValue );
   virtual DBINT SC_PROTO setMultiLocks(
      CONST DBINT iValue );
   virtual DBINT SC_PROTO setUnique(
      CONST DBINT iValue );
   virtual DBINT SC_PROTO setRelation(
      DBUse *pSlave,
      CONST DBINT wWhat = 0 );
   virtual DBINT SC_PROTO setOrder(
      CONST DBCHARP szTagName );
   virtual DBINT SC_PROTO setOrder(
      CONST DBINT iTagNumber );
   virtual DBINT SC_PROTO setIndex(
      CONST DBCHARP szIndexName,
      CONST DBINT iTagNumber = 1 );
   virtual DBINT SC_PROTO setIndex(
      CONST DBCHARP szIndexName,
      CONST DBCHARP szTagName );
   virtual DBINT SC_PROTO setIndex(
      CONST DBINT wIndexNumber,
      CONST DBINT wTagNumber = 1 );
   virtual DBINT SC_PROTO setIndex(
      CONST DBINT wIndexNumber,
      CONST DBCHARP szTagName );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8,
      CONST DBCHARP szIndexFile9,
      CONST DBCHARP szIndexFile10,
      CONST DBCHARP szIndexFile11,
      CONST DBCHARP szIndexFile12,
      CONST DBCHARP szIndexFile13,
      CONST DBCHARP szIndexFile14,
      CONST DBCHARP szIndexFile15 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8,
      CONST DBCHARP szIndexFile9,
      CONST DBCHARP szIndexFile10,
      CONST DBCHARP szIndexFile11,
      CONST DBCHARP szIndexFile12,
      CONST DBCHARP szIndexFile13,
      CONST DBCHARP szIndexFile14 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8,
      CONST DBCHARP szIndexFile9,
      CONST DBCHARP szIndexFile10,
      CONST DBCHARP szIndexFile11,
      CONST DBCHARP szIndexFile12,
      CONST DBCHARP szIndexFile13 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8,
      CONST DBCHARP szIndexFile9,
      CONST DBCHARP szIndexFile10,
      CONST DBCHARP szIndexFile11,
      CONST DBCHARP szIndexFile12 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8,
      CONST DBCHARP szIndexFile9,
      CONST DBCHARP szIndexFile10,
      CONST DBCHARP szIndexFile11 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8,
      CONST DBCHARP szIndexFile9,
      CONST DBCHARP szIndexFile10 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8,
      CONST DBCHARP szIndexFile9 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7,
      CONST DBCHARP szIndexFile8 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6,
      CONST DBCHARP szIndexFile7 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5,
      CONST DBCHARP szIndexFile6 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4,
      CONST DBCHARP szIndexFile5 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3,
      CONST DBCHARP szIndexFile4 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2,
      CONST DBCHARP szIndexFile3 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1,
      CONST DBCHARP szIndexFile2 );
   virtual DBINT SC_PROTO setIndices(
      CONST DBCHARP szIndexFile1 );
   virtual DBINT SC_PROTO setFilter(
      CONST DBCHARP filter );

   virtual DBINT SC_PROTO flush( DBVOID );
   virtual DBINT SC_PROTO use(
      CONST DBCHARP szFileName,
      CONST DBINT wMode );
   virtual DBINT SC_PROTO use(
      CONST DBCHARP szFileName,
      CONST DBCHARP szIndexName,
      CONST DBINT wTagNumber,
      CONST DBINT wMode );
   virtual DBINT SC_PROTO use(
      CONST DBCHARP szFileName,
      CONST DBCHARP szIndexName,
      CONST DBCHARP szTagName,
      CONST DBINT wMode );
   virtual DBINT SC_PROTO use(
      CONST DBCHARP szFileName,
      CONST DBLONG lMode = -1l );
   virtual DBINT SC_PROTO use(
      CONST DBCHARP szFileName,
      CONST DBCHARP szIndexName,
      CONST DBINT wTagNumber = 1,
      CONST DBLONG lMode = -1l );
   virtual DBINT SC_PROTO use(
      CONST DBCHARP szFileName,
      CONST DBCHARP szIndexName,
      CONST DBCHARP szTagName,
      CONST DBLONG lMode = -1l );

// private to this class & derivatives
protected:
   DBINT wDataHandle;
   DBINT wMemoHandle;
   DBINT wLogHandle;
   DBINT wDefaultStyle;
   DBLONG lOpenMode;
   DBINT bDeleted;
   DBINT wBlockSize;
   DBINT bUnique;
   DBSHORT nFieldNumber;
   DBINT wFieldLength;
   DBINT wFieldOffset;
   DBINT bTransBegun;
   DBINT wSlaveCount;
   DBINT wIndexCount;
   DBINT wMasterIndex;
   DBLONG lLocateRecord;
   DBCHARP szLocateFilter;
   DBUCHARP szLocatePCode;
   DBCHARP szLogFileName;
   DBPACKETP pTransLog;
   SLAVES slaveTable[DB_MAX_SLAVES];
   INDEX indexTable[DB_MAX_INDICES];

// private to this class
private:
   DBCHARP pcRecBuffer;
   DBINT wKeyType, wStatus;
   DBCHAR szKey[DBMAXKEYLEN + 1];

   DBVOID SC_PROTO init( CONST DBINT wHandles );
   DBINT SC_PROTO openMemo(
      CONST DBCHARP fname,
      CONST DBINT wMode );
   DBINT SC_PROTO openIndex(
      CONST DBCHARP fname,
      CONST DBINT wMode );
   DBINT SC_PROTO find(
      CONST DBINT wMethod );
   DBDOUBLE SC_PROTO getDouble( DBVOID ) CONST;
   DBCHARP getString( DBVOID ) CONST;
   DBUse& putDouble(
      CONST DBDOUBLE dValue );
   DBUse& putString(
      CONST DBCHARP szValue );
   DBINT SC_PROTO repositionSlaves( DBVOID );
   DBINT SC_PROTO endSlaveTransaction( DBVOID );
   DBINT SC_PROTO beginSlaveTransaction( DBINT file );
   DBINT SC_PROTO loopForward(
      DBLONG &lRecNo,
      CONST DBLONG lRecCount );
   DBINT SC_PROTO loopBackward(
      DBLONG &lRecNo );
};

/************************[ variable definitions ]************************/
/************************[ external declarations ]***********************/
/*************************[ function prototypes ]************************/
extern "C" SC_TYPE DBINT SC_FUNCTION DBappend(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBbeginTransaction(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBclose(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBcreate(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szFileName,
   CONST DBINT wNumFields,
   CONST DBFIELD SC_FAR_POINTER pFields,
   CONST DBLONG lFlags );
extern "C" SC_TYPE DBUse SC_FAR_POINTER SC_FUNCTION DBcreateWorkArea(
   CONST DBINT wFiles );
extern "C" SC_TYPE DBINT SC_FUNCTION DBdelete(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lRecNo );
extern "C" SC_TYPE DBVOID SC_FUNCTION DBdestroyWorkArea(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBendTransaction(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBflock(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBflush(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBgetFieldCount(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBgetHandles(
   DBUse SC_FAR_POINTER table,
   DBINTP dataFile,
   DBINTP memoFile,
   DBINTP indexFile,
   DBLONGP tagHandle );
extern "C" SC_TYPE DBINT SC_FUNCTION DBgoBottom(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBgoTop(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBgoToRecord(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lRecNo );
extern "C" SC_TYPE DBINT SC_FUNCTION DBindex(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szExpression,
   CONST DBCHARP szFileName,
   CONST DBCHARP szTagName,
   CONST DBCHARP szFilter,
   CONST DBLONG lFlags );
extern "C" SC_TYPE DBINT SC_FUNCTION DBlocate(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP filter );
extern "C" SC_TYPE DBINT SC_FUNCTION DBlocateNext(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lRecNo );
extern "C" SC_TYPE DBINT SC_FUNCTION DBpack(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBrecall(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lRecNo );
extern "C" SC_TYPE DBLONG SC_FUNCTION DBreccount(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBLONG SC_FUNCTION DBrecno(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBrecordUnlock(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lRecNo );
extern "C" SC_TYPE DBINT SC_FUNCTION DBrecsize(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBreindex(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBreplace(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBrlock(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lRecNo );
extern "C" SC_TYPE DBINT SC_FUNCTION DBrollBack(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_PROTO DBseekString(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekDouble(
   DBUse SC_FAR_POINTER table,
   CONST DBDOUBLE dWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekFloat(
   DBUse SC_FAR_POINTER table,
   CONST DBFLOAT fWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekLong(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekUnsignedLong(
   DBUse SC_FAR_POINTER table,
   CONST DBULONG ulWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekShort(
   DBUse SC_FAR_POINTER table,
   CONST DBSHORT nWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekUnsignedShort(
   DBUse SC_FAR_POINTER table,
   CONST DBUSHORT unWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekChar(
   DBUse SC_FAR_POINTER table,
   CONST DBCHAR cWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekUnsignedChar(
   DBUse SC_FAR_POINTER table,
   CONST DBUCHAR ucWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekInt(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_PROTO DBseekUnsignedInt(
   DBUse SC_FAR_POINTER table,
   CONST DBUINT uwWhat,
   CONST DBINT wMethod );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetAutoLock(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wValue );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetBlockSize(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wValue );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetDeleted(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wValue );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetExclusive(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wValue );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetIndexNamed(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szIndexName,
   CONST DBCHARP szTagName );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetIndexNumbered(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szIndexName,
   CONST DBINT wTagNumber );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetMultiLocks(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wValue );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetOrderName(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szTagName );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetOrderNumber(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wTagNumber );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetRecordFilter(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP filter );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetRelation(
   DBUse SC_FAR_POINTER table,
   DBUse *pSlave,
   CONST DBINT wWhat );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetStyle(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wValue );
extern "C" SC_TYPE DBINT SC_FUNCTION DBsetUnique(
   DBUse SC_FAR_POINTER table,
   CONST DBINT wValue );
extern "C" SC_TYPE DBINT SC_FUNCTION DBskip(
   DBUse SC_FAR_POINTER table,
   CONST DBLONG lRecCount );
extern "C" SC_TYPE DBINT SC_FUNCTION DBunlock(
   DBUse SC_FAR_POINTER table );
extern "C" SC_TYPE DBINT SC_FUNCTION DBuse(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szFileName,
   CONST DBLONG lMode );
extern "C" SC_TYPE DBINT SC_FUNCTION DBuseNumberedTag(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szFileName,
   CONST DBCHARP szIndexName,
   CONST DBINT wTagNumber,
   CONST DBLONG lMode );
extern "C" SC_TYPE DBINT SC_FUNCTION DBuseNamedTag(
   DBUse SC_FAR_POINTER table,
   CONST DBCHARP szFileName,
   CONST DBCHARP szIndexName,
   CONST DBCHARP szTagName,
   CONST DBLONG lMode );
extern "C" SC_TYPE DBINT SC_FUNCTION DBzap(
   DBUse SC_FAR_POINTER table );

