/**********************[ SoftC Database Library ]*************************
** Copyright (c) 1988, 1997 SoftC, Ltd.
** All Rights Reserved.
**************************************************************************
**
**      This module contains general definitions.
**/

/************************[ compilation switches ]************************/
#ifndef __DBLVL1_DOT_H__
/****************************[ header files ]****************************/
/************************[ constant definitions ]************************/
#define __DBLVL1_DOT_H__

#define DBTRUE SCTRUE
#define DBFALSE SCFALSE

/* general numeric constants */
#define MAX_LONG    0x7fffffffL     /* maximum value for signed long    */
#define MAX_ULONG   0xffffffffL     /* maximum value for unsigned long  */
#define HEX_0L      0L
#define HEX_1L      1L
#define HEX_2L      2L
#define MINUS_1L    -1L

/* DBxxKeySearch definitions */
#define DBFIRSTKEY           1    /* find first occurance of 'key'        */
#define DBEXACT              2    /* find exact key (uses record number)  */
#define DBLASTKEY            3    /* find last occurance of 'key'         */
#define DBKEYLESS           11    /* find key less than                   */
#define DBKEYEQUALORLESS    12    /* find key less than or equal to       */
#define DBKEYEQUAL          13    /* find key equal to                    */
#define DBKEYEQUALORGREATER 14    /* find key greater than or equal to    */
#define DBKEYGREATER        15    /* find key greater than                */
#define DBCONTINUE          64    /* continue key search                  */

/* file open modifiers */
#define DBOPENREADWRITE SCOPENREADWRITE
#define DBOPENREADONLY  SCOPENREADONLY
#define DBOPENBUFFERED  SCOPENBUFFERED
#define DBOPENFLUSHED   SCOPENFLUSHED
#define DBOPENEXCLUSIVE SCOPENEXCLUSIVE
#define DBOPENSHARED    SCOPENSHARED
#define DBOPENMANUALLOCK SCOPENMANUALLOCK
#define DBOPENAUTOLOCKS SCOPENAUTOLOCKS
#define DBOPENSYSBUFFERED SCOPENSYSBUFFERED
#define DBOPENMULTILOCKS SCOPENMULTILOCKS
#define DBOPENAPPEND    SCOPENAPPEND
#define DBREUSEDELETED  SCREUSEDELETED
#define DBOPENSTANDARD  (SCOPENREADWRITE|SCOPENBUFFERED|SCOPENEXCLUSIVE|SCOPENMANUALLOCK) /* Standard open */
#define DBOPENLAN (SCOPENFLUSHED|SCOPENSHARED) /* typical (shared and flushed) */

/* index file types */
#define DBCOMPOUNDINDEX   0x800   /* compound indices                   */
#define DBCOMPRESSEDINDEX 0x400   /* compressed indices                 */
#define DBPRODUCTIONINDEX 0x200   /* production index (MDX & CDX only)  */

/* DBPutRecord, DBPutRecordBuffer, DBxxPutMemoRecord */
#define DBUPDATERECORD 0x100      /* update existing record       */
#define DBAPPENDRECORD 0          /* append record at end of file */

/* DBxxGetMemoExtended, DBxxPutMemoExtended */
#define DBBINARYDATA   0x200      /* binary memo data     */
#define DBTEXTDATA     0          /* text memo data       */
#define DBPARTIAL      0x400      /* partial read/write   */
#define DBCOMPLETE     0          /* complete read/write  */
#define DBCOMPRESSEDDATA  0x800   /* compressed memo data */

/* field type modifiers */
#define DBFIELDINDEX      0x100   /* field is indexed                   */

/* index key types */
#define DBCHARACTERKEY 'C'     /* character type key       */
#define DBDATEKEY      'D'     /* date type key            */
#define DBBCDKEY       'F'     /* binary coded decimal key */
#define DBLOGICALKEY   'L'     /* logical key type         */
#define DBMEMOKEY      'M'     /* memo key type            */
#define DBNUMERICKEY   'N'     /* numeric type key         */

/* key type modifiers */
#define DBDESCENDINDEX 0x4000  /* descending key order               */
#define DBUNIQUEINDEX  0x8000  /* unique index keys                  */

/* DBInitialize */
#define DBUSEXTRAHANDLES SCUSEXTRAHANDLES    /* allow more than 20 open files */

/* DBGetLockInfo */
#define DBRECORDLOCK 0x01         /* record lock active       */
#define DBHEADERLOCK 0x02         /* file header lock active  */
#define DBFILELOCK   0x04         /* file lock active         */

#define DBOPENFLAGSP DBOPENFLAGS SC_FAR_POINTER

#define DBLONGDATE      SCLONGDATE
#define DBGREGORIAN     SCGREGORIAN
#define DBLONGGREGORIAN SCLONGGREGORIAN
#define DBANSI          SCANSI
#define DBLONGANSI      SCLONGANSI
#define DBGERMAN        SCGERMAN
#define DBLONGGERMAN    SCLONGGERMAN
#define DBBRITISH       SCBRITISH
#define DBLONGBRITISH   SCLONGBRITISH
#define DBFRENCH        SCFRENCH
#define DBLONGFRENCH    SCLONGFRENCH
#define DBITALIAN       SCITALIAN
#define DBLONGITALIAN   SCLONGITALIAN
#define DBJAPAN         SCJAPAN
#define DBLONGJAPAN     SCLONGJAPAN
#define DBUSA           SCUSA
#define DBLONGUSA       SCLONGUSA
#define DBMDY           SCMDY
#define DBMDYY          SCMDYY
#define DBYMD           SCYMD
#define DBYYMD          SCYYMD
#define DBYYYYMMDD      SCYYYYMMDD
#define DBDDMMYY        SCDDMMYY
#define DBJULIAN        SCJULIAN

#define DBHHMMSS        SCHHMMSS
#define DBMILITARY      SCMILITARY

#define DBFIELDP DBFIELD SC_FAR_POINTER
#define DBFILELOCKSP DBFILELOCKS SC_FAR_POINTER
#define DBFILELOCKSPP DBFILELOCKS SC_FAR_POINTER SC_FAR_POINTER
#define DBFILEINFOP DBFILEINFO SC_FAR_POINTER

/* DBFILEINFO memo flag */
#define DBUSEMEMO 1                /* memo file used */
#define DBNOMEMO 0                 /* no memo file required */

/* open file flags */
#define DBRECINFOP DBRECINFO SC_FAR_POINTER

/* field types */
#define DBCHARACTERFIELD DBCHARACTERKEY /* character field */
#define DBDATEFIELD      DBDATEKEY      /* date field */
#define DBBCDFIELD       DBBCDKEY       /* BCD numeric field */
#define DBLOGICALFIELD   DBLOGICALKEY   /* logical (boolean) field */
#define DBMEMOFIELD      DBMEMOKEY      /* memo (variable length data) field */
#define DBNUMERICFIELD   DBNUMERICKEY   /* numeric field */

/* extended data file field types */
#define DBDOUBLEFIELD    DBDOUBLEKEY      /* IEEE double real (64 bits) */
#define DBFLOATFIELD     DBFLOATKEY       /* IEEE single real (32 bits) */
#define DBULONGFIELD     DBULONGKEY       /* unsigned long integer */
#define DBLONGFIELD      DBLONGKEY        /* signed long integer (32 bits) */
#define DBUSHORTFIELD    DBUSHORTKEY      /* unsigned short integer */
#define DBSHORTFIELD     DBSHORTKEY       /* signed short integer (16 bits) */
#define DBUCHARFIELD     DBUCHARKEY       /* single unsigned byte */
#define DBCHARFIELD      DBCHARKEY        /* single signed byte (8 bits) */
#define DBCOUNTERFIELD   DBCOUNTERKEY     /* counter field */
#define DBBITFIELD       DBBITFIELDKEY    /* bit field */
#define DBPACKEDDATEFIELD DBPACKEDDATEKEY /* packed date (DOS style) */
#define DBPACKEDTIMEFIELD DBPACKEDTIMEKEY /* packed time (DOS style) */

#define DBEVALP DBEVAL SC_FAR_POINTER

/* DBxbGetMemoRecord, DBxbPutMemoRecord definitions */
#define DBCRUNCHANGE 0             /* leave memo buffer unchanged */
#define DBCRDELETE 0x100           /* delete soft carriage returns */

#define DBMEMOINFOP DBMEMOINFO SC_FAR_POINTER

/* xBase info structures */
#define DBXBMEMOINFO DBMEMOINFO
#define DBXBMEMOINFOP DBMEMOINFOP

/* FoxPro info structures */
#define DBFPMEMOINFO DBMEMOINFO
#define DBFPMEMOINFOP DBMEMOINFOP

#define DBINDEXINFOP DBINDEXINFO SC_FAR_POINTER
#define DBTAGINFOP DBTAGINFO SC_FAR_POINTER
#define DBTAGINFOPP DBTAGINFO SC_FAR_POINTER SC_FAR_POINTER

#define DBFPINDEXINFO DBINDEXINFO
#define DBFPINDEXINFOP DBINDEXINFOP
#define DBFPTAGINFO DBTAGINFO
#define DBFPTAGINFOP DBTAGINFOP
#define DBFPTAGINFOPP DBTAGINFOPP
#define DBD4INDEXINFO DBINDEXINFO
#define DBD4INDEXINFOP DBINDEXINFOP
#define DBD4TAGINFO DBTAGINFO
#define DBD4TAGINFOP DBTAGINFOP
#define DBD4TAGINFOPP DBTAGINFOPP

/* Function Return Codes */
#define SCWAR_02001   2001    /* record read is marked deleted */
#define SCWAR_02002   2002    /* file is empty */
#define SCWAR_02003   2003    /* no more keys */
#define SCWAR_02004   2004    /* could not find key in index */
#define SCWAR_02005   2005    /* data field truncated */
#define SCWAR_02006   2006    /* numeric field rounded */
#define SCWAR_02007   2007    /* file length is incorrect */
#define SCWAR_02008   2008    /* I/O not buffered */
#define SCWAR_02009   2009    /* memory allocation incomplete */
#define SCWAR_02010   2010    /* object already exists */
#define SCWAR_02011   2011    /* field is empty */
#define SCWAR_02012   2012    /* empty fields */
#define SCWAR_02013   2013    /* no more records */
#define SCWAR_02014   2014    /* user abort */
#define SCWAR_02015   2015    /* tag in use */

#define DBSUCCESS SCSUCCESS
#if 0
#define DBINACTIVERECORD SCWAR_02001
#define DBEMPTYFILE SCWAR_02002
#define DBNOMOREKEYS SCWAR_02003
#define DBKEYNOTFOUND SCWAR_02004
#define DBFIELDTRUNC SCWAR_02005
#define DBFIELDROUND SCWAR_02006
#define DBFILELENGTH SCWAR_02007
#define DBNOTBUFFERED SCWAR_02008
#define DBSOMEMEMORY SCWAR_02009
#define DBKEYEXISTS SCWAR_02010
#define DBBLANKFIELD SCWAR_02011
#define DBEMPTYFIELDS SCWAR_02012
#define DBNOMORERECORDS SCWAR_02013
#define DBUSERABORT SCWAR_02014
#define DBTAGINUSE SCWAR_02015
#endif

#define SCERR_02001   -2001   /* file not found */
#define SCERR_02002   -2002   /* file corrupted */
#define SCERR_02003   -2003   /* bad user specified key expression */
#define SCERR_02004   -2004   /* no index pages loaded */
#define SCERR_02005   -2005   /* index page was not loaded */
#define SCERR_02009   -2009   /* file not in .DBT format */
#define SCERR_02010   -2010   /* invalid file version */
#define SCERR_02011   -2011   /* file header length error */
#define SCERR_02012   -2012   /* last file change date in error */
#define SCERR_02013   -2013   /* invalid key type */
#define SCERR_02014   -2014   /* invalid key length */
#define SCERR_02015   -2015   /* item length incorrect */
#define SCERR_02016   -2016   /* invalid root page */
#define SCERR_02017   -2017   /* bad maximum number of keys per page */
#define SCERR_02018   -2018   /* invalid number of fields */
#define SCERR_02019   -2019   /* field name invalid */
#define SCERR_02020   -2020   /* bad field length */
#define SCERR_02021   -2021   /* decimal places parameter invalid */
#define SCERR_02022   -2022   /* invalid field type */
#define SCERR_02023   -2023   /* invalid record length */
#define SCERR_02024   -2024   /* bad data */
#define SCERR_02025   -2025   /* memo soft line length invalid */
#define SCERR_02026   -2026   /* MDX flag in DBF file invalid */
#define SCERR_02030   -2030   /* bad minimum number of keys per page */
#define SCERR_02032   -2032   /* invalid tag handle */
#define SCERR_02033   -2033   /* invalid block size */
#define SCERR_02034   -2034   /* invalid tag name */
#define SCERR_02035   -2035   /* invalid block adder size */
#define SCERR_02036   -2036   /* invalid maximum number of tags */
#define SCERR_02037   -2037   /* bad tag table element length */
#define SCERR_02038   -2038   /* invalid tag count */
#define SCERR_02039   -2039   /* unknown key format switches */
#define SCERR_02040   -2040   /* unknown switch error */
#define SCERR_02043   -2043   /* file not open */
#define SCERR_02044   -2044   /* object is already in use */

#if 0
#define DBINVPARAMETER SCERR_02080
#define DBKEYVIOL SCERR_02079
#define DBFUNCOUTREF2 SCERR_02078
#define DBFUNCARGSTR SCERR_02077
#define DBFUNCTBLARG SCERR_02076
#define DBSELENOFUNC SCERR_02075
#define DBHAVTBLREF SCERR_02074
#define DBQCMPGRPHAV SCERR_02073
#define DBMULDISTINCT SCERR_02072
#define DBWHEREFUNCREF SCERR_02071
#define DBFUNCNOARGS SCERR_02070
#define DBFUNCOUTREF1 SCERR_02069
#define DBCMPPREDROWS SCERR_02068
#define DBINVSORTARG SCERR_02067
#define DBDUPSORTARG SCERR_02066
#define DBSELEFLDREF SCERR_02065
#define DBGRPFLDFUNC SCERR_02064
#define DBGRPTBLREF SCERR_02063
#define DBSELEGRPREF SCERR_02062
#define DBOPUPONSTR SCERR_02061
#define DBFUNCDISTOP SCERR_02060
#define DBSUBQSELECT SCERR_02059
#define DBFUNCINFUNC SCERR_02058
#define DBOVERFLOW SCERR_02057
#define DBLIKEARGSTR SCERR_02056
#define DBSYNTAX SCERR_02055
#define DBUNTERMSTR SCERR_02054
#define DBIDENTIFIER SCERR_02053
#define DBLIKEESCAPE SCERR_02052
#define DBLIKEPATTERN SCERR_02051
#define DBBADFLDTBL SCERR_02050
#define DBAMBIGTBLREF SCERR_02049
#define DBDUPALIAS SCERR_02048
#define DBTBLALIASEQ SCERR_02047
#define DBDUPTBL SCERR_02046
#define DBDOSEXTENDERERROR SCERR_02045
#define DBOBJECTINUSE SCERR_02044
#define DBFILENOTOPEN SCERR_02043
#define DBTABLEINDEXED SCERR_02041
#define DBHEADERSWITCH SCERR_02040
#define DBKEYFORMAT SCERR_02039
#define DBTAGCOUNT SCERR_02038
#define DBTABLELENGTH SCERR_02037
#define DBMAXTAGS SCERR_02036
#define DBBLOCKADDER SCERR_02035
#define DBTAGNAME SCERR_02034
#define DBBLOCKSIZE SCERR_02033
#define DBTAGHANDLE SCERR_02032
#define DBMINKEYS SCERR_02030
#define DBMULTIPLEINDEX SCERR_02026
#define DBLINELENGTH SCERR_02025
#define DBWRITEDATA SCERR_02024
#define DBRECORDLENGTH SCERR_02023
#define DBFIELDTYPE SCERR_02022
#define DBDECIMALPLACE SCERR_02021
#define DBFIELDLENGTH SCERR_02020
#define DBFIELDNAME SCERR_02019
#define DBFIELDCOUNT SCERR_02018
#define DBMAXKEYS SCERR_02017
#define DBROOTPAGE SCERR_02016
#define DBITEMLENGTH SCERR_02015
#define DBKEYLENGTH SCERR_02014
#define DBKEYTYPE SCERR_02013
#define DBHEADERDATE SCERR_02012
#define DBHEADERLENGTH SCERR_02011
#define DBFILEVERSION SCERR_02010
#define DBNOTMEMOFILE SCERR_02009
#define DBPAGENUMBER SCERR_02005
#define DBNOPAGES SCERR_02004
#define DBKEYEXPR SCERR_02003
#define DBFILECORRUPT SCERR_02002
#define DBNOFILE SCERR_02001
#endif

/****************************[ enumerations ]****************************/
/* extended key types */
enum {
  DBSTRINGKEY,                 /* character string key     */
  DBDOUBLEKEY,                 /* double key               */
  DBFLOATKEY,                  /* float key                */
  DBULONGKEY,                  /* unsigned long key        */
  DBLONGKEY,                   /* signed long key          */
  DBUSHORTKEY,                 /* unsigned short key       */
  DBSHORTKEY,                  /* signed short key         */
  DBUCHARKEY,                  /* unsigned byte key        */
  DBCHARKEY,                   /* signed byte key          */
  DBCOUNTERKEY,                /* counter key              */
  DBBITFIELDKEY,               /* bit field key            */
  DBPACKEDDATEKEY,             /* packed date (DOS style)  */
  DBPACKEDTIMEKEY,             /* packed time (DOS style)  */
  DBBITVECTORKEY               /* bit vector               */
};

/* File style flag */
enum {
  DBDBASE3 = 1,             /* dBase3             */
  DBDBASE4,                 /* dBase4             */
  DBDBASE5,                 /* dBASE5             */
  DBFOXBASE,                /* FoxBase Plus       */
  DBFOXPRO1,                /* FoxPro 1.0         */
  DBFOXPRO2,                /* FoxPro 2.0         */
  DBFOXPRO3,                /* Visual FoxPro 3.0  */
  DBCLIPPER87,              /* Clipper Summer 87  */
  DBCLIPPER5                /* Clipper 5.0        */
};

/**************************[ macro defintions ]**************************/
#define DBClearErrorCode() DBSetErrorCode(SCSUCCESS)

/* Lower-case Function Name Definitions */
#define dballocatememory    DBAllocateMemory
#define dbclearerrorcode    DBClearErrorCode
#define dbclosequeue        DBCloseQueue
#define dbfreememory        DBFreeMemory
#define dbgeterrorcode      DBGetErrorCode
#define dbgeterrorstr       DBGetErrorStr
#define dbgetlockcount      DBGetLockCount
#define dbgetlockretrycount DBGetLockRetryCount
#define dbgetversion        DBGetVersion
#define dbinitialize        DBInitialize
#define dbmemchr            DBmemchr
#define dbmemcmp            DBmemcmp
#define dbmemcpy            DBmemcpy
#define dbmemset            DBmemset
#define dbreallocatememory  DBReAllocateMemory
#define dbseterrorcode      DBSetErrorCode
#define dbsetlockcount      DBSetLockCount
#define dbsetlockretrycount DBSetLockRetryCount
#define dbstrcmp            DBstrcmp
#define dbstricmp           DBstricmp
#define dbstrlen            DBstrlen
#define dbstrrchr           DBstrrchr
#define dbstrstr            DBstrstr
#define dbterminate         DBTerminate
#define dbstrleft           DBstrleft
#define dbstrltrim          DBstrltrim
#define dbstrmid            DBstrmid
#define dbstrright          DBstrright
#define dbstrrtrim          DBstrrtrim
#define dbstrtrim           DBstrtrim
#define dbxstrcmp           DBxstrcmp
#define dbconvertdatestr        DBConvertDateStr
#define dbdate3tolong           DBDate3ToLong
#define dbdate3tostr            DBDate3ToStr
#define dbdayofweek             DBDayOfWeek
#define dbdaysbetweenstr        DBDaysBetweenStr
#define dbdaysinmonth           DBDaysInMonth
#define dbdaysinmonthstr        DBDaysInMonthStr
#define dbgetdate3              DBGetDate3
#define dbgetdatestr            DBGetDateStr
#define dbgetdefaultdatestyle   DBGetDefaultDateStyle
#define dbgettime3              DBGetTime3
#define dbgettimestr            DBGetTimeStr
#define dbisleapyear            DBIsLeapYear
#define dbisstrleapyear         DBIsStrLeapYear
#define dbisvaliddatestr        DBIsValidDateStr
#define dbisvalidtimestr        DBIsValidTimeStr
#define dblongdateto3           DBLongDateTo3
#define dblongdatetodayofweek   DBLongDateToDayOfWeek
#define dblongdatetostr         DBLongDateToStr
#define dbmonthtostr            DBMonthToStr
#define dbsecondsbetweenstr     DBSecondsBetweenStr
#define dbsetdefaultdatestyle   DBSetDefaultDateStyle
#define dbstrdateto3            DBStrDateTo3
#define dbstrdatetodayofweek    DBStrDateToDayOfWeek
#define dbstrdatetointdayweek   DBStrDateToIntDayWeek
#define dbstrdatetolong         DBStrDateToLong
#define dbstrdatetomonth        DBStrDateToMonth
#define dbstrtimeto3            DBStrTimeTo3
#define dbtime3tostr            DBTime3ToStr
#define dbclearbuffer           DBClearBuffer
#define dbclosefile             DBCloseFile
#define dbcreatefile            DBCreateFile
#define dbfilterrecord          DBFilterRecord
#define dbflushfile             DBFlushFile
#define dbgetfieldbinary        DBGetFieldBinary
#define dbgetfielddata          DBGetFieldData
#define dbgetfielddescription   DBGetFieldDescription
#define dbgetfieldname          DBGetFieldName
#define dbgetfieldnumber        DBGetFieldNumber
#define dbgetfiledescription    DBGetFileDescription
#define dbgetfileinfo           DBGetFileInfo
#define dbgetlastupdate         DBGetLastUpdate
#define dbgetlockinfo           DBGetLockInfo
#define dbgetnamedbinary        DBGetNamedBinary
#define dbgetnameddata          DBGetNamedData
#define dbgetnamedstr           DBGetNamedStr
#define dbgetrecord             DBGetRecord
#define dbgetrecordcount        DBGetRecordCount
#define dbgetrecordinfo         DBGetRecordInfo
#define dbgetrecordnumber       DBGetRecordNumber
#define dbgetrecordtobuffer     DBGetRecordToBuffer
#define dbgetrecordcachesize    DBGetRecordCacheSize
#define dbsetrecordcachesize    DBSetRecordCacheSize
#define dbgetfieldstr           DBGetFieldStr
#define dbisbeginningoffile     DBIsBeginningOfFile
#define dbisendoffile           DBIsEndOfFile
#define dbisfieldblank          DBIsFieldBlank
#define dbisnamedblank          DBIsNamedBlank
#define dbisrecorddeleted       DBIsRecordDeleted
#define dbisrecordlocked        DBIsRecordLocked
#define dblockfile              DBLockFile
#define dblockheader            DBLockHeader
#define dblockrecord            DBLockRecord
#define dbmarkrecordactive      DBMarkRecordActive
#define dbmarkrecordinactive    DBMarkRecordInActive
#define dbopenfile              DBOpenFile
#define dbpackfile              DBPackFile
#define dbputfieldbinary        DBPutFieldBinary
#define dbputfielddata          DBPutFieldData
#define dbputnamedbinary        DBPutNamedBinary
#define dbputnameddata          DBPutNamedData
#define dbputnamedstr           DBPutNamedStr
#define dbputrecord             DBPutRecord
#define dbputrecordfrombuffer   DBPutRecordFromBuffer
#define dbputfieldstr           DBPutFieldStr
#define dbresetproductionindex  DBReSetProductionIndex
#define dbsetbufferaddress      DBSetBufferAddress
#define dbsetfieldindexed       DBSetFieldIndexed
#define dbsetfilter             DBSetFilter
#define dbsetproductionindex    DBSetProductionIndex
#define dbunlockall             DBUnLockAll
#define dbunlockheader          DBUnLockHeader
#define dbunlockrecord          DBUnLockRecord
#define dbzapfile               DBZapFile
#define dbclclosememo          DBxbCloseMemo
#define dbclcreatememo(a)      DBxbCreateMemo(a,1,DBCLIPPER5)
#define dbclgetmemoinfo        DBxbGetMemoInfo
#define dbclgetmemorecord      DBxbGetMemoRecord
#define dbcllockmemo           DBxbLockMemo
#define dbclopenmemo(a,b,c)    DBxbOpenMemo(a,b,c|DBCLIPPER5)
#define dbclpackmemo           DBxbPackMemo
#define dbclputmemorecord      DBxbPutMemoRecord
#define dbclunlockmemo         DBxbUnLockMemo
#define dbclzapmemo            DBxbZapMemo
#define DBclCloseMemo          DBxbCloseMemo
#define DBclCreateMemo(a)      DBxbCreateMemo(a,1,DBCLIPPER5)
#define DBclGetMemoInfo        DBxbGetMemoInfo
#define DBclGetMemoRecord      DBxbGetMemoRecord
#define DBclLockMemo           DBxbLockMemo
#define DBclOpenMemo(a,b,c)    DBxbOpenMemo(a,b,c|DBCLIPPER5)
#define DBclPackMemo           DBxbPackMemo
#define DBclPutMemoRecord      DBxbPutMemoRecord
#define DBclUnLockMemo         DBxbUnLockMemo
#define DBclZapMemo            DBxbZapMemo
#define dbd3closememo          DBxbCloseMemo
#define dbd3creatememo(a)      DBxbCreateMemo(a,1,DBDBASE3)
#define dbd3getmemoinfo        DBxbGetMemoInfo
#define dbd3getmemorecord      DBxbGetMemoRecord
#define dbd3lockmemo           DBxbLockMemo
#define dbd3openmemo(a,b,c)    DBxbOpenMemo(a,b,c|DBDBASE3)
#define dbd3packmemo           DBxbPackMemo
#define dbd3putmemorecord      DBxbPutMemoRecord
#define dbd3unlockmemo         DBxbUnLockMemo
#define dbd3zapmemo            DBxbZapMemo
#define DBd3CloseMemo          DBxbCloseMemo
#define DBd3CreateMemo(a)      DBxbCreateMemo(a,1,DBDBASE3)
#define DBd3GetMemoInfo        DBxbGetMemoInfo
#define DBd3GetMemoRecord      DBxbGetMemoRecord
#define DBd3LockMemo           DBxbLockMemo
#define DBd3OpenMemo(a,b,c)    DBxbOpenMemo(a,b,c|DBDBASE3)
#define DBd3PackMemo           DBxbPackMemo
#define DBd3PutMemoRecord      DBxbPutMemoRecord
#define DBd3UnLockMemo         DBxbUnLockMemo
#define DBd3ZapMemo            DBxbZapMemo
#define dbd4closememo          DBxbCloseMemo
#define dbd4creatememo(a,b)    DBxbCreateMemo(a,b,DBDBASE4)
#define dbd4getmemoinfo        DBxbGetMemoInfo
#define dbd4getmemorecord      DBxbGetMemoRecord
#define dbd4lockmemo           DBxbLockMemo
#define dbd4openmemo(a,b,c)    DBxbOpenMemo(a,b,c|DBDBASE4)
#define dbd4packmemo           DBxbPackMemo
#define dbd4putmemorecord      DBxbPutMemoRecord
#define dbd4unlockmemo         DBxbUnLockMemo
#define dbd4zapmemo            DBxbZapMemo
#define DBd4CloseMemo          DBxbCloseMemo
#define DBd4CreateMemo(a,b)    DBxbCreateMemo(a,b,DBDBASE4)
#define DBd4GetMemoInfo        DBxbGetMemoInfo
#define DBd4GetMemoRecord      DBxbGetMemoRecord
#define DBd4LockMemo           DBxbLockMemo
#define DBd4OpenMemo(a,b,c)    DBxbOpenMemo(a,b,c|DBDBASE4)
#define DBd4PackMemo           DBxbPackMemo
#define DBd4PutMemoRecord      DBxbPutMemoRecord
#define DBd4UnLockMemo         DBxbUnLockMemo
#define DBd4ZapMemo            DBxbZapMemo
#define dbfbclosememo          DBxbCloseMemo
#define dbfbcreatememo(a)      DBxbCreateMemo(a,1,DBFOXBASE)
#define dbfbgetmemoinfo        DBxbGetMemoInfo
#define dbfbgetmemorecord      DBxbGetMemoRecord
#define dbfblockmemo           DBxbLockMemo
#define dbfbopenmemo(a,b,c)    DBxbOpenMemo(a,b,c|DBFOXBASE)
#define dbfbpackmemo           DBxbPackMemo
#define dbfbputmemorecord      DBxbPutMemoRecord
#define dbfbunlockmemo         DBxbUnLockMemo
#define dbfbzapmemo            DBxbZapMemo
#define DBfbCloseMemo          DBxbCloseMemo
#define DBfbCreateMemo(a)      DBxbCreateMemo(a,1,DBFOXBASE)
#define DBfbGetMemoInfo        DBxbGetMemoInfo
#define DBfbGetMemoRecord      DBxbGetMemoRecord
#define DBfbLockMemo           DBxbLockMemo
#define DBfbOpenMemo(a,b,c)    DBxbOpenMemo(a,b,c|DBFOXBASE)
#define DBfbPackMemo           DBxbPackMemo
#define DBfbPutMemoRecord      DBxbPutMemoRecord
#define DBfbUnLockMemo         DBxbUnLockMemo
#define DBfbZapMemo            DBxbZapMemo
#define dbfpclosememo          DBfpCloseMemo
#define dbfpcreatememo         DBfpCreateMemo
#define dbfpgetmemoinfo        DBfpGetMemoInfo
#define dbfpgetmemorecord      DBfpGetMemoRecord
#define dbfpgetmemotobuffer    DBfpGetMemoToBuffer
#define dbfpgetmemotype        DBfpGetMemoType
#define dbfplockmemo           DBfpLockMemo
#define dbfpopenmemo(a,b,c)    DBfpOpenMemo(a,b,c|DBFOXPRO2)
#define dbfppackmemo           DBfpPackMemo
#define dbfpputmemorecord      DBfpPutMemoRecord
#define dbfpunlockmemo         DBfpUnLockMemo
#define dbaddkey                 DBAddKey
#define dbbuildindex             DBBuildIndex
#define dbcloseindex             DBCloseIndex
#define dbclosetag               DBCloseTag
#define dbcreateindex            DBCreateIndex
#define dbcreatetag              DBCreateTag
#define dbbitfieldtokey          DBBitFieldToKey
#define dbcountertokey           DBCounterToKey
#define dbdatetokey              DBDateToKey
#define dbdeletekey              DBDeleteKey
#define dbdeletetag              DBDeleteTag
#define dbdoubletokey            DBDoubleToKey
#define dbfloattokey             DBFloatToKey
#define dbfilterindex            DBFilterIndex
#define dbflushindex             DBFlushIndex
#define dbgetalltaginfo          DBGetAllTagInfo
#define dbgetcurrentkey          DBGetCurrentKey
#define dbgetindexheader         DBGetIndexHeader
#define dbgetindexinfo           DBGetIndexInfo
#define dbgetindexkeyexpr        DBGetIndexKeyExpr
#define dbgetkeyatpercent        DBGetKeyAtPercent
#define dbgetkeypercent          DBGetKeyPercent
#define dbgetpagecachesize       DBGetPageCacheSize
#define dbsetpagecachesize       DBSetPageCacheSize
#define dbgettaginfo             DBGetTagInfo
#define dbgofirstkey             DBGoFirstKey
#define dbgolastkey              DBGoLastKey
#define dbgonextkey              DBGoNextKey
#define dbgopreviouskey          DBGoPreviousKey
#define dbinsertkey              DBInsertKey
#define dbkeysearch              DBKeySearch
#define dbkeytobitfield          DBKeyToBitField
#define dbkeytocounter           DBKeyToCounter
#define dbkeytodate              DBKeyToDate
#define dbkeytodouble            DBKeyToDouble
#define dbkeytofloat             DBKeyToFloat
#define dbkeytolong              DBKeyToLong
#define dbkeytonumeric           DBKeyToNumeric
#define dbkeytoshort             DBKeyToShort
#define dbkeytopackeddate        DBKeyToPackedDate
#define dbkeytopackedtime        DBKeyToPackedTime
#define dbkeytounsignedlong      DBKeyToUnsignedLong
#define dbkeytounsignedshort     DBKeyToUnsignedShort
#define dbkeytocounter           DBKeyToCounter
#define dblockindex              DBLockIndex
#define dblogicaltokey           DBLogicalToKey
#define dbcountertokey           DBCounterToKey
#define dblongtokey              DBLongToKey
#define dbmakekey                DBMakeKey
#define dbnumerictokey           DBNumericToKey
#define dbopenindex              DBOpenIndex
#define dbopennamedtag           DBOpenNamedTag
#define dbopentag                DBOpenTag
#define dbpackeddatetokey        DBPackedDateToKey
#define dbpackedtimetokey        DBPackedTimeToKey
#define dbsetdefaultkeytype      DBSetDefaultKeyType
#define dbshorttokey             DBShortToKey
#define dbunlockindex            DBUnLockIndex
#define dbunsignedlongtokey      DBUnsignedLongToKey
#define dbunsignedshorttokey     DBUnsignedShortToKey
#define dbzapindex               DBZapIndex

#define DBAllocateMemory SCAllocateMemory
#define DBConvertDateStr SCConvertDateStr
#define DBDate3ToLong    SCDate3ToLong
#define DBDate3ToPacked  SCDate3ToPacked
#define DBDate3ToStr     SCDate3ToStr
#define DBDayOfWeek      SCDayOfWeek
#define DBDaysBetweenStr SCDaysBetweenStr
#define DBDaysInMonth    SCDaysInMonth
#define DBDaysInMonthStr SCDaysInMonthStr
#define DBErrorLog       SCErrorLog
#define DBFreeMemory     SCFreeMemory
#define DBGetDate3       SCGetDate3
#define DBGetDateStr     SCGetDateStr
#define DBGetDefaultDateStyle SCGetDefaultDateStyle
#define DBGetErrorCode   SCGetErrorCode
#define DBGetLockCount   SCGetLockCount
#define DBGetLockRetryCount SCGetLockRetryCount
#define DBGetTime3       SCGetTime3
#define DBGetTimeStr     SCGetTimeStr
#define DBInitialize     SCInitialize
#define DBIsLeapYear     SCIsLeapYear
#define DBIsStrLeapYear  SCIsStrLeapYear
#define DBIsValidDateStr SCIsValidDateStr
#define DBIsValidTimeStr SCIsValidTimeStr
#define DBLongDateTo3    SCLongDateTo3
#define DBLongDateToDayOfWeek SCLongDateToDayOfWeek
#define DBLongDateToStr  SCLongDateToStr
#define DBMonthToStr     SCMonthToStr
#define DBPackedDateTo3  SCPackedDateTo3
#define DBPackedTimeTo3  SCPackedTimeTo3
#define DBReAllocateMemory SCReAllocateMemory
#define DBSecondsBetweenStr SCSecondsBetweenStr
#define DBSetDefaultDateStyle SCSetDefaultDateStyle
#define DBSetErrorCode   SCSetErrorCode
#define DBSetLockCount   SCSetLockCount
#define DBSetLockRetryCount SCSetLockRetryCount
#define DBStrDateTo3     SCStrDateTo3
#define DBStrDateToDayOfWeek SCStrDateToDayOfWeek
#define DBStrDateToIntDayWeek SCStrDateToIntDayWeek
#define DBStrDateToLong  SCStrDateToLong
#define DBStrDateToMonth SCStrDateToMonth
#define DBstricmp        SCstricmp
#define DBStrTimeTo3     SCStrTimeTo3
#define DBTerminate      SCTerminate
#define DBTime3ToPacked  SCTime3ToPacked
#define DBTime3ToStr     SCTime3ToStr

/************************[ structure defintions ]************************/
/**************************[ type definitions ]**************************/
#ifdef ANSI_PROTOTYPES
typedef DBINT (*DBPFLI)(DBLONG, DBINT);
typedef DBINT (*DBPFL)(DBLONG);
#else
typedef DBINT (*DBPFLI)();
typedef DBINT (*DBPFL)();
#endif

typedef struct {  /* file open bit fields */
  DBUINT isreadonly:1;    /* read only    - or - read/write (default)   */
  DBUINT isshareable:1;   /* shared       - or - single (default)       */
  DBUINT isunbuffered:1;  /* no buffering - or - auto buffer (default)  */
  DBUINT filler:13;
} DBOPENFLAGS;

typedef struct {  /* database field description */
  DBCHAR name[12];    /* field name */
  DBINT type;         /* field type */
  DBINT len;          /* field width */
  DBINT decpl;        /* decimal count */
} DBFIELD;

typedef struct {  /* database lock(s) description */
  DBINT type;         /* type of lock (SC_DFILLCK, SC_DHDRLCK, SC_DRECLCK) */
  DBLONG record;      /* record number (0 if SC_DFILLCK or SC_DHDRLCK) */
} DBFILELOCKS;

typedef struct {  /* dBASE data file information packet */
  DBOPENFLAGS flags;   /* miscellaneous flags */
  DBCHAR fname[80];    /* file name */
  DBINT style;         /* file type */
  DBINT memo;          /* memo file required */
  DBINT mdx;           /* production index file required (true or false) */
  DBINT trans;         /* transaction in process (true or false) */
  DBINT encrypt;       /* data file encrypted (true or false) */
  DBINT lockt;         /* record/file/no lock */
  DBINT numlcks;       /* number of locks applied */
} DBFILEINFO;

typedef struct {  /* dBASE data file record information packet */
  DBINT reclen;     /* record length in bytes */
  DBINT numflds;    /* number of fields in record */
  DBCHARP bfr;      /* address of the record buffer */
} DBRECINFO;

typedef struct {
   DBCHARP eval;    /* expression value */
   DBSHORT etyp;    /* type */
   DBSHORT elen;    /* length */
} DBEVAL;

typedef struct {  /* dBASE memo file information packet */
  DBOPENFLAGS flags; /* miscellaneous flags */
  DBCHAR fname[80]; /* file name */
  DBINT lockt;      /* file lock/unlock flag */
  DBINT blksz;      /* memo block size in bytes */
  DBINT style;      /* file type */
} DBMEMOINFO;

#ifdef DB_V400
#ifdef DBASE_ENABLE
typedef struct {  /* dBASE III+ index file information packet */
  DBCHAR fname[80]; /* file name */
  DBOPENFLAGS flags; /* miscellaneous flags */
  DBINT keylen;     /* key length */
  DBINT keytype;    /* key type */
  DBUINT keyfmt;    /* unique, descending, etc. */
  DBINT keydpl;     /* number of decimal places in numeric keys */
  DBINT lockt;      /* file lock/unlock flag */
  DBINT exprlen;    /* key expression length */
  DBCHAR expr[100]; /* first 100 characters of index expression */
} DBD3INDEXINFO;
typedef DBD3INDEXINFO SC_FAR_POINTER DBD3INDEXINFOP;
#endif

#ifdef CLIPPER_ENABLE
typedef struct {  /* Clipper index file information packet */
  DBCHAR fname[80]; /* file name */
  DBOPENFLAGS flags; /* miscellaneous flags */
  DBINT keylen;     /* key length */
  DBINT keytype;    /* key type */
  DBUINT keyfmt;    /* unique, descending, etc. */
  DBINT keydpl;     /* number of decimal places in numeric keys */
  DBINT lockt;      /* file lock/unlock flag */
  DBINT exprlen;    /* key expression length */
  DBCHAR expr[100]; /* first 100 characters of index expression */
} DBCLINDEXINFO;
typedef DBCLINDEXINFO SC_FAR_POINTER DBCLINDEXINFOP;
#endif

#ifdef FOX_ENABLE
typedef struct {  /* FoxBase index file information packet */
  DBCHAR fname[80]; /* file name */
  DBOPENFLAGS flags; /* miscellaneous flags */
  DBINT ftype;      /* file type */
  DBINT keylen;     /* key length */
  DBINT keytype;    /* key type */
  DBUINT keyfmt;    /* unique, descending, etc. */
  DBINT keydpl;     /* number of decimal places in numeric keys */
  DBINT lockt;      /* file lock/unlock flag */
  DBINT exprlen;    /* key expression length */
  DBCHAR expr[100]; /* first 100 characters of index expression */
} DBFBINDEXINFO;
typedef DBFBINDEXINFO SC_FAR_POINTER DBFBINDEXINFOP;
#endif
#endif

typedef struct {  /* index file information packet */
  DBINT usedtags;   /* number of tags in use */
  DBINT ftype;      /* index file type */
  DBOPENFLAGS flags; /* miscellaneous flags */
  DBCHAR fname[80]; /* index file name */
  DBINT lockt;      /* file lock/unlock flag */
} DBINDEXINFO;

typedef struct {  /* tag information packet */
  DBCHAR tname[12]; /* tag name */
  DBINT keylen;     /* key length */
  DBINT keydpl;     /* number of decimal digits in key */
  DBINT keytype;    /* key type ('C' Character, 'D' Date, 'N' Numeric) */
  DBUINT keyfmt;    /* unique, descend, etc. */
  DBINT exprlen;    /* key expression length */
  DBCHAR expr[100]; /* first 100 characters of the index expression */
  DBINT forlen;     /* for expression length */
  DBCHAR filter[100]; /* first 100 characters of the for expression */
} DBTAGINFO;

/*************************[ class definitions ]**************************/
/************************[ variable definitions ]************************/
/************************[ external declarations ]***********************/
/*************************[ function prototypes ]************************/
#ifdef ANSI_PROTOTYPES
#ifdef __cplusplus
extern "C" {
#endif

/* Function Prototypes */
DBINTF DBAddKey( CONST DBLONG, CONST DBVOIDP, CONST DBLONG );
DBINTF DBBuildTag( CONST DBINT, CONST DBINT, CONST DBCHARP, CONST DBINT, CONST DBCHARP, CONST DBINT, CONST DBINT, CONST DBCHARP, DBPFLI, CONST DBINT);
DBINTF DBClearBuffer( CONST DBINT );
DBINTF DBCloseFile( CONST DBINT );
DBINTF DBCloseMemo( CONST DBINT );
DBINTF DBCloseIndex( CONST DBINT );
DBINTF DBCloseTag( CONST DBLONG );
DBINTF DBCounterToKey( CONST DBLONG, DBCHARP, CONST DBLONG );
DBINTF DBCreateFile( CONST DBCHARP, CONST DBINT, CONST DBFIELDP, CONST DBINT );
DBINTF DBCreateIndex( CONST DBCHARP, CONST DBINT, CONST DBINT );
DBINTF DBCreateMemo( CONST DBCHARP, CONST DBINT, CONST DBINT );
DBINTF DBCreateTag( CONST DBINT, CONST DBCHARP, CONST DBINT, CONST DBCHARP, CONST DBINT, CONST DBINT, CONST DBCHARP );
DBINTF DBDateToKey( CONST DBLONG, DBCHARP, CONST DBCHARP, CONST DBINT );
DBINTF DBDeleteKey( CONST DBLONG, CONST DBVOIDP, CONST DBLONG );
DBINTF DBDeleteTag( CONST DBINT, CONST DBCHARP );
DBULONGF DBDetermineXBaseType( CONST DBCHARP, CONST DBCHARP, CONST DBCHARP );
DBINTF DBDoubleToKey( CONST DBLONG, DBCHARP, CONST DBDOUBLE);
DBINTF DBEvaluateStr( CONST DBINT, CONST DBCHARP, DBEVALP );
DBINTF DBFilterIndex( CONST DBINT, CONST DBLONG );
DBINTF DBFilterRecord( CONST DBINT );
DBINTF DBFloatToKey( CONST DBLONG, DBCHARP, CONST DBFLOAT);
DBINTF DBFlushIndex( CONST DBLONG );
DBINTF DBFlushFile( CONST DBINT );
DBINTF DBGetAllTagInfo( CONST DBINT, DBINTP, DBTAGINFOPP);
DBINTF DBGetCurrentKey( CONST DBLONG, DBVOIDP, DBLONGP );
DBCHARPF DBGetErrorStr( DBVOID );
DBINTF DBGetFieldBinary( CONST DBINT, CONST DBINT, DBVOIDP );
DBINTF DBGetFieldData( CONST DBINT, CONST DBINT, DBVOIDP );
DBINTF DBGetFieldDescription( CONST DBINT, CONST DBINT, DBFIELDP);
DBINTF DBGetFieldName( CONST DBINT, DBCHARP, CONST DBINT );
DBINTF DBGetFieldNumber( CONST DBINT, DBINTP, CONST DBCHARP);
DBINTF DBGetFieldStr( CONST DBINT, CONST DBINT, DBCHARP );
DBINTF DBGetFileDescription( CONST DBINT, DBINTP, DBFIELDP);
DBINTF DBGetFileInfo( CONST DBINT, DBFILEINFOP );
DBINTF DBGetIndexHeader( CONST DBLONG );
DBINTF DBGetIndexInfo( CONST DBINT, DBINDEXINFOP);
DBINTF DBGetIndexKeyExpr( CONST DBLONG, DBCHARP );
DBINTF DBGetKeyAtPercent( CONST DBLONG, CONST DBINT, DBVOIDP, DBLONGP );
DBINTF DBGetKeyPercent( CONST DBLONG, DBINTP, CONST DBVOIDP, CONST DBLONG );
DBINTF DBGetLastUpdate( CONST DBINT, DBCHARP, CONST DBINT );
DBINTF DBGetLockInfo( CONST DBINT, DBFILELOCKSPP, DBINTP );
DBINTF DBGetMemoInfo( CONST DBINT, DBMEMOINFOP );
DBINTF DBGetMemoRecord( CONST DBINT, CONST DBLONG, DBCHARPP, CONST DBLONG, CONST DBINT );
DBINTF DBGetMemoToBuffer( CONST DBINT, CONST DBLONG, DBVOIDP, CONST DBLONG, CONST DBINT );
DBINTF DBGetMemoType( CONST DBINT, CONST DBLONG, DBLONGP, DBINTP );
DBINTF DBGetNamedBinary( CONST DBINT, CONST DBCHARP, DBVOIDP );
DBINTF DBGetNamedData( CONST DBINT, CONST DBCHARP, DBVOIDP );
DBINTF DBGetNamedStr( CONST DBINT, CONST DBCHARP, DBCHARP );
DBINTF DBGetPageCacheSize( CONST DBINT, DBINTP );
DBINTF DBSetPageCacheSize( CONST DBINT, CONST DBINT );
DBINTF DBGetRecord( CONST DBINT, CONST DBLONG );
DBINTF DBGetRecordCount( CONST DBINT, DBLONGP );
DBINTF DBGetRecordInfo( CONST DBINT, DBRECINFOP );
DBINTF DBGetRecordNumber( CONST DBINT, DBLONGP );
DBINTF DBGetRecordToBuffer( CONST DBINT, DBVOIDP, CONST DBLONG );
DBINTF DBGetRecordCacheSize( CONST DBINT, DBINTP );
DBINTF DBSetRecordCacheSize( CONST DBINT, CONST DBINT );
DBINTF DBGetTagInfo( CONST DBLONG, DBTAGINFOP );
DBINTF DBGetVersion( DBCHARP );
DBINTF DBGoFirstKey( CONST DBLONG, DBVOIDP, DBLONGP );
DBINTF DBGoLastKey( CONST DBLONG, DBVOIDP, DBLONGP );
DBINTF DBGoNextKey( CONST DBLONG, DBVOIDP, DBLONGP );
DBINTF DBGoPreviousKey( CONST DBLONG, DBVOIDP, DBLONGP );
DBINTF DBIsBeginningOfFile( CONST DBINT );
DBINTF DBIsEndOfFile( CONST DBINT );
DBINTF DBInsertKey( CONST DBLONG, CONST DBVOIDP, CONST DBLONG );
DBINTF DBIsFieldBlank( CONST DBINT, CONST DBINT );
DBINTF DBIsNamedBlank( CONST DBINT, CONST DBCHARP );
DBINTF DBIsRecordDeleted( CONST DBINT );
DBINTF DBIsRecordLocked( CONST DBINT, CONST DBLONG );
DBINTF DBKeySearch( CONST DBLONG, DBVOIDP, DBLONGP, CONST DBINT );
DBINTF DBKeyToBitField( CONST DBLONG, DBUSHORTP, CONST DBCHARP );
DBINTF DBKeyToCounter( CONST DBLONG, DBLONGP, CONST DBCHARP );
DBINTF DBKeyToDate( CONST DBLONG, DBCHARP, CONST DBINT, CONST DBCHARP );
DBINTF DBKeyToDouble( CONST DBLONG, DBDOUBLEP, CONST DBCHARP );
DBINTF DBKeyToFloat( CONST DBLONG, DBFLOATP, CONST DBCHARP );
DBINTF DBKeyToLogical( CONST DBLONG, DBINTP, CONST DBCHARP );
DBINTF DBKeyToLong( CONST DBLONG, DBLONGP, CONST DBCHARP );
DBINTF DBKeyToNumeric( CONST DBLONG, DBDOUBLEP, CONST DBCHARP );
DBINTF DBKeyToShort( CONST DBLONG, DBSHORTP, CONST DBCHARP );
DBINTF DBKeyToUnsignedLong( CONST DBLONG, DBULONGP, CONST DBCHARP );
DBINTF DBKeyToUnsignedShort( CONST DBLONG, DBUSHORTP, CONST DBCHARP );
DBINTF DBKeyToPackedDate( CONST DBLONG, DBUSHORTP, CONST DBCHARP );
DBINTF DBKeyToPackedTime( CONST DBLONG, DBUSHORTP, CONST DBCHARP );
DBINTF DBLockFile( CONST DBINT );
DBINTF DBLockHeader( CONST DBINT );
DBINTF DBLockIndex( CONST DBINT );
DBINTF DBLockMemo( CONST DBINT );
DBINTF DBLockRecord( CONST DBINT, CONST DBLONG );
DBINTF DBLogicalToKey( CONST DBLONG, DBCHARP, CONST DBINT );
DBINTF DBLongToKey( CONST DBLONG, DBCHARP, CONST DBLONG);
DBINTF DBMakeKey( CONST DBINT, CONST DBLONG, DBVOIDPP );
DBINTF DBMarkRecordActive( CONST DBINT, CONST DBLONG );
DBINTF DBMarkRecordInActive( CONST DBINT, CONST DBLONG );
DBINTF DBNumericToKey( CONST DBLONG, DBCHARP, CONST DBDOUBLE);
DBINTF DBOpenFile( DBINTP, CONST DBCHARP, CONST DBINT );
DBINTF DBOpenIndex( DBINTP, CONST DBCHARP, CONST DBINT );
DBINTF DBOpenMemo( DBINTP, CONST DBCHARP, CONST DBINT );
DBINTF DBOpenNamedTag( DBLONGP, CONST DBINT, CONST DBCHARP);
DBINTF DBOpenTag( DBLONGP, CONST DBINT, CONST DBINT);
DBINTF DBPackedDateToKey( CONST DBLONG, DBCHARP, CONST DBUSHORT);
DBINTF DBPackedTimeToKey( CONST DBLONG, DBCHARP, CONST DBUSHORT);
DBINTF DBPackFile( DBINTP, DBPFLI, CONST DBINT );
DBINTF DBPackMemo( CONST DBINT, DBINTP, DBPFLI, CONST DBINT );
DBINTF DBPutFieldBinary( CONST DBINT, CONST DBINT, CONST DBVOIDP );
DBINTF DBPutFieldData( CONST DBINT, CONST DBINT, CONST DBVOIDP );
DBINTF DBPutMemoRecord( CONST DBINT, DBLONGP, CONST DBVOIDP, CONST DBLONG, CONST DBLONG, CONST DBINT );
DBINTF DBPutNamedBinary( CONST DBINT, CONST DBCHARP, CONST DBVOIDP );
DBINTF DBPutNamedData( CONST DBINT, CONST DBCHARP, CONST DBVOIDP );
DBINTF DBPutNamedStr( CONST DBINT, CONST DBCHARP, CONST DBCHARP );
DBINTF DBPutRecord( CONST DBINT, DBLONGP, CONST DBINT );
DBINTF DBPutRecordFromBuffer( CONST DBINT, CONST DBVOIDP, DBLONGP, CONST DBINT );
DBINTF DBPutFieldStr( CONST DBINT, CONST DBINT, CONST DBCHARP );
DBINTF DBReSetProductionIndex( CONST DBINT );
DBINTF DBSecondsBetweenStr( DBLONGP, CONST DBCHARP, CONST DBINT, CONST DBCHARP, CONST DBINT );
DBINTF DBSetBufferAddress( CONST DBINT, CONST DBCHARP );
DBINTF DBSetDefaultKeyType( CONST DBLONG, CONST DBINT );
DBINTF DBSetFieldIndexed( CONST DBINT, CONST DBINT );
DBINTF DBSetFilter( CONST DBINT, CONST DBCHARP );
DBINTF DBSetProductionIndex( CONST DBINT );
DBINTF DBShortToKey( CONST DBLONG, DBCHARP, CONST DBSHORT);
DBCHARPF DBSoundex( CONST DBCHARP );
DBINTF DBUnLockAll( CONST DBINT );
DBINTF DBUnLockHeader( CONST DBINT );
DBINTF DBUnLockIndex( CONST DBINT );
DBINTF DBUnLockMemo( CONST DBINT );
DBINTF DBUnLockRecord( CONST DBINT, CONST DBLONG );
DBINTF DBUnsignedLongToKey( CONST DBLONG, DBCHARP, CONST DBULONG);
DBINTF DBUnsignedShortToKey( CONST DBLONG, DBCHARP, CONST DBUSHORT);
DBINTF DBZapFile( CONST DBINT );
DBINTF DBZapIndex( CONST DBINT );
DBINTF DBZapMemo( CONST DBINT );

#ifndef __STRCMPI_DEF__
  DBINT DBstricmp( DBCHARP, DBCHARP );
#endif

#ifdef DB_V400
DBINTF DBxbCloseMemo( DBINT );
DBINTF DBxbCreateMemo( DBCHARP, DBINT, DBINT );
DBINTF DBxbGetMemoInfo( DBINT, DBMEMOINFOP );
DBINTF DBxbGetMemoRecord( DBINT, DBLONG, DBCHARPP, DBINT );
DBINTF DBxbLockMemo( DBINT );
DBINTF DBxbOpenMemo( DBINTP, DBCHARP, DBINT );
DBINTF DBxbPackMemo( DBINT, DBINTP);
DBINTF DBxbPutMemoRecord( DBINT, DBLONGP, DBCHARP, DBINT );
DBINTF DBxbUnLockMemo( DBINT );
DBINTF DBxbZapMemo( DBINT );

DBINTF DBfpCloseMemo( DBINT );
DBINTF DBfpCreateMemo( DBCHARP, DBINT );
DBINTF DBfpGetMemoInfo( DBINT, DBMEMOINFOP );
DBINTF DBfpGetMemoRecord( DBINT, DBLONG, DBCHARPP, DBLONG, DBINT );
DBINTF DBfpGetMemoToBuffer( DBINT, DBLONG, DBVOIDP, DBLONG, DBINT );
DBINTF DBfpGetMemoType( DBINT, DBLONG, DBLONGP, DBINTP );
DBINTF DBfpLockMemo( DBINT );
DBINTF DBfpOpenMemo( DBINTP, DBCHARP, DBINT );
DBINTF DBfpPackMemo( DBINT, DBINTP);
DBINTF DBfpPutMemoRecord( DBINT, DBLONGP, DBVOIDP, DBLONG, DBLONG, DBINT );
DBINTF DBfpUnLockMemo( DBINT );
DBINTF DBfpZapMemo( DBINT );
DBINTF DBd3GetSetCacheSize( DBINT, DBINTP, DBINT );
DBINTF DBd3CloseIndex( DBINT );
DBINTF DBd3CreateIndex( DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBd3GetIndexKeyExpr( DBINT, DBCHARP );
DBINTF DBd3FlushIndex( DBINT );
DBINTF DBd3GetIndexHeader( DBINT );
DBINTF DBd3BuildIndex( DBINT, DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBd3GetIndexInfo( DBINT, DBD3INDEXINFO SC_FAR_POINTER );
DBINTF DBd3LockIndex( DBINT );
DBINTF DBd3OpenIndex( DBINTP, DBCHARP, DBINT );
DBINTF DBd3UnLockIndex( DBINT );
DBINTF DBd3KeyToDate( DBCHARP, DBINT, DBCHARP );
DBINTF DBd3KeyToNumeric( DBDOUBLEP, DBCHARP );
DBINTF DBd3DateToKey( DBCHARP, DBCHARP, DBINT );
DBINTF DBd3MakeKey( DBINT, DBINT, DBVOIDPP);
DBINTF DBd3NumericToKey( DBCHARP, DBDOUBLE );
DBINTF DBd3GetKeyPercent( DBINT, DBINTP, DBVOIDP, DBLONG );
DBINTF DBd3GetKeyAtPercent( DBINT, DBINT, DBVOIDP, DBLONGP );
DBINTF DBd3AddKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBd3InsertKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBd3GoLastKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBd3GetCurrentKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBd3DeleteKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBd3KeySearch( DBINT, DBVOIDP, DBLONGP, DBINT);
DBINTF DBd3GoNextKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBd3GoPreviousKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBd3GoFirstKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBd3ZapIndex( DBINT );

DBINTF DBd4CloseIndex( DBINT );
DBINTF DBd4CreateIndex( DBCHARP, DBINT, DBINT );
DBINTF DBd4GetIndexInfo( DBINT, DBD4INDEXINFOP);
DBINTF DBd4LockIndex( DBINT );
DBINTF DBd4OpenIndex( DBINTP, DBCHARP, DBINT );
DBINTF DBd4UnLockIndex( DBINT );
DBINTF DBd4GetSetCacheSize( DBLONG, DBINTP, DBINT );
DBINTF DBd4CloseTag( DBLONG );
DBINTF DBd4DeleteTag( DBINT, DBCHARP );
DBINTF DBd4GetIndexKeyExpr( DBLONG, DBCHARP );
DBINTF DBd4FlushIndex( DBLONG );
DBINTF DBd4GetIndexHeader( DBLONG );
DBINTF DBd4BuildIndex( DBINT, DBINT, DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBd4GetTagInfo( DBLONG, DBD4TAGINFOP );
DBINTF DBd4GetAllTagInfo( DBINT, DBINTP, DBD4TAGINFOPP);
DBINTF DBd4CreateTag( DBINT, DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBd4OpenNamedTag( DBLONGP, DBINT, DBCHARP);
DBINTF DBd4OpenTag( DBLONGP, DBINT, DBINT);
DBINTF DBd4KeyToDate( DBCHARP, DBINT, DBCHARP );
DBINTF DBd4KeyToNumeric( DBDOUBLEP, DBCHARP );
DBINTF DBd4KeyToDouble( DBDOUBLEP, DBCHARP );
DBINTF DBd4KeyToFloat( DBFLOATP, DBCHARP );
DBINTF DBd4KeyToLong( DBLONGP, DBCHARP );
DBINTF DBd4KeyToUnsignedLong( DBULONGP, DBCHARP );
DBINTF DBd4KeyToShort( DBSHORTP, DBCHARP );
DBINTF DBd4KeyToUnsignedShort( DBUSHORTP, DBCHARP );
DBINTF DBd4DateToKey( DBCHARP, DBCHARP, DBINT );
DBINTF DBd4MakeKey( DBINT, DBLONG, DBVOIDPP );
DBINTF DBd4NumericToKey( DBCHARP, DBDOUBLE);
DBINTF DBd4DoubleToKey( DBCHARP, DBDOUBLE);
DBINTF DBd4FloatToKey( DBCHARP, DBFLOAT);
DBINTF DBd4LongToKey( DBCHARP, DBLONG);
DBINTF DBd4UnsignedLongToKey( DBCHARP, DBULONG);
DBINTF DBd4ShortToKey( DBCHARP, DBSHORT);
DBINTF DBd4UnsignedShortToKey( DBCHARP, DBUSHORT);
DBINTF DBd4GetKeyPercent( DBLONG, DBINTP, DBVOIDP, DBLONG );
DBINTF DBd4GetKeyAtPercent( DBLONG, DBINT, DBVOIDP, DBLONGP );
DBINTF DBd4AddKey( DBLONG, DBVOIDP, DBLONG );
DBINTF DBd4InsertKey( DBLONG, DBVOIDP, DBLONG );
DBINTF DBd4GetCurrentKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBd4DeleteKey( DBLONG, DBVOIDP, DBLONG );
DBINTF DBd4KeySearch( DBLONG, DBVOIDP, DBLONGP, DBINT );
DBINTF DBd4GoLastKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBd4GoNextKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBd4GoPreviousKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBd4GoFirstKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBd4ZapIndex( DBINT );

DBINTF DBclGetSetCacheSize( DBINT, DBINTP, DBINT );
DBINTF DBclCloseIndex( DBINT );
DBINTF DBclCreateIndex( DBCHARP, DBINT, DBCHARP, DBINT, DBINT );
DBINTF DBclGetIndexKeyExpr( DBINT, DBCHARP );
DBINTF DBclFlushIndex( DBINT );
DBINTF DBclGetIndexHeader( DBINT );
DBINTF DBclBuildIndex( DBINT, DBCHARP, DBINT, DBCHARP, DBINT, DBINT );
DBINTF DBclGetIndexInfo( DBINT, DBCLINDEXINFO SC_FAR_POINTER );
DBINTF DBclLockIndex( DBINT );
DBINTF DBclOpenIndex( DBINTP, DBCHARP, DBINT );
DBINTF DBclUnLockIndex( DBINT );
DBINTF DBclKeyToDate( DBCHARP, DBINT, DBCHARP );
DBINTF DBclKeyToDouble( DBDOUBLEP, DBCHARP );
DBINTF DBclKeyToNumeric( DBDOUBLEP, DBCHARP );
DBINTF DBclKeyToFloat( DBFLOATP, DBCHARP );
DBINTF DBclKeyToLong( DBLONGP, DBCHARP );
DBINTF DBclKeyToShort( DBSHORTP, DBCHARP );
DBINTF DBclKeyToUnsignedLong( DBULONGP, DBCHARP );
DBINTF DBclKeyToUnsignedShort( DBUSHORTP, DBCHARP );
DBINTF DBclDateToKey( DBCHARP, DBCHARP, DBINT );
DBINTF DBclMakeKey( DBINT, DBINT, DBVOIDPP);
DBINTF DBclNumericToKey( DBINT, DBCHARP, DBDOUBLE );
DBINTF DBclDoubleToKey( DBCHARP, DBDOUBLE );
DBINTF DBclFloatToKey( DBCHARP, DBFLOAT);
DBINTF DBclLongToKey( DBCHARP, DBLONG);
DBINTF DBclShortToKey( DBCHARP, DBSHORT);
DBINTF DBclUnsignedLongToKey( DBCHARP, DBULONG);
DBINTF DBclUnsignedShortToKey( DBCHARP, DBUSHORT);
DBINTF DBclGetKeyPercent( DBINT, DBINTP, DBVOIDP, DBLONG );
DBINTF DBclGetKeyAtPercent( DBINT, DBINT, DBVOIDP, DBLONGP );
DBINTF DBclAddKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBclInsertKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBclGoLastKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBclGetCurrentKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBclDeleteKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBclKeySearch( DBINT, DBVOIDP, DBLONGP, DBINT);
DBINTF DBclGoNextKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBclGoPreviousKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBclGoFirstKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBclZapIndex( DBINT );

DBINTF DBfbGetSetCacheSize( DBINT, DBINTP, DBINT );
DBINTF DBfbCloseIndex( DBINT );
DBINTF DBfbCreateIndex( DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBfbGetIndexKeyExpr( DBINT, DBCHARP );
DBINTF DBfbFlushIndex( DBINT );
DBINTF DBfbGetIndexHeader( DBINT );
DBINTF DBfbBuildIndex( DBINT, DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBfbGetIndexInfo( DBINT, DBFBINDEXINFO SC_FAR_POINTER );
DBINTF DBfbLockIndex( DBINT );
DBINTF DBfbOpenIndex( DBINTP, DBCHARP, DBINT );
DBINTF DBfbUnLockIndex( DBINT );
DBINTF DBfbKeyToDate( DBCHARP, DBINT, DBCHARP );
DBINTF DBfbKeyToDouble( DBDOUBLEP, DBCHARP );
DBINTF DBfbKeyToNumeric( DBDOUBLEP, DBCHARP );
DBINTF DBfbDateToKey( DBCHARP, DBCHARP, DBINT );
DBINTF DBfbMakeKey( DBINT, DBINT, DBVOIDPP);
DBINTF DBfbNumericToKey( DBCHARP, DBDOUBLE );
DBINTF DBfbGetKeyPercent( DBINT, DBINTP, DBVOIDP, DBLONG );
DBINTF DBfbGetKeyAtPercent( DBINT, DBINT, DBVOIDP, DBLONGP );
DBINTF DBfbAddKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBfbInsertKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBfbGoLastKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBfbGetCurrentKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBfbDeleteKey( DBINT, DBVOIDP, DBLONG );
DBINTF DBfbKeySearch( DBINT, DBVOIDP, DBLONGP, DBINT);
DBINTF DBfbGoNextKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBfbGoPreviousKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBfbGoFirstKey( DBINT, DBVOIDP, DBLONGP);
DBINTF DBfbSetDefaultKeyType( DBINT, DBINT );
DBINTF DBfbZapIndex( DBINT );
DBINTF DBfbGetRecordNumber( DBINT, DBLONGP, DBINT, DBVOIDP );

DBINTF DBfpGetSetCacheSize( DBLONG, DBINTP, DBINT );
DBINTF DBfpCloseIndex( DBINT );
DBINTF DBfpCreateIndex( DBCHARP );
DBINTF DBfpGetIndexKeyExpr( DBLONG, DBCHARP );
DBINTF DBfpFlushIndex( DBLONG );
DBINTF DBfpGetIndexHeader( DBLONG );
DBINTF DBfpBuildIndex( DBINT, DBINT, DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBfpGetIndexInfo( DBINT, DBFPINDEXINFOP);
DBINTF DBfpKeyToDate( DBCHARP, DBINT, DBCHARP );
DBINTF DBfpKeyToNumeric( DBDOUBLEP, DBCHARP );
DBINTF DBfpKeyToDouble( DBDOUBLEP, DBCHARP );
DBINTF DBfpKeyToFloat( DBFLOATP, DBCHARP );
DBINTF DBfpKeyToLong( DBLONGP, DBCHARP );
DBINTF DBfpKeyToShort( DBSHORTP, DBCHARP );
DBINTF DBfpKeyToUnsignedLong( DBULONGP, DBCHARP );
DBINTF DBfpKeyToUnsignedShort( DBUSHORTP, DBCHARP );
DBINTF DBfpGetKeyPercent( DBLONG, DBINTP, DBVOIDP, DBLONG );
DBINTF DBfpGetKeyAtPercent( DBLONG, DBINT, DBVOIDP, DBLONGP );
DBINTF DBfpAddKey( DBLONG, DBVOIDP, DBLONG );
DBINTF DBfpInsertKey( DBLONG, DBVOIDP, DBLONG );
DBINTF DBfpGoLastKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBfpGetCurrentKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBfpDateToKey( DBCHARP, DBCHARP, DBINT );
DBINTF DBfpDeleteKey( DBLONG, DBVOIDP, DBLONG );
DBINTF DBfpKeySearch( DBLONG, DBVOIDP, DBLONGP, DBINT );
DBINTF DBfpMakeKey( DBINT, DBLONG, DBVOIDPP );
DBINTF DBfpGoNextKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBfpNumericToKey( DBCHARP, DBDOUBLE);
DBINTF DBfpDoubleToKey( DBCHARP, DBDOUBLE);
DBINTF DBfpFloatToKey( DBCHARP, DBFLOAT);
DBINTF DBfpLongToKey( DBCHARP, DBLONG);
DBINTF DBfpShortToKey( DBCHARP, DBSHORT);
DBINTF DBfpUnsignedLongToKey( DBCHARP, DBULONG);
DBINTF DBfpUnsignedShortToKey( DBCHARP, DBUSHORT);
DBINTF DBfpGoPreviousKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBfpGoFirstKey( DBLONG, DBVOIDP, DBLONGP );
DBINTF DBfpSetDefaultKeyType( DBLONG, DBINT );
DBINTF DBfpLockIndex( DBINT );
DBINTF DBfpOpenIndex( DBINTP, DBCHARP, DBINT );
DBINTF DBfpCloseTag( DBLONG );
DBINTF DBfpDeleteTag( DBINT, DBCHARP );
DBINTF DBfpGetTagInfo( DBLONG, DBFPTAGINFOP );
DBINTF DBfpGetAllTagInfo( DBINT, DBINTP, DBFPTAGINFOPP);
DBINTF DBfpCreateTag( DBINT, DBCHARP, DBINT, DBCHARP, DBINT );
DBINTF DBfpOpenTag( DBLONGP, DBINT, DBINT);
DBINTF DBfpOpenNamedTag( DBLONGP, DBINT, DBCHARP);
DBINTF DBfpUnLockIndex( DBINT );
DBINTF DBfpZapIndex( DBINT );
DBINTF DBfpGetRecordNumber( DBINT, DBLONGP, DBLONG, DBVOIDP );
#endif

#ifdef __cplusplus
}
#endif
#endif

#endif



