/*
** EXAMP097.C
**
** The SoftC Database Library
**
** Copyright (C) 1989, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
unsigned long ulLong, ulKey;
char szKey[8];

DBFIELD aField[] = { { "SIZE", DBULONGFIELD, 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "SIZE", DBULONGKEY, "SIZE", 7, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   ulLong=2000;
   DBPutFieldData( iDBF, 0, &ulLong );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnsignedLongToKey( lTag, szKey, ulLong );
   DBInsertKey( lTag, szKey, lRecNo );
   ulLong=1000;
   DBPutFieldData( iDBF, 0, &ulLong );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnsignedLongToKey( lTag, szKey, ulLong );
   DBInsertKey( lTag, szKey, lRecNo );
   ulLong=3000;
   DBPutFieldData( iDBF, 0, &ulLong );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnsignedLongToKey( lTag, szKey, ulLong );
   DBInsertKey( lTag, szKey, lRecNo );
   ulLong=4000;
   DBPutFieldData( iDBF, 0, &ulLong );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnsignedLongToKey( lTag, szKey, ulLong );
   DBInsertKey( lTag, szKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToUnsignedLong( lTag, &ulKey, szKey );
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, &ulLong );
      printf( "%ld %lu %lu\n", lRecNo, ulKey, ulLong );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
