/*
** EXAMP083.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
DBINDEXINFO pIndexInfo;

DBFIELD aField[] = { { "FILENAME", 'C', 12, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "FILENAME", DBCHARACTERKEY, "FILENAME", 12, 0, NULL );
   DBGetIndexInfo( iMDX, &pIndexInfo );
   printf( "Number of used tags is %d\n", pIndexInfo.usedtags );
   printf( "Is readonly? %s\n", pIndexInfo.flags.isreadonly ? "YES":"NO" );
   printf( "Is shareable? %s\n", pIndexInfo.flags.isshareable ? "YES":"NO" );
   printf( "Is unbuffered? %s\n", pIndexInfo.flags.isunbuffered ? "YES":"NO" );
   printf( "Index filename is %s\n", pIndexInfo.fname );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
