/*
** EXAMP070.C
**
** The SoftC Database Library
**
** Copyright (C) 1989, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lRecsUsed, lTag;

DBFIELD aField[] = { { "FILENAME", 'C', 12, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4 );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "FILENAME", DBCHARACTERKEY, "FILENAME", 12, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   DBPutNamedData( iDBF, "FILENAME", "AUTOEXEC.BAT" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBInsertKey( lTag, "AUTOEXEC.BAT", lRecNo );
   DBPutNamedData( iDBF, "FILENAME", "CONFIG.SYS" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBInsertKey( lTag, "CONFIG.SYS", lRecNo );
   DBGetRecordCount( iDBF, &lRecsUsed );
   printf( "Number of records is %d\n", lRecsUsed );
   DBZapIndex( iMDX );
   DBZapFile( iDBF );
   DBGetRecordCount( iDBF, &lRecsUsed );
   printf( "Number of records is %d", lRecsUsed );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
