/*
** EXAMP066.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1996 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
char *pKey, szKey[21];

DBFIELD aFields[] = { { "FILENAME", 'C', 12, 0 },
                      { "DATE",     'D',  8, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 2, aFields, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBSetProductionIndex( iDBF );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "DATENAME", DBCHARACTERKEY, "DTOC(DATE)+FILENAME", 20, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   DBPutFieldData( iDBF, 0, "AUTOEXEC.BAT" );
   DBPutFieldData( iDBF, 1, "01/15/95" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBMakeKey( iDBF, lTag, ( void** )&pKey );
   DBAddKey( lTag, pKey, lRecNo );
   DBPutFieldData( iDBF, 0, "CONFIG.SYS" );
   DBPutFieldData( iDBF, 1, "01/01/95" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBMakeKey( iDBF, lTag, ( void** )&pKey );
   DBAddKey( lTag, pKey, lRecNo );
   DBPutFieldData( iDBF, 0, "AUTOEXEC.BAT" );
   DBPutFieldData( iDBF, 1, "01/02/95" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBMakeKey( iDBF, lTag, ( void** )&pKey );
   DBAddKey( lTag, pKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "%ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
