/*
** EXAMP035.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dblib.h"

int iDBF;
long lRecNo;
struct { char Status;
         char szCharacter[11];
         char szDate[11];
         double dFloat;
         char cLogical;
         long lMemoRecord;
         double dNumeric;
       } pRecord;

DBFIELD aFields[] = { { "CHARACTER", 'C', 10, 0 },
                      { "DATE",      'D',  8, 0 },
                      { "FLOAT",     'F',  5, 2 },
                      { "LOGICAL",   'L',  1, 0 },
                      { "MEMO",      'M', 10, 0 },
                      { "NUMERIC",   'N',  5, 2 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 6, aFields, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   strcpy( pRecord.szCharacter, "Character" );
   strcpy( pRecord.szDate, "01/01/95" );
   pRecord.dFloat=12.34;
   pRecord.cLogical='T';
   pRecord.lMemoRecord=1L;
   pRecord.dNumeric=45.67;
   DBPutRecordFromBuffer( iDBF, ( char* )&pRecord, &lRecNo, DBAPPENDRECORD );
   DBGetRecordToBuffer( iDBF, ( char* )&pRecord, lRecNo );
   printf( "%s\n", pRecord.szCharacter );
   printf( "%s\n", pRecord.szDate );
   printf( "%5.2f\n", pRecord.dFloat );
   printf( "%s\n", pRecord.cLogical ? "TRUE":"FALSE" );
   printf( "%ld\n", pRecord.lMemoRecord );
   printf( "%5.2f", pRecord.dNumeric );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
