/*
** EXAMP031.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF;
DBFILEINFO pFileInfo;
char *aStyles[] = { "DBDBASE3", "DBDBASE4", "DBDBASE5",
                    "DBFOXBASE", "DBFOXPRO1", "DBFOXPRO2", "DBFOXPRO3",
                    "DBCLIPPER87", "DBCLIPPER5" };
char *aTypes[] = { "DBRECORDLOCK", "DBHEADERLOCK", "", "DBFILELOCK" };
DBFIELD aFields[] = { { "CHARACTER", 'C', 10, 0 },
                      { "DATE",      'D',  8, 0 },
                      { "FLOAT",     'F',  5, 2 },
                      { "LOGICAL",   'L',  1, 0 },
                      { "MEMO",      'M', 10, 0 },
                      { "NUMERIC",   'N',  5, 2 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 6, aFields, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4|DBOPENLAN );
   DBLockHeader( iDBF );
   DBGetFileInfo( iDBF, &pFileInfo );
   puts( "Open Flags:" );
   printf( "is readonly? %s\n", pFileInfo.flags.isreadonly ? "YES":"NO" );
   printf( "Is shareable? %s\n", pFileInfo.flags.isshareable ? "YES":"NO" );
   printf( "Is unbuffered? %s\n\n", pFileInfo.flags.isunbuffered ? "YES":"NO" );
   puts( "File attributes:" );
   printf( "Name is %s\n", pFileInfo.fname );
   printf( "Style is %s\n", aStyles[ pFileInfo.style-1 ] );
   printf( "Memo file attached? %s\n", pFileInfo.memo ? "YES":"NO" );
   printf( "Production index attached? %s\n", pFileInfo.mdx ? "YES":"NO" );
   printf( "Lock is %s\n", aTypes[ pFileInfo.lockt-1 ] );
   printf( "Number of locks is %d\n", pFileInfo.numlcks );
   DBUnLockHeader( iDBF );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
