/*
** EXAMP030.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iLoop, iLongestField;
DBFIELD szFieldInfo[256];

DBFIELD aFields[] = { { "CHARACTER", 'C', 10, 0 },
                      { "DATE",      'D',  8, 0 },
                      { "FLOAT",     'F',  5, 2 },
                      { "LOGICAL",   'L',  1, 0 },
                      { "MEMO",      'M', 10, 0 },
                      { "NUMERIC",   'N',  5, 2 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 6, aFields, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBGetFileDescription( iDBF, &iLongestField, szFieldInfo );
   for( iLoop = 0; iLoop < 6; iLoop++ )
   {
      printf( "%10s %c %2d %2d\n", szFieldInfo[ iLoop ].name,
                               szFieldInfo[ iLoop ].type,
                               szFieldInfo[ iLoop ].len,
                               szFieldInfo[ iLoop ].decpl );
   }
   printf( "\nLongest field length is %d", iLongestField );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
