/*
** L1DEM023.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iCDX, iLoop, iLength;
long lTag1, lTag2, lRecNo;
FILE *pFile;
char *pString, szLine[81], szKey[11];
double dDouble;

DBFIELD Fields[] = { { "FIRST", 'C', 10, 0 },
                     { "LAST",  'C', 10, 0 },
                     { "ID",    'N',  5, 0 },
                     { "TIME",  'C',  5, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   pFile = fopen( "L1DEM023.TXT", "r" );

   DBCreateFile( "EXAMPLE.DBF", 4, Fields, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBFOXPRO2 );

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      fgets( szLine, 81, pFile );
      iLength = DBstrlen( szLine ) - 1;
      szLine[ iLength ] = 0;
      pString = DBstrmid( szLine, 11, 10 );
      DBPutNamedData( iDBF, "LAST", pString );
      DBFreeMemory( pString );
      pString = DBstrmid( szLine, 21, 5 );
      dDouble = atof( pString );
      DBFreeMemory( pString );
      DBPutNamedData( iDBF, "ID", &dDouble );
      pString = DBstrright( szLine, 5 );
      DBPutNamedData( iDBF, "TIME", pString );
      DBFreeMemory( pString );
      pString = DBstrleft( szLine, 10 );
      DBPutNamedData( iDBF, "FIRST", pString );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   }

   DBBuildTag( iDBF, iCDX, "LAST", DBCHARACTERKEY, "LAST", 10, 0, NULL, NULL, 0 );
   DBBuildTag( iDBF, iCDX, "ID", DBNUMERICKEY, "ID", 5, 0, NULL, NULL, 0 );

   DBOpenNamedTag( &lTag1, iCDX, "LAST" );
   DBSetDefaultKeyType( lTag1, DBCHARACTERKEY );
   DBOpenNamedTag( &lTag2, iCDX, "ID" );
   DBSetDefaultKeyType( lTag2, DBNUMERICKEY );

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "%ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );
   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToNumeric( lTag2, &dDouble, szKey );
      printf( "%ld %5.0f\n", lRecNo, dDouble );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   fclose( pFile );
   DBCloseIndex( iCDX );
   DBCloseFile( iDBF );
   DBTerminate();
}
