/*
** L1DEM015.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iMDX, iLoop;
long lRecNo, lTag1, lTag2;
char szDateKey[9], szSearchKey[18], szDateFld[9], *pKey;
double dSiteFld, dMalFld, dDevFld, dDateKey;
char *pDates[] = { "09/20/94", "09/16/94", "09/16/94" };
double dSiteFlds[5] = { 4, 3, 255 };
double dMalFlds[5] =  { 2, 5, 3 };
double dDevFlds[5] =  { 5, 1, 4 };

DBFIELD Fields[] = { { "DATEFLD", 'D', 8, 0 },
                     { "SITEFLD", 'N', 3, 0 },
                     { "MALFLD",  'N', 3, 0 },
                     { "DEVFLD",  'N', 3, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 4, Fields, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );

   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBOPENSTANDARD|DBDBASE4 );
   DBCreateTag( iMDX, "DATEFLD", DBDATEKEY, "DATEFLD", 8, 0, NULL );
   DBCreateTag( iMDX, "SEARCH", DBCHARACTERKEY,
      "DTOC(DATEFLD)+STR(SITEFLD,3,0)+STR(MALFLD,3,0)+STR(DEVFLD,3,0)", 18,
      0, NULL );

   DBOpenNamedTag( &lTag1, iMDX, "DATEFLD" );
   DBOpenNamedTag( &lTag2, iMDX, "SEARCH" );

   for( iLoop = 0; iLoop < 3; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, pDates[ iLoop ] );
      DBPutFieldData( iDBF, 1, &dSiteFlds[ iLoop ] );
      DBPutFieldData( iDBF, 2, &dMalFlds[ iLoop ] );
      DBPutFieldData( iDBF, 3, &dDevFlds[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
      printf( "%ld %s %3.0f %3.0f %3.0f\n", lRecNo, pDates[ iLoop ],
          dSiteFlds[ iLoop ], dMalFlds[ iLoop ], dDevFlds[ iLoop ] );
      DBDateToKey( lTag1, ( char* )&dDateKey, pDates[ iLoop ], DBGREGORIAN );
      DBInsertKey( lTag1, &dDateKey, lRecNo );
      DBMakeKey( iDBF, lTag2, ( void ** ) &pKey );
      DBInsertKey( lTag2, pKey, lRecNo );
      DBFreeMemory( pKey );
   }

   DBGoFirstKey( lTag1, szDateKey, &lRecNo );

   printf( "\nDATEFLD tag display..\n" );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToDate( lTag1, szDateKey, DBGREGORIAN, szDateKey );
      printf( "Key: %ld %s\n", lRecNo, szDateKey );
      DBGoNextKey( lTag1, szDateKey, &lRecNo );
   }

   DBGoFirstKey( lTag2, szSearchKey, &lRecNo );

   printf( "\nSEARCH tag display..\n" );

   while (DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "Key: %ld %s\n", lRecNo, szSearchKey );
      DBGoNextKey( lTag2, szSearchKey, &lRecNo );
   }

   sprintf( szSearchKey, "%s", "09/16/94255  3  4" );
   DBKeySearch( lTag2, szSearchKey, &lRecNo, DBKEYEQUAL );
   DBGetRecord( iDBF, lRecNo );
   DBGetFieldData( iDBF, 0, szDateFld );
   DBGetFieldData( iDBF, 1, &dSiteFld );
   DBGetFieldData( iDBF, 2, &dMalFld );
   DBGetFieldData( iDBF, 3, &dDevFld );

   printf( "\nRecord number found is %ld\n", lRecNo );
   printf( "Date is %s\n", szDateFld );
   printf( "Site Field is %2.0f\n", dSiteFld );
   printf( "Mal Field is %2.0f\n", dMalFld );
   printf( "Dev Field is %2.0f\n", dDevFld );

   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
}

